/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.food;

import dev.xkmc.fruitsdelight.init.food.EffectFunc;
import dev.xkmc.fruitsdelight.init.plants.Durian;
import dev.xkmc.fruitsdelight.init.plants.FDBushes;
import dev.xkmc.fruitsdelight.init.plants.FDMelons;
import dev.xkmc.fruitsdelight.init.plants.FDPineapple;
import dev.xkmc.fruitsdelight.init.plants.FDTrees;
import dev.xkmc.fruitsdelight.init.plants.FruitPlant;
import dev.xkmc.fruitsdelight.init.registrate.FDEffects;
import dev.xkmc.fruitsdelight.init.registrate.FDItems;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public enum FruitType {
    APPLE(2, 12813117, () -> Items.APPLE, List.of(new EffectFunc((Holder<MobEffect>)MobEffects.ABSORPTION, lv -> lv * 20))),
    BLUEBERRY(4, 5911231, FDBushes.BLUEBERRY, List.of(new EffectFunc((Holder<MobEffect>)MobEffects.NIGHT_VISION, lv -> lv * 20), new EffectFunc((Holder<MobEffect>)FDEffects.BRIGHTENING, lv -> lv * 20))),
    GLOWBERRY(4, 16427798, () -> Items.GLOW_BERRIES, List.of(new EffectFunc((Holder<MobEffect>)MobEffects.GLOWING, lv -> lv * 80))),
    HAMIMELON(4, 16761166, FDMelons.HAMIMELON::getSlice, List.of(new EffectFunc((Holder<MobEffect>)MobEffects.HEALTH_BOOST, lv -> lv * 20))),
    MELON(4, 13121063, () -> Items.MELON_SLICE, List.of(new EffectFunc((Holder<MobEffect>)MobEffects.REGENERATION, lv -> lv * 40))),
    HAWBERRY(4, 12524829, FDTrees.HAWBERRY, List.of(new EffectFunc((Holder<MobEffect>)FDEffects.APPETIZING, lv -> lv * 20))),
    LYCHEE(4, 0xFFF2FC, FDTrees.LYCHEE, List.of(new EffectFunc((Holder<MobEffect>)MobEffects.DAMAGE_BOOST, lv -> lv * 10, lv -> 2))),
    MANGO(2, 16757289, FDTrees.MANGO, List.of(new EffectFunc((Holder<MobEffect>)MobEffects.DAMAGE_BOOST, lv -> lv * 20, lv -> 2), new EffectFunc((Holder<MobEffect>)FDEffects.RAGE_AURA, lv -> lv * 20))),
    ORANGE(2, 16226063, FDTrees.ORANGE, List.of(new EffectFunc((Holder<MobEffect>)MobEffects.REGENERATION, lv -> lv * 20), new EffectFunc((Holder<MobEffect>)FDEffects.RECOVERING, lv -> lv * 20))),
    PEACH(2, 15172196, FDTrees.PEACH, List.of(new EffectFunc((Holder<MobEffect>)FDEffects.HEAL_AURA, lv -> lv * 10))),
    PEAR(2, 12503858, FDTrees.PEAR, List.of(new EffectFunc((Holder<MobEffect>)FDEffects.LOZENGE, lv -> lv * 20))),
    PERSIMMON(2, 14769950, FDTrees.PERSIMMON, List.of(new EffectFunc((Holder<MobEffect>)FDEffects.ASTRINGENT, lv -> lv * 80))),
    PINEAPPLE(4, 16636968, FDPineapple.PINEAPPLE::getSlice, List.of(new EffectFunc((Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, lv -> lv * 20), new EffectFunc((Holder<MobEffect>)FDEffects.SWEETENING, lv -> lv * 20))),
    LEMON(2, 16770170, FDBushes.LEMON, List.of(new EffectFunc((Holder<MobEffect>)MobEffects.DIG_SPEED, lv -> lv * 20), new EffectFunc((Holder<MobEffect>)FDEffects.REFRESHING, lv -> lv * 20))),
    CRANBERRY(4, 13575718, FDBushes.CRANBERRY, List.of(new EffectFunc((Holder<MobEffect>)FDEffects.SHRINKING, lv -> lv * 80))),
    MANGOSTEEN(2, 16510166, FDTrees.MANGOSTEEN, List.of(new EffectFunc((Holder<MobEffect>)FDEffects.SLIDING, lv -> lv * 80))),
    SWEETBERRY(4, 12851791, () -> Items.SWEET_BERRIES, List.of()),
    CHORUS(2, 13674967, () -> Items.CHORUS_FRUIT, List.of(new EffectFunc((Holder<MobEffect>)FDEffects.CHORUS, lv -> 1, lv -> 0, lv -> Math.min(1.0f, (float)lv * 0.05f)))),
    BAYBERRY(4, 5509429, FDTrees.BAYBERRY, List.of(new EffectFunc((Holder<MobEffect>)FDEffects.LEAF_PIERCING, lv -> lv * 20))),
    KIWI(2, 9033997, FDTrees.KIWI, List.of(new EffectFunc((Holder<MobEffect>)FDEffects.CYCLING, lv -> lv * 4))),
    FIG(2, 14714135, FDTrees.FIG, List.of(new EffectFunc((Holder<MobEffect>)FDEffects.DIGESTING, lv -> lv * 80))),
    DURIAN(2, 15587669, Durian::getSlice, List.of(new EffectFunc((Holder<MobEffect>)FDEffects.ALIENATING, lv -> lv * 40), new EffectFunc((Holder<MobEffect>)FDEffects.SUSPICIOUS_SMELL, lv -> lv * 80)));

    public final int color;
    public final int jamCost;
    private final Supplier<Item> fruit;
    private final TagKey<Item> tag;
    public final List<EffectFunc> eff;

    public static FruitType empty() {
        return SWEETBERRY;
    }

    private FruitType(int jamCost, @Nullable int color, Supplier<Item> fruit, TagKey<Item> tag, List<EffectFunc> eff) {
        this.jamCost = jamCost;
        this.color = 0xFF000000 | color;
        this.fruit = fruit;
        this.tag = tag;
        this.eff = eff;
    }

    private FruitType(int jamCost, int color, FruitPlant<?> plant, List<EffectFunc> eff) {
        this(jamCost, color, plant::getFruit, plant.getFruitTag(), eff);
    }

    private FruitType(int jamCost, int color, Supplier<Item> fruit, List<EffectFunc> eff) {
        this(jamCost, color, fruit, null, eff);
    }

    public Ingredient getFruitTag() {
        return this.tag == null ? Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)this.fruit.get()}) : Ingredient.of(this.tag);
    }

    public Item getFruit() {
        return this.fruit.get();
    }

    public Item getJam() {
        return FDItems.JAM[this.ordinal()].asItem();
    }

    public Item getJello() {
        return (Item)FDItems.JELLO[this.ordinal()].get();
    }
}

