/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.food;

import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.fruitsdelight.content.item.FDFoodItem;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.data.RecipeGen;
import dev.xkmc.fruitsdelight.init.entries.FruitFluid;
import dev.xkmc.fruitsdelight.init.food.EffectEntry;
import dev.xkmc.fruitsdelight.init.food.FoodType;
import dev.xkmc.fruitsdelight.init.food.FruitType;
import dev.xkmc.fruitsdelight.init.food.IFDFood;
import dev.xkmc.fruitsdelight.init.registrate.FDEffects;
import dev.xkmc.fruitsdelight.init.registrate.FDFluids;
import dev.xkmc.fruitsdelight.init.registrate.FDItems;
import dev.xkmc.l2core.serial.ingredients.PotionIngredient;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.data.builder.CookingPotRecipeBuilder;

public enum FDJuice implements IFDFood
{
    HAMIMELON_JUICE(FruitType.HAMIMELON, Type.JUICE, new EffectEntry[0]),
    HAWBERRY_TEA(FruitType.HAWBERRY, Type.TEA, new EffectEntry[0]),
    ORANGE_JUICE(FruitType.ORANGE, Type.SWEETENED, new EffectEntry[0]),
    LEMON_JUICE(FruitType.LEMON, Type.SWEETENED, new EffectEntry[0]),
    PEAR_JUICE(FruitType.PEAR, Type.SWEETENED, new EffectEntry[0]),
    MANGO_TEA(FruitType.MANGO, Type.TEA, new EffectEntry[0]),
    PEACH_TEA(FruitType.PEACH, Type.TEA, new EffectEntry[0]),
    LYCHEE_CHERRY_TEA(FruitType.LYCHEE, Type.CHERRY, new EffectEntry[0]),
    MANGOSTEEN_TEA(FruitType.MANGOSTEEN, Type.TEA, new EffectEntry[0]),
    BAYBERRY_SOUP(FruitType.BAYBERRY, Type.SOUP, new EffectEntry[0]),
    KIWI_JUICE(FruitType.KIWI, Type.JUICE, new EffectEntry[0]),
    BELLINI_COCKTAIL(FruitType.PEACH, Type.ICED, new EffectEntry((Holder<MobEffect>)FDEffects.HEAL_AURA, 200), new EffectEntry((Holder<MobEffect>)MobEffects.CONFUSION, 100));

    private final String name;
    public final FruitType fruit;
    public final Type type;
    public final ItemEntry<Item> item;
    public final EffectEntry[] effs;

    private FDJuice(@Nullable FruitType fruit, Type type, String str, EffectEntry ... effs) {
        this.fruit = fruit;
        this.type = type;
        FoodType food = FoodType.JUICE;
        this.name = this.name().toLowerCase(Locale.ROOT);
        this.item = ((ItemBuilder)FruitsDelight.REGISTRATE.item(this.name, p -> food.build((Item.Properties)p, this)).transform(b -> food.model(b, 0, fruit))).lang(str != null ? str : FDItems.toEnglishName(this.name)).tag(food.tags).register();
        this.effs = effs;
    }

    private FDJuice(FruitType fruit, Type type, EffectEntry ... effs) {
        this(fruit, type, (String)null, effs);
    }

    public static void register() {
    }

    public Ingredient getFruitTag() {
        return this.fruit.getFruitTag();
    }

    public Item getFruit() {
        return this.fruit.getFruit();
    }

    public FDFoodItem get() {
        return (FDFoodItem)this.item.get();
    }

    public FruitFluid getFluid() {
        return (FruitFluid)((Object)FDFluids.JUICE[this.ordinal()].get());
    }

    @Override
    public FruitType fruit() {
        return this.fruit;
    }

    @Override
    public FoodType getType() {
        return FoodType.JUICE;
    }

    @Override
    public EffectEntry[] getEffects() {
        return this.effs;
    }

    public void recipe(RegistrateRecipeProvider pvd) {
        int count = this.fruit.jamCost;
        if (this.type.category.cook) {
            CookingPotRecipeBuilder e = CookingPotRecipeBuilder.cookingPotRecipe(this.item, (int)1, (int)200, (float)0.1f, (ItemLike)Items.GLASS_BOTTLE);
            this.type.list.get().forEach(arg_0 -> ((CookingPotRecipeBuilder)e).addIngredient(arg_0));
            e.addIngredient(this.getFruitTag(), count);
            e.setRecipeBookTab(CookingPotRecipeBookTab.DRINKS);
            e.build((RecipeOutput)pvd);
        } else {
            ShapelessRecipeBuilder e = RecipeGen.unlock(pvd, (arg_0, arg_1) -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, this.item)).unlockedBy(arg_0, arg_1), this.getFruit());
            if (this.type.category.waterCraft) {
                e.requires(PotionIngredient.of((Holder)Potions.WATER));
            }
            this.type.list.get().forEach(arg_0 -> ((ShapelessRecipeBuilder)e).requires(arg_0));
            e.requires(this.getFruitTag(), count);
            e.save((RecipeOutput)pvd);
        }
    }

    public static enum Type {
        JUICE(Category.PLAIN, () -> List.of(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS_BOTTLE}))),
        SWEETENED(Category.RINSE, () -> List.of(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}))),
        BOILED(Category.BOIL, List::of),
        SOUP(Category.SOUP, List::of),
        TEA(Category.BOIL, () -> List.of(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}), Ingredient.of((TagKey)ItemTags.LEAVES))),
        ICED(Category.COLD_COOK, () -> List.of(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ICE}))),
        CHERRY(Category.BOIL, () -> List.of(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHERRY_LEAVES})));

        public final Category category;
        public final Supplier<List<Ingredient>> list;

        private Type(Category category, Supplier<List<Ingredient>> list) {
            this.category = category;
            this.list = list;
        }
    }

    public static enum Category {
        PLAIN(false, false, false, false),
        RINSE(false, false, true, true),
        BOIL(true, true, false, true),
        SOUP(true, true, true, true),
        COLD_COOK(true, false, false, false);

        public final boolean cook;
        public final boolean heated;
        public final boolean waterCraft;
        public final boolean waterMix;

        private Category(boolean cook, boolean heated, boolean waterCraft, boolean waterMix) {
            this.cook = cook;
            this.heated = heated;
            this.waterCraft = waterCraft;
            this.waterMix = waterMix;
        }
    }
}

