/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init;

import com.mojang.logging.LogUtils;
import com.tterrag.registrate.providers.DataProviderInitializer;
import com.tterrag.registrate.providers.ProviderType;
import dev.xkmc.fruitsdelight.compat.botanypot.BotanyGen;
import dev.xkmc.fruitsdelight.compat.create.CreateCompat;
import dev.xkmc.fruitsdelight.compat.thirst.ThirstCompat;
import dev.xkmc.fruitsdelight.events.BlockEffectToClient;
import dev.xkmc.fruitsdelight.init.data.FDBiomeTagsProvider;
import dev.xkmc.fruitsdelight.init.data.FDConfigGen;
import dev.xkmc.fruitsdelight.init.data.FDDatapackRegistriesGen;
import dev.xkmc.fruitsdelight.init.data.FDGLMProvider;
import dev.xkmc.fruitsdelight.init.data.FDModConfig;
import dev.xkmc.fruitsdelight.init.data.LangData;
import dev.xkmc.fruitsdelight.init.data.RecipeGen;
import dev.xkmc.fruitsdelight.init.data.TagGen;
import dev.xkmc.fruitsdelight.init.food.FDCauldrons;
import dev.xkmc.fruitsdelight.init.food.FDFood;
import dev.xkmc.fruitsdelight.init.food.FDJuice;
import dev.xkmc.fruitsdelight.init.food.FruitType;
import dev.xkmc.fruitsdelight.init.plants.FDBushes;
import dev.xkmc.fruitsdelight.init.plants.FDMelons;
import dev.xkmc.fruitsdelight.init.plants.FDPineapple;
import dev.xkmc.fruitsdelight.init.plants.FDTrees;
import dev.xkmc.fruitsdelight.init.plants.PlantDataEntry;
import dev.xkmc.fruitsdelight.init.registrate.FDBlocks;
import dev.xkmc.fruitsdelight.init.registrate.FDEffects;
import dev.xkmc.fruitsdelight.init.registrate.FDFluids;
import dev.xkmc.fruitsdelight.init.registrate.FDItems;
import dev.xkmc.fruitsdelight.init.registrate.FDMiscs;
import dev.xkmc.l2core.init.L2TagGen;
import dev.xkmc.l2core.init.reg.registrate.L2Registrate;
import dev.xkmc.l2core.init.reg.registrate.SimpleEntry;
import dev.xkmc.l2core.init.reg.simple.Reg;
import dev.xkmc.l2serial.network.PacketHandler;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.fluids.RegisterCauldronFluidContentEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.slf4j.Logger;

@Mod(value="fruitsdelight")
@EventBusSubscriber(modid="fruitsdelight", bus=EventBusSubscriber.Bus.MOD)
public class FruitsDelight {
    public static final String MODID = "fruitsdelight";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Reg REG = new Reg("fruitsdelight");
    public static final L2Registrate REGISTRATE = new L2Registrate("fruitsdelight");
    public static final PacketHandler HANDLER = new PacketHandler("fruitsdelight", 1, new Function[]{e -> e.create(BlockEffectToClient.class, PacketHandler.NetDir.PLAY_TO_CLIENT)});
    public static final SimpleEntry<CreativeModeTab> TAB = REGISTRATE.buildModCreativeTab("fruits_delight", "Fruits Delight", e -> e.icon(() -> FDTrees.LYCHEE.getFruit().getDefaultInstance()));

    public FruitsDelight() {
        FDTrees.register();
        FDBushes.register();
        FDMelons.register();
        FDPineapple.register();
        FDItems.register();
        FDEffects.register();
        FDJuice.register();
        FDFood.register();
        FDBlocks.register();
        FDCauldrons.register();
        FDMiscs.register();
        FDModConfig.init();
        FDGLMProvider.register();
        FDFluids.register();
    }

    public static ResourceLocation loc(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)id);
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            if (((Boolean)FDModConfig.COMMON.enableCauldronRecipe.get()).booleanValue()) {
                FDCauldrons.init();
            }
            if (ModList.get().isLoaded("create")) {
                CreateCompat.init();
            }
            if (((Boolean)FDModConfig.COMMON.enableThirstCompat.get()).booleanValue() && ModList.get().isLoaded("thirst")) {
                ThirstCompat.init();
            }
        });
    }

    @SubscribeEvent
    public static void onCauldronRegistration(RegisterCauldronFluidContentEvent event) {
        for (FruitType e : FruitType.values()) {
            event.register((Block)FDCauldrons.JAM[e.ordinal()].get(), (Fluid)FDFluids.JAM[e.ordinal()].get(), 1000, null);
            event.register((Block)FDCauldrons.JELLO[e.ordinal()].get(), (Fluid)FDFluids.JELLO[e.ordinal()].get(), 1000, null);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void gatherData(GatherDataEvent event) {
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, TagGen::onBlockTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, TagGen::onItemTagGen);
        REGISTRATE.addDataGenerator(L2TagGen.EFF_TAGS, TagGen::onEffectTagGen);
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, RecipeGen::genRecipes);
        REGISTRATE.addDataGenerator(ProviderType.LANG, LangData::genLang);
        REGISTRATE.addDataGenerator(ProviderType.DATA_MAP, PlantDataEntry::registerComposter);
        DataProviderInitializer init = REGISTRATE.getDataGenInitializer();
        init.add(Registries.CONFIGURED_FEATURE, ctx -> PlantDataEntry.gen(ctx, PlantDataEntry::registerConfigs));
        init.add(Registries.PLACED_FEATURE, ctx -> PlantDataEntry.gen(ctx, PlantDataEntry::registerPlacements));
        init.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, FDDatapackRegistriesGen::registerBiomeModifiers);
        boolean server = event.includeServer();
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture pvd = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        gen.addProvider(server, (DataProvider)new BotanyGen(output, pvd));
        gen.addProvider(server, (DataProvider)new FDConfigGen(gen, pvd));
        gen.addProvider(server, (DataProvider)new FDBiomeTagsProvider(output, pvd, helper));
        gen.addProvider(server, (DataProvider)new FDGLMProvider(output, pvd));
    }
}

