/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.item;

import com.tterrag.registrate.util.CreativeModeTabModifier;
import dev.xkmc.fruitsdelight.content.item.IFDFoodItem;
import dev.xkmc.fruitsdelight.init.data.LangData;
import dev.xkmc.fruitsdelight.init.data.TagGen;
import dev.xkmc.fruitsdelight.init.food.EffectEntry;
import dev.xkmc.fruitsdelight.init.food.EffectFunc;
import dev.xkmc.fruitsdelight.init.food.FoodType;
import dev.xkmc.fruitsdelight.init.food.FruitType;
import dev.xkmc.fruitsdelight.init.food.IFDFood;
import dev.xkmc.fruitsdelight.init.registrate.FDItems;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.Configuration;

public class FDFoodItem
extends Item
implements IFDFoodItem {
    public final IFDFood food;
    private final UseAnim anim;

    private static List<FruitType> getFruits(ItemStack stack) {
        return (List)FDItems.FRUITS.getOrDefault(stack, List.of());
    }

    private static Component getTooltip(MobEffectInstance eff) {
        MutableComponent ans = Component.translatable((String)eff.getDescriptionId());
        MobEffect mobeffect = (MobEffect)eff.getEffect().value();
        if (eff.getAmplifier() > 0) {
            ans = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{ans, Component.translatable((String)("potion.potency." + eff.getAmplifier()))});
        }
        if (eff.getDuration() > 20) {
            ans = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{ans, MobEffectUtil.formatDuration((MobEffectInstance)eff, (float)1.0f, (float)20.0f)});
        }
        return ans.withStyle(mobeffect.getCategory().getTooltipFormatting());
    }

    public static void getFoodEffects(ItemStack stack, List<Component> list) {
        FoodProperties food = stack.getFoodProperties(null);
        if (food == null) {
            return;
        }
        FDFoodItem.getFoodEffects(food, list);
    }

    public static void getFoodEffects(FoodProperties food, List<Component> list) {
        for (FoodProperties.PossibleEffect eff : food.effects()) {
            int chance = Math.round(eff.probability() * 100.0f);
            Component ans = FDFoodItem.getTooltip(eff.effect());
            if (chance == 100) {
                list.add(ans);
                continue;
            }
            list.add((Component)LangData.CHANCE_EFFECT.get(ans, chance));
        }
    }

    public static int color(ItemStack stack, int layer) {
        List<FruitType> list = FDFoodItem.getFruits(stack);
        if (layer == 0 || list.isEmpty()) {
            return -1;
        }
        return list.get((int)(layer % list.size())).color;
    }

    public static ItemStack setContent(FDFoodItem item, FruitType e) {
        return FDItems.FRUITS.set(item.getDefaultInstance(), List.of(e));
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        List<FruitType> list = FDFoodItem.getFruits(stack);
        if (!list.isEmpty()) {
            FoodProperties old = super.getFoodProperties(stack, entity);
            if (old == null) {
                return null;
            }
            FoodProperties.Builder builder = new FoodProperties.Builder();
            builder.nutrition(old.nutrition());
            builder.saturationModifier(old.saturation());
            if (old.canAlwaysEat()) {
                builder.alwaysEdible();
            }
            if (old.eatSeconds() < 1.0f) {
                builder.fast();
            }
            if (this.food == null) {
                return null;
            }
            LinkedHashMap<FruitType, Integer> map = new LinkedHashMap<FruitType, Integer>();
            map.put(this.food.fruit(), this.food.getType().effectLevel);
            int lv = FoodType.JAM.effectLevel;
            for (FruitType fruitType : list) {
                map.compute(fruitType, (k, v) -> v == null ? lv : v + lv);
            }
            for (Map.Entry entry : map.entrySet()) {
                for (EffectFunc effectFunc : ((FruitType)((Object)entry.getKey())).eff) {
                    builder.effect(() -> effectFunc.getEffect((Integer)entry.getValue()), effectFunc.getChance((Integer)entry.getValue()));
                }
            }
            for (Iterator<Object> iterator : this.food.getEffects()) {
                builder.effect(() -> iterator.getEffect(), ((EffectEntry)((Object)iterator)).chance());
            }
            return builder.build();
        }
        return super.getFoodProperties(stack, entity);
    }

    public FDFoodItem(Item.Properties props, IFDFood food, UseAnim anim) {
        super(props);
        this.food = food;
        this.anim = anim;
    }

    public FDFoodItem(Item.Properties props, IFDFood food) {
        this(props, food, UseAnim.EAT);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return this.anim;
    }

    public SoundEvent getDrinkingSound() {
        if (this.food != null && this.food.getType() == FoodType.JAM) {
            return SoundEvents.HONEY_DRINK;
        }
        return SoundEvents.GENERIC_DRINK;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        List<FruitType> types = FDFoodItem.getFruits(stack);
        if (!types.isEmpty()) {
            list.add((Component)LangData.JAM_CONTENT.get(new Object[0]));
            for (FruitType type : types) {
                list.add((Component)type.getJam().getDescription().copy().withStyle(ChatFormatting.GRAY));
            }
        } else if (stack.is(TagGen.ALLOW_JAM)) {
            list.add((Component)LangData.ALLOW_JAM.get(new Object[0]));
        }
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            FDFoodItem.getFoodEffects(stack, list);
        }
    }

    public void fillItemCategory(int size, CreativeModeTabModifier tab) {
        for (FruitType fruit : FruitType.values()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            ArrayList<FruitType> list = new ArrayList<FruitType>();
            for (int i = 0; i < size; ++i) {
                list.add(fruit);
            }
            tab.accept(FDItems.FRUITS.set(stack, list));
        }
    }

    @Override
    public IFDFood food() {
        return this.food;
    }
}

