/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.cauldrons;

import com.mojang.serialization.MapCodec;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import dev.xkmc.fruitsdelight.content.cauldrons.CauldronRenderHandler;
import dev.xkmc.fruitsdelight.content.cauldrons.FDCauldronInteraction;
import dev.xkmc.fruitsdelight.content.cauldrons.JamCauldronBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ModTags;

public class FDCauldronBlock
extends AbstractCauldronBlock {
    private final CauldronInteraction.InteractionMap interactions;

    private FDCauldronBlock(BlockBehaviour.Properties properties, CauldronInteraction.InteractionMap interactions) {
        super(properties, interactions);
        this.interactions = interactions;
    }

    public CauldronInteraction.InteractionMap getInteractions() {
        return this.interactions;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double z;
        double y;
        double x;
        if (!level.getBlockState(pos.below()).is(ModTags.HEAT_SOURCES)) {
            return;
        }
        if (random.nextFloat() < 0.5f) {
            x = (double)pos.getX() + 0.5 + (random.nextDouble() * 0.6 - 0.3);
            y = (double)pos.getY() + 0.95;
            z = (double)pos.getZ() + 0.5 + (random.nextDouble() * 0.6 - 0.3);
            level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, x, y, z, 0.0, 0.0, 0.0);
        }
        if (random.nextFloat() < 0.05f) {
            x = (double)pos.getX() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
            y = (double)pos.getY() + 0.5;
            z = (double)pos.getZ() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
            double motionY = random.nextBoolean() ? 0.015 : 0.005;
            level.addParticle((ParticleOptions)ModParticleTypes.STEAM.get(), x, y, z, 0.0, motionY, 0.0);
        }
        SoundEvent boilSound = this instanceof JamCauldronBlock ? (SoundEvent)ModSounds.BLOCK_COOKING_POT_BOIL_SOUP.get() : (SoundEvent)ModSounds.BLOCK_COOKING_POT_BOIL.get();
        double x2 = (double)pos.getX() + 0.5;
        double y2 = pos.getY();
        double z2 = (double)pos.getZ() + 0.5;
        if (random.nextInt(10) == 0) {
            level.playLocalSound(x2, y2, z2, boilSound, SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.2f + 0.9f, false);
        }
    }

    public FDCauldronBlock(BlockBehaviour.Properties properties, String name) {
        this(properties, CauldronInteraction.newInteractionMap((String)name));
    }

    protected double getContentHeight(BlockState state) {
        return 0.9375;
    }

    public boolean isFull(BlockState state) {
        return true;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof ItemEntity) {
            FDCauldronInteraction act;
            CauldronInteraction action;
            ItemEntity item = (ItemEntity)entity;
            if (this.isEntityInsideContent(state, pos, entity) && (action = (CauldronInteraction)this.interactions.map().get(item.getItem().getItem())) instanceof FDCauldronInteraction && (act = (FDCauldronInteraction)action).perform(state, level, pos, item.getItem()) && !level.isClientSide) {
                ItemStack remain = item.getItem().getCraftingRemainingItem();
                item.getItem().shrink(1);
                if (item.getItem().isEmpty()) {
                    item.discard();
                }
                if (!act.result().isEmpty()) {
                    Block.popResource((Level)level, (BlockPos)pos, (ItemStack)act.result().getItem().getDefaultInstance());
                    level.playSound(null, entity, act.sound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (!remain.isEmpty()) {
                    Block.popResource((Level)level, (BlockPos)pos, (ItemStack)remain);
                }
            }
        }
    }

    public <T extends FDCauldronBlock> void build(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider pvd) {
        pvd.simpleBlock((Block)ctx.get(), (ModelFile)CauldronRenderHandler.guiAndTexture((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent(ctx.getName(), "block/template_cauldron_full")).texture("content", "minecraft:block/water_still")));
    }

    protected MapCodec<? extends AbstractCauldronBlock> codec() {
        return null;
    }
}

