/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.net.EditConfigPacket;
import dev.ftb.mods.ftblibrary.net.EditNBTPacket;
import dev.ftb.mods.ftblibrary.ui.misc.UITesting;
import dev.ftb.mods.ftblibrary.util.ModUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;

public class FTBLibraryCommands {
    public static final Map<UUID, CompoundTag> EDITING_NBT = new HashMap<UUID, CompoundTag>();

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection type) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ftblibrary").then(((LiteralArgumentBuilder)Commands.literal((String)"gamemode").requires(commandSource -> commandSource.hasPermission(2))).executes(context -> {
            if (!((CommandSourceStack)context.getSource()).getPlayerOrException().isCreative()) {
                ((CommandSourceStack)context.getSource()).getPlayerOrException().setGameMode(GameType.CREATIVE);
            } else {
                ((CommandSourceStack)context.getSource()).getPlayerOrException().setGameMode(GameType.SURVIVAL);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"rain").requires(commandSource -> commandSource.hasPermission(2))).executes(context -> {
            if (((CommandSourceStack)context.getSource()).getServer().overworld().isRaining()) {
                ((CommandSourceStack)context.getSource()).getServer().overworld().setWeatherParameters(6000, 0, false, false);
            } else {
                ((CommandSourceStack)context.getSource()).getServer().overworld().setWeatherParameters(0, 6000, true, false);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"day").requires(commandSource -> commandSource.hasPermission(2))).executes(context -> {
            long addDay = (24000L - ((CommandSourceStack)context.getSource()).getLevel().getDayTime() % 24000L + 6000L) % 24000L;
            if (addDay != 0L) {
                for (ServerLevel world : ((CommandSourceStack)context.getSource()).getServer().getAllLevels()) {
                    world.setDayTime(world.getDayTime() + addDay);
                }
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"night").requires(commandSource -> commandSource.hasPermission(2))).executes(context -> {
            long addDay = (24000L - ((CommandSourceStack)context.getSource()).getLevel().getDayTime() % 24000L + 18000L) % 24000L;
            if (addDay != 0L) {
                for (ServerLevel world : ((CommandSourceStack)context.getSource()).getServer().getAllLevels()) {
                    world.setDayTime(world.getDayTime() + addDay);
                }
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nbtedit").requires(commandSource -> commandSource.hasPermission(2))).then(Commands.literal((String)"block").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<CommandSourceStack>)context, (info, tag) -> FTBLibraryCommands.editBlockNBT((CommandContext<CommandSourceStack>)context, info, tag)))))).then(Commands.literal((String)"entity").then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<CommandSourceStack>)context, (info, tag) -> FTBLibraryCommands.editEntityNBT((CommandContext<CommandSourceStack>)context, info, tag)))))).then(Commands.literal((String)"player").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<CommandSourceStack>)context, (info, tag) -> FTBLibraryCommands.editPlayerNBT((CommandContext<CommandSourceStack>)context, info, tag)))))).then(Commands.literal((String)"item").executes(context -> FTBLibraryCommands.editNBT((CommandContext<CommandSourceStack>)context, (info, tag) -> FTBLibraryCommands.editItemNBT((CommandContext<CommandSourceStack>)context, info, tag)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"clientconfig").requires(CommandSourceStack::isPlayer)).executes(context -> {
            NetworkManager.sendToPlayer((ServerPlayer)((CommandSourceStack)context.getSource()).getPlayerOrException(), (CustomPacketPayload)new EditConfigPacket("ftblibrary-client"));
            return 1;
        }));
        if (ModUtils.isDevMode()) {
            command.then(Commands.literal((String)"test_screen").executes(context -> {
                if (((CommandSourceStack)context.getSource()).getServer().isDedicatedServer()) {
                    ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Can't do this on dedicated server!").withStyle(ChatFormatting.RED));
                } else {
                    UITesting.openTestScreen();
                }
                return 1;
            }));
            command.then(((LiteralArgumentBuilder)Commands.literal((String)"serverconfig").requires(cs -> cs.hasPermission(2))).executes(context -> {
                NetworkManager.sendToPlayer((ServerPlayer)((CommandSourceStack)context.getSource()).getPlayerOrException(), (CustomPacketPayload)new EditConfigPacket("ftblibrary-server"));
                return 1;
            }));
        }
        dispatcher.register(command);
    }

    private static int editNBT(CommandContext<CommandSourceStack> context, NBTEditCallback data) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        CompoundTag info = new CompoundTag();
        CompoundTag tag = new CompoundTag();
        data.accept(info, tag);
        if (!info.isEmpty()) {
            EDITING_NBT.put(player.getUUID(), info);
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new EditNBTPacket(info, tag));
            return 1;
        }
        return 0;
    }

    private static void editItemNBT(CommandContext<CommandSourceStack> context, CompoundTag info, CompoundTag tag) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        info.putString("type", "item");
        Tag res = player.getItemInHand(InteractionHand.MAIN_HAND).save((HolderLookup.Provider)player.level().registryAccess(), (Tag)tag);
        if (res instanceof CompoundTag) {
            CompoundTag t = (CompoundTag)res;
            tag.merge(t);
        }
    }

    private static void editPlayerNBT(CommandContext<CommandSourceStack> context, CompoundTag info, CompoundTag tag) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        info.putString("type", "player");
        info.putUUID("id", player.getUUID());
        player.saveWithoutId(tag);
        tag.remove("id");
        info.put("text", (Tag)InfoBuilder.create(context).add((Component)Component.literal((String)"Name"), player.getName()).add((Component)Component.literal((String)"Display Name"), player.getDisplayName()).add((Component)Component.literal((String)"UUID"), (Component)Component.literal((String)player.getUUID().toString())).build());
        info.putString("title", Component.Serializer.toJson((Component)player.getDisplayName(), (HolderLookup.Provider)player.level().registryAccess()));
    }

    private static void editEntityNBT(CommandContext<CommandSourceStack> context, CompoundTag info, CompoundTag tag) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)"entity");
        if (entity instanceof Player) {
            return;
        }
        info.putString("type", "entity");
        info.putInt("id", entity.getId());
        entity.save(tag);
        ResourceLocation key = RegistrarManager.getId((Object)entity.getType(), (ResourceKey)Registries.ENTITY_TYPE);
        info.put("text", (Tag)InfoBuilder.create(context).add((Component)Component.literal((String)"Class"), (Component)Component.literal((String)entity.getClass().getName())).add((Component)Component.literal((String)"ID"), (Component)Component.literal((String)(key == null ? "null" : key.toString()))).add((Component)Component.literal((String)"Mod"), (Component)Component.literal((String)(key == null ? "null" : Platform.getOptionalMod((String)key.getNamespace()).map(Mod::getName).orElse("Unknown")))).build());
        info.putString("title", Component.Serializer.toJson((Component)entity.getDisplayName(), (HolderLookup.Provider)entity.level().registryAccess()));
    }

    private static void editBlockNBT(CommandContext<CommandSourceStack> context, CompoundTag info, CompoundTag tag) throws CommandSyntaxException {
        Component title;
        BlockPos pos = BlockPosArgument.getSpawnablePos(context, (String)"pos");
        BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).getLevel().getBlockEntity(pos);
        if (blockEntity == null) {
            return;
        }
        info.putString("type", "block");
        info.putInt("x", pos.getX());
        info.putInt("y", pos.getY());
        info.putInt("z", pos.getZ());
        tag.merge(blockEntity.saveWithFullMetadata((HolderLookup.Provider)((CommandSourceStack)context.getSource()).getLevel().registryAccess()));
        tag.remove("x");
        tag.remove("y");
        tag.remove("z");
        info.putString("id", tag.getString("id"));
        tag.remove("id");
        ResourceLocation key = RegistrarManager.getId((Object)blockEntity.getType(), (ResourceKey)Registries.BLOCK_ENTITY_TYPE);
        info.put("text", (Tag)InfoBuilder.create(context).add((Component)Component.literal((String)"Class"), (Component)Component.literal((String)blockEntity.getClass().getName())).add((Component)Component.literal((String)"ID"), (Component)Component.literal((String)(key == null ? "null" : key.toString()))).add((Component)Component.literal((String)"Block"), (Component)Component.literal((String)String.valueOf(RegistrarManager.getId((Object)blockEntity.getBlockState().getBlock(), (ResourceKey)Registries.BLOCK)))).add((Component)Component.literal((String)"Block Class"), (Component)Component.literal((String)blockEntity.getBlockState().getBlock().getClass().getName())).add((Component)Component.literal((String)"Position"), (Component)Component.literal((String)("[" + pos.getX() + ", " + pos.getY() + ", " + pos.getZ() + "]"))).add((Component)Component.literal((String)"Mod"), (Component)Component.literal((String)(key == null ? "null" : Platform.getOptionalMod((String)key.getNamespace()).map(Mod::getName).orElse("Unknown")))).add((Component)Component.literal((String)"Ticking"), (Component)Component.literal((String)(blockEntity instanceof TickingBlockEntity ? "true" : "false"))).build());
        Component component = title = blockEntity instanceof Nameable ? ((Nameable)blockEntity).getDisplayName() : null;
        if (title == null) {
            title = Component.literal((String)blockEntity.getClass().getSimpleName());
        }
        info.putString("title", Component.Serializer.toJson((Component)title, (HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess()));
    }

    private static interface NBTEditCallback {
        public void accept(CompoundTag var1, CompoundTag var2) throws CommandSyntaxException;
    }

    private record InfoBuilder(ListTag list, HolderLookup.Provider provider) {
        static InfoBuilder create(CommandContext<CommandSourceStack> context) {
            return new InfoBuilder(new ListTag(), (HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess());
        }

        private InfoBuilder add(Component key, Component value) {
            this.list.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)key.copy().withStyle(ChatFormatting.BLUE).append(": ").append((Component)value.copy().withStyle(ChatFormatting.GOLD)), (HolderLookup.Provider)this.provider)));
            return this;
        }

        private ListTag build() {
            return this.list;
        }
    }
}

