/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.AddSectionGeometryEvent;
import net.neoforged.neoforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class SectionCompiler {
    private final BlockRenderDispatcher blockRenderer;
    private final BlockEntityRenderDispatcher blockEntityRenderer;

    public SectionCompiler(BlockRenderDispatcher p_350768_, BlockEntityRenderDispatcher p_350715_) {
        this.blockRenderer = p_350768_;
        this.blockEntityRenderer = p_350715_;
    }

    public Results compile(SectionPos p_350790_, RenderChunkRegion p_350782_, VertexSorting p_350635_, SectionBufferBuilderPack p_350612_) {
        return this.compile(p_350790_, p_350782_, p_350635_, p_350612_, List.of());
    }

    public Results compile(SectionPos p_350790_, RenderChunkRegion p_350782_, VertexSorting p_350635_, SectionBufferBuilderPack p_350612_, List<AddSectionGeometryEvent.AdditionalSectionRenderer> additionalRenderers) {
        Results sectioncompiler$results = new Results();
        BlockPos blockpos = p_350790_.origin();
        BlockPos blockpos1 = blockpos.offset(15, 15, 15);
        VisGraph visgraph = new VisGraph();
        PoseStack posestack = new PoseStack();
        ModelBlockRenderer.enableCaching();
        Reference2ObjectArrayMap map = new Reference2ObjectArrayMap(RenderType.chunkBufferLayers().size());
        RandomSource randomsource = RandomSource.create();
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)blockpos, (BlockPos)blockpos1)) {
            FluidState fluidstate;
            BlockEntity blockentity;
            BlockState blockstate = p_350782_.getBlockState(blockPos);
            if (blockstate.isSolidRender(p_350782_, blockPos)) {
                visgraph.setOpaque(blockPos);
            }
            if (blockstate.hasBlockEntity() && (blockentity = p_350782_.getBlockEntity(blockPos)) != null) {
                this.handleBlockEntity(sectioncompiler$results, blockentity);
            }
            if (!(fluidstate = blockstate.getFluidState()).isEmpty()) {
                RenderType rendertype = ItemBlockRenderTypes.getRenderLayer(fluidstate);
                BufferBuilder bufferbuilder = this.getOrBeginLayer((Map<RenderType, BufferBuilder>)map, p_350612_, rendertype);
                this.blockRenderer.renderLiquid(blockPos, p_350782_, (VertexConsumer)bufferbuilder, blockstate, fluidstate);
            }
            if (blockstate.getRenderShape() != RenderShape.MODEL) continue;
            BakedModel model = this.blockRenderer.getBlockModel(blockstate);
            ModelData modelData = p_350782_.getModelData(blockPos);
            modelData = model.getModelData(p_350782_, blockPos, blockstate, modelData);
            randomsource.setSeed(blockstate.getSeed(blockPos));
            for (RenderType rendertype2 : model.getRenderTypes(blockstate, randomsource, modelData)) {
                BufferBuilder bufferbuilder1 = this.getOrBeginLayer((Map<RenderType, BufferBuilder>)map, p_350612_, rendertype2);
                posestack.pushPose();
                posestack.translate(SectionPos.sectionRelative((int)blockPos.getX()), SectionPos.sectionRelative((int)blockPos.getY()), SectionPos.sectionRelative((int)blockPos.getZ()));
                this.blockRenderer.renderBatched(blockstate, blockPos, p_350782_, posestack, (VertexConsumer)bufferbuilder1, true, randomsource, modelData, rendertype2);
                posestack.popPose();
            }
        }
        ClientHooks.addAdditionalGeometry(additionalRenderers, arg_0 -> this.lambda$compile$0((Map)map, p_350612_, arg_0), (RenderChunkRegion)p_350782_, (PoseStack)posestack);
        for (Map.Entry entry : map.entrySet()) {
            RenderType rendertype1 = (RenderType)((Object)entry.getKey());
            MeshData meshdata = ((BufferBuilder)entry.getValue()).build();
            if (meshdata == null) continue;
            if (rendertype1 == RenderType.translucent()) {
                sectioncompiler$results.transparencyState = meshdata.sortQuads(p_350612_.buffer(RenderType.translucent()), p_350635_);
            }
            sectioncompiler$results.renderedLayers.put(rendertype1, meshdata);
        }
        ModelBlockRenderer.clearCache();
        sectioncompiler$results.visibilitySet = visgraph.resolve();
        return sectioncompiler$results;
    }

    private BufferBuilder getOrBeginLayer(Map<RenderType, BufferBuilder> p_350651_, SectionBufferBuilderPack p_350965_, RenderType p_350494_) {
        BufferBuilder bufferbuilder = p_350651_.get((Object)p_350494_);
        if (bufferbuilder == null) {
            ByteBufferBuilder bytebufferbuilder = p_350965_.buffer(p_350494_);
            bufferbuilder = new BufferBuilder(bytebufferbuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
            p_350651_.put(p_350494_, bufferbuilder);
        }
        return bufferbuilder;
    }

    private <E extends BlockEntity> void handleBlockEntity(Results p_350754_, E p_350386_) {
        BlockEntityRenderer blockentityrenderer = this.blockEntityRenderer.getRenderer(p_350386_);
        if (blockentityrenderer != null) {
            if (blockentityrenderer.shouldRenderOffScreen(p_350386_)) {
                p_350754_.globalBlockEntities.add(p_350386_);
            } else {
                p_350754_.blockEntities.add(p_350386_);
            }
        }
    }

    private /* synthetic */ VertexConsumer lambda$compile$0(Map map, SectionBufferBuilderPack p_350612_, RenderType type) {
        return this.getOrBeginLayer(map, p_350612_, type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Results {
        public final List<BlockEntity> globalBlockEntities = new ArrayList<BlockEntity>();
        public final List<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
        public final Map<RenderType, MeshData> renderedLayers = new Reference2ObjectArrayMap();
        public VisibilitySet visibilitySet = new VisibilitySet();
        @Nullable
        public MeshData.SortState transparencyState;

        public void release() {
            this.renderedLayers.values().forEach(MeshData::close);
        }
    }
}

