/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemTransforms {
    public static final ItemTransforms NO_TRANSFORMS = new ItemTransforms();
    public final ItemTransform thirdPersonLeftHand;
    public final ItemTransform thirdPersonRightHand;
    public final ItemTransform firstPersonLeftHand;
    public final ItemTransform firstPersonRightHand;
    public final ItemTransform head;
    public final ItemTransform gui;
    public final ItemTransform ground;
    public final ItemTransform fixed;
    public final ImmutableMap<ItemDisplayContext, ItemTransform> moddedTransforms;

    private ItemTransforms() {
        this(ItemTransform.NO_TRANSFORM, ItemTransform.NO_TRANSFORM, ItemTransform.NO_TRANSFORM, ItemTransform.NO_TRANSFORM, ItemTransform.NO_TRANSFORM, ItemTransform.NO_TRANSFORM, ItemTransform.NO_TRANSFORM, ItemTransform.NO_TRANSFORM);
    }

    public ItemTransforms(ItemTransforms p_111807_) {
        this.thirdPersonLeftHand = p_111807_.thirdPersonLeftHand;
        this.thirdPersonRightHand = p_111807_.thirdPersonRightHand;
        this.firstPersonLeftHand = p_111807_.firstPersonLeftHand;
        this.firstPersonRightHand = p_111807_.firstPersonRightHand;
        this.head = p_111807_.head;
        this.gui = p_111807_.gui;
        this.ground = p_111807_.ground;
        this.fixed = p_111807_.fixed;
        this.moddedTransforms = p_111807_.moddedTransforms;
    }

    @Deprecated
    public ItemTransforms(ItemTransform p_111798_, ItemTransform p_111799_, ItemTransform p_111800_, ItemTransform p_111801_, ItemTransform p_111802_, ItemTransform p_111803_, ItemTransform p_111804_, ItemTransform p_111805_) {
        this(p_111798_, p_111799_, p_111800_, p_111801_, p_111802_, p_111803_, p_111804_, p_111805_, (ImmutableMap<ItemDisplayContext, ItemTransform>)ImmutableMap.of());
    }

    public ItemTransforms(ItemTransform p_111798_, ItemTransform p_111799_, ItemTransform p_111800_, ItemTransform p_111801_, ItemTransform p_111802_, ItemTransform p_111803_, ItemTransform p_111804_, ItemTransform p_111805_, ImmutableMap<ItemDisplayContext, ItemTransform> moddedTransforms) {
        this.thirdPersonLeftHand = p_111798_;
        this.thirdPersonRightHand = p_111799_;
        this.firstPersonLeftHand = p_111800_;
        this.firstPersonRightHand = p_111801_;
        this.head = p_111802_;
        this.gui = p_111803_;
        this.ground = p_111804_;
        this.fixed = p_111805_;
        this.moddedTransforms = moddedTransforms;
    }

    public ItemTransform getTransform(ItemDisplayContext p_270619_) {
        if (p_270619_.isModded()) {
            ItemTransform moddedTransform = (ItemTransform)this.moddedTransforms.get((Object)p_270619_);
            if (moddedTransform != null) {
                return moddedTransform;
            }
            ItemDisplayContext moddedFallback = p_270619_.fallback();
            if (moddedFallback == null) {
                return ItemTransform.NO_TRANSFORM;
            }
            p_270619_ = moddedFallback;
        }
        return switch (p_270619_) {
            case ItemDisplayContext.THIRD_PERSON_LEFT_HAND -> this.thirdPersonLeftHand;
            case ItemDisplayContext.THIRD_PERSON_RIGHT_HAND -> this.thirdPersonRightHand;
            case ItemDisplayContext.FIRST_PERSON_LEFT_HAND -> this.firstPersonLeftHand;
            case ItemDisplayContext.FIRST_PERSON_RIGHT_HAND -> this.firstPersonRightHand;
            case ItemDisplayContext.HEAD -> this.head;
            case ItemDisplayContext.GUI -> this.gui;
            case ItemDisplayContext.GROUND -> this.ground;
            case ItemDisplayContext.FIXED -> this.fixed;
            default -> ItemTransform.NO_TRANSFORM;
        };
    }

    public boolean hasTransform(ItemDisplayContext p_270365_) {
        return this.getTransform(p_270365_) != ItemTransform.NO_TRANSFORM;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<ItemTransforms> {
        public ItemTransforms deserialize(JsonElement p_111820_, Type p_111821_, JsonDeserializationContext p_111822_) throws JsonParseException {
            JsonObject jsonobject = p_111820_.getAsJsonObject();
            ItemTransform itemtransform = this.getTransform(p_111822_, jsonobject, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND);
            ItemTransform itemtransform1 = this.getTransform(p_111822_, jsonobject, ItemDisplayContext.THIRD_PERSON_LEFT_HAND);
            if (itemtransform1 == ItemTransform.NO_TRANSFORM) {
                itemtransform1 = itemtransform;
            }
            ItemTransform itemtransform2 = this.getTransform(p_111822_, jsonobject, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND);
            ItemTransform itemtransform3 = this.getTransform(p_111822_, jsonobject, ItemDisplayContext.FIRST_PERSON_LEFT_HAND);
            if (itemtransform3 == ItemTransform.NO_TRANSFORM) {
                itemtransform3 = itemtransform2;
            }
            ItemTransform itemtransform4 = this.getTransform(p_111822_, jsonobject, ItemDisplayContext.HEAD);
            ItemTransform itemtransform5 = this.getTransform(p_111822_, jsonobject, ItemDisplayContext.GUI);
            ItemTransform itemtransform6 = this.getTransform(p_111822_, jsonobject, ItemDisplayContext.GROUND);
            ItemTransform itemtransform7 = this.getTransform(p_111822_, jsonobject, ItemDisplayContext.FIXED);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ItemDisplayContext type : ItemDisplayContext.values()) {
                if (!type.isModded()) continue;
                ItemTransform transform = this.getTransform(p_111822_, jsonobject, type);
                ItemDisplayContext fallbackType = type;
                while (transform == ItemTransform.NO_TRANSFORM && fallbackType.fallback() != null) {
                    fallbackType = fallbackType.fallback();
                    transform = this.getTransform(p_111822_, jsonobject, fallbackType);
                }
                if (transform == ItemTransform.NO_TRANSFORM) continue;
                builder.put((Object)type, (Object)transform);
            }
            return new ItemTransforms(itemtransform1, itemtransform, itemtransform3, itemtransform2, itemtransform4, itemtransform5, itemtransform6, itemtransform7, (ImmutableMap<ItemDisplayContext, ItemTransform>)builder.build());
        }

        private ItemTransform getTransform(JsonDeserializationContext p_270385_, JsonObject p_270436_, ItemDisplayContext p_270100_) {
            String s = p_270100_.getSerializedName();
            return p_270436_.has(s) ? (ItemTransform)p_270385_.deserialize(p_270436_.get(s), ItemTransform.class) : ItemTransform.NO_TRANSFORM;
        }
    }
}

