/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.recipe.architectscutter;

import com.google.common.collect.Lists;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockManager;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.recipe.ModRecipeSerializers;
import com.ldtteam.domumornamentum.recipe.ModRecipeTypes;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ArchitectsCutterRecipe
implements Recipe<ArchitectsCutterRecipeInput> {
    public static final MapCodec<ArchitectsCutterRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BuiltInRegistries.BLOCK.holderByNameCodec().fieldOf("block").forGetter(rec -> rec.getBlock().builtInRegistryHolder()), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("count", (Object)1).forGetter(ArchitectsCutterRecipe::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ArchitectsCutterRecipe::getComponentPatch)).apply((Applicative)builder, ArchitectsCutterRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ArchitectsCutterRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ArchitectsCutterRecipe::getBlockName, (StreamCodec)ByteBufCodecs.VAR_INT, ArchitectsCutterRecipe::getCount, (StreamCodec)DataComponentPatch.STREAM_CODEC, ArchitectsCutterRecipe::getComponentPatch, ArchitectsCutterRecipe::new);
    private final ResourceLocation blockName;
    private final int count;
    private final DataComponentPatch componentMap;

    public ArchitectsCutterRecipe(ResourceLocation blockName, int count, DataComponentPatch componentMap) {
        this.blockName = blockName;
        this.count = count;
        this.componentMap = componentMap;
    }

    public ArchitectsCutterRecipe(Holder<Block> block, int count, DataComponentPatch componentMap) {
        this(((ResourceKey)block.unwrapKey().orElseThrow()).location(), count, componentMap);
    }

    public ResourceLocation getBlockName() {
        return this.blockName;
    }

    public Block getBlock() {
        return (Block)BuiltInRegistries.BLOCK.get(this.blockName);
    }

    public boolean matches(@NotNull ArchitectsCutterRecipeInput inv, @NotNull Level worldIn) {
        Block generatedBlock = this.getBlock();
        if (!(generatedBlock instanceof IMateriallyTexturedBlock)) {
            return false;
        }
        IMateriallyTexturedBlock materiallyTexturedBlock = (IMateriallyTexturedBlock)generatedBlock;
        ArrayList components = Lists.newArrayList(materiallyTexturedBlock.getComponents());
        for (int componentsIndex = 0; componentsIndex < components.size(); ++componentsIndex) {
            IMateriallyTexturedBlockComponent component = (IMateriallyTexturedBlockComponent)components.get(componentsIndex);
            ItemStack itemStackInSlot = inv.getItem(componentsIndex);
            Item item = itemStackInSlot.getItem();
            if (!(item instanceof BlockItem)) {
                return false;
            }
            BlockItem blockItem = (BlockItem)item;
            Block blockInSlot = blockItem.getBlock();
            if (blockInSlot.defaultBlockState().is(component.getValidSkins())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack assemble(@NotNull ArchitectsCutterRecipeInput inv, HolderLookup.Provider provider) {
        Block generatedBlock = this.getBlock();
        if (!(generatedBlock instanceof IMateriallyTexturedBlock)) {
            return ItemStack.EMPTY;
        }
        IMateriallyTexturedBlock materiallyTexturedBlock = (IMateriallyTexturedBlock)generatedBlock;
        ArrayList components = Lists.newArrayList(materiallyTexturedBlock.getComponents());
        MaterialTextureData.Builder textureData = MaterialTextureData.builder();
        for (int componentsIndex = 0; componentsIndex < components.size(); ++componentsIndex) {
            IMateriallyTexturedBlockComponent component = (IMateriallyTexturedBlockComponent)components.get(componentsIndex);
            ItemStack itemStackInSlot = inv.getItem(componentsIndex);
            if (itemStackInSlot.isEmpty() && component.isOptional()) continue;
            Item item = itemStackInSlot.getItem();
            if (!(item instanceof BlockItem)) {
                return ItemStack.EMPTY;
            }
            BlockItem blockItem = (BlockItem)item;
            Block blockInSlot = blockItem.getBlock();
            if (!blockInSlot.defaultBlockState().is(component.getValidSkins())) {
                return ItemStack.EMPTY;
            }
            textureData.setComponent(component.getId(), blockInSlot);
        }
        ItemStack result = new ItemStack((ItemLike)generatedBlock);
        textureData.writeToItemStack(result);
        result.setCount(Math.max(components.size(), this.count));
        result.applyComponents(this.componentMap);
        return result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height <= IMateriallyTexturedBlockManager.getInstance().getMaxTexturableComponentCount();
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        Block generatedBlock = this.getBlock();
        if (!(generatedBlock instanceof IMateriallyTexturedBlock)) {
            return ItemStack.EMPTY;
        }
        ItemStack result = new ItemStack((ItemLike)generatedBlock);
        result.applyComponents(this.componentMap);
        return result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.ARCHITECTS_CUTTER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.ARCHITECTS_CUTTER.get();
    }

    @NotNull
    public DataComponentPatch getComponentPatch() {
        return this.componentMap;
    }

    public int getCount() {
        return this.count;
    }
}

