/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.item.decoration;

import com.google.common.collect.ImmutableList;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.decorative.ShingleBlock;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.item.BlockItemWithClientBePlacement;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.domumornamentum.util.Constants;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ShingleBlockItem
extends BlockItemWithClientBePlacement
implements IDoItem {
    private final ShingleBlock shingleBlock;

    public ShingleBlockItem(ShingleBlock blockIn, Item.Properties builder) {
        super(blockIn, builder);
        this.shingleBlock = blockIn;
    }

    @NotNull
    public Component getName(ItemStack stack) {
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(stack);
        IMateriallyTexturedBlockComponent coverComponent = (IMateriallyTexturedBlockComponent)this.shingleBlock.getComponents().get(0);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(coverComponent.getId(), coverComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        return Component.translatable((String)("domum_ornamentum.shingle.name.format." + stack.getItem().getDescriptionId()), (Object[])new Object[]{centerBlockName});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.origin.tooltip"));
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(stack);
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(stack);
        }
        IMateriallyTexturedBlockComponent mainComponent = (IMateriallyTexturedBlockComponent)this.shingleBlock.getComponents().get(0);
        Block mainBlock = textureData.getTexturedComponents().getOrDefault(mainComponent.getId(), mainComponent.getDefault());
        Component mainBlockName = BlockUtils.getHoverName(mainBlock);
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.desc.shingle", (Object[])new Object[]{Component.translatable((String)"domum_ornamentum.desc.material", (Object[])new Object[]{mainBlockName})}));
        IMateriallyTexturedBlockComponent supportComponent = (IMateriallyTexturedBlockComponent)this.shingleBlock.getComponents().get(1);
        Block supportBlock = textureData.getTexturedComponents().getOrDefault(supportComponent.getId(), supportComponent.getDefault());
        Component supportBlockName = BlockUtils.getHoverName(supportBlock);
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.desc.support", (Object[])new Object[]{Component.translatable((String)"domum_ornamentum.desc.material", (Object[])new Object[]{supportBlockName})}));
    }

    @Override
    public List<ResourceLocation> getInputIds() {
        return ImmutableList.of((Object)Constants.resLocDO("shingle"), (Object)Constants.resLocDO("support"));
    }

    @Override
    public ResourceLocation getGroup() {
        return Constants.resLocDO("cshingle");
    }
}

