/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.event.handlers;

import com.ldtteam.domumornamentum.block.IModBlocks;
import com.ldtteam.domumornamentum.block.decorative.ExtraBlock;
import com.ldtteam.domumornamentum.block.types.DoorType;
import com.ldtteam.domumornamentum.block.types.FancyDoorType;
import com.ldtteam.domumornamentum.block.types.FancyTrapdoorType;
import com.ldtteam.domumornamentum.block.types.PostType;
import com.ldtteam.domumornamentum.block.types.TrapdoorType;
import com.ldtteam.domumornamentum.client.screens.ArchitectsCutterScreen;
import com.ldtteam.domumornamentum.container.ModContainerTypes;
import com.ldtteam.domumornamentum.shingles.ShingleHeightType;
import com.ldtteam.domumornamentum.util.Constants;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

@EventBusSubscriber(modid="domum_ornamentum", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModBusEventHandler {
    @SubscribeEvent
    public static void onMenuScreensRegistry(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModContainerTypes.ARCHITECTS_CUTTER.get(), ArchitectsCutterScreen::new);
    }

    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)IModBlocks.getInstance().getTrapdoor().asItem(), (ResourceLocation)Constants.TRAPDOOR_MODEL_OVERRIDE, (itemStack, clientLevel, livingEntity, i) -> ModBusEventHandler.getTypeOrdinal(itemStack, TrapdoorType.class, TrapdoorType.FULL)));
        event.enqueueWork(() -> ItemProperties.register((Item)IModBlocks.getInstance().getDoor().asItem(), (ResourceLocation)Constants.DOOR_MODEL_OVERRIDE, (itemStack, clientLevel, livingEntity, i) -> ModBusEventHandler.getTypeOrdinal(itemStack, DoorType.class, DoorType.FULL)));
        event.enqueueWork(() -> ItemProperties.register((Item)IModBlocks.getInstance().getFancyDoor().asItem(), (ResourceLocation)Constants.DOOR_MODEL_OVERRIDE, (itemStack, clientLevel, livingEntity, i) -> ModBusEventHandler.getTypeOrdinal(itemStack, FancyDoorType.class, FancyDoorType.FULL)));
        event.enqueueWork(() -> ItemProperties.register((Item)IModBlocks.getInstance().getFancyTrapdoor().asItem(), (ResourceLocation)Constants.TRAPDOOR_MODEL_OVERRIDE, (itemStack, clientLevel, livingEntity, i) -> ModBusEventHandler.getTypeOrdinal(itemStack, FancyTrapdoorType.class, FancyTrapdoorType.FULL)));
        event.enqueueWork(() -> ItemProperties.register((Item)IModBlocks.getInstance().getPanel().asItem(), (ResourceLocation)Constants.TRAPDOOR_MODEL_OVERRIDE, (itemStack, clientLevel, livingEntity, i) -> ModBusEventHandler.getTypeOrdinal(itemStack, TrapdoorType.class, TrapdoorType.FULL)));
        event.enqueueWork(() -> ItemProperties.register((Item)IModBlocks.getInstance().getPost().asItem(), (ResourceLocation)Constants.POST_MODEL_OVERRIDE, (itemStack, clientLevel, livingEntity, i) -> ModBusEventHandler.getTypeOrdinal(itemStack, PostType.class, PostType.PLAIN)));
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getArchitectsCutter(), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getStandingBarrel(), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getLayingBarrel(), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getShingleSlab(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getPaperWall(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getFence(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getFenceGate(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getSlab(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getStair(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getWall(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getFancyDoor(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getFancyTrapdoor(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getTrapdoor(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getDoor(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getPanel(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getPost(), (RenderType)RenderType.translucent());
            for (ShingleHeightType heightType : ShingleHeightType.values()) {
                ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getShingle(heightType), (RenderType)RenderType.translucent());
            }
            IModBlocks.getInstance().getFloatingCarpets().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.cutout()));
            IModBlocks.getInstance().getTimberFrames().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.translucent()));
            IModBlocks.getInstance().getAllBrickBlocks().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.solid()));
            IModBlocks.getInstance().getExtraTopBlocks().forEach(b -> ItemBlockRenderTypes.setRenderLayer((Block)b, (RenderType)(((ExtraBlock)b).getType().isTranslucent() ? RenderType.translucent() : RenderType.solid())));
        });
    }

    private static <T extends Enum<T>> float getTypeOrdinal(ItemStack itemStack, Class<T> enumClass, T defaultValue) {
        String type = (String)((BlockItemStateProperties)itemStack.getOrDefault(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY)).properties().get("type");
        if (type == null) {
            return defaultValue.ordinal();
        }
        try {
            return ((Enum)Enum.valueOf(enumClass, type.toUpperCase())).ordinal();
        }
        catch (Exception e) {
            return defaultValue.ordinal();
        }
    }
}

