/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.progress;

import java.util.concurrent.atomic.AtomicInteger;
import net.neoforged.fml.loading.progress.Message;
import net.neoforged.fml.loading.progress.StartupNotificationManager;

public final class ProgressMeter {
    private final String name;
    private final int steps;
    private AtomicInteger current;
    private Message label;

    public ProgressMeter(String name, int steps, int current, Message label) {
        this.name = name;
        this.steps = steps;
        this.current = new AtomicInteger(current);
        this.label = label;
    }

    public String name() {
        return this.name;
    }

    public int steps() {
        return this.steps;
    }

    public int current() {
        return this.current.get();
    }

    public Message label() {
        return this.label;
    }

    public void increment() {
        this.current.incrementAndGet();
    }

    public void complete() {
        StartupNotificationManager.popBar(this);
    }

    public float progress() {
        return (float)this.current.get() / (float)this.steps;
    }

    public void setAbsolute(int absolute) {
        this.current.set(absolute);
    }

    public void label(String message) {
        this.label = new Message(message, Message.MessageType.ML);
    }
}

