/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import java.util.function.Supplier;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;

public class ModLoadingContext {
    private static final ThreadLocal<ModLoadingContext> context = ThreadLocal.withInitial(ModLoadingContext::new);
    private ModContainer activeContainer;

    public static ModLoadingContext get() {
        return context.get();
    }

    public void setActiveContainer(ModContainer container) {
        this.activeContainer = container;
    }

    public ModContainer getActiveContainer() {
        return this.activeContainer == null ? ModList.get().getModContainerById("minecraft").orElseThrow(() -> new RuntimeException("Where is minecraft???!")) : this.activeContainer;
    }

    public String getActiveNamespace() {
        return this.activeContainer == null ? "minecraft" : this.activeContainer.getNamespace();
    }

    public <T extends IExtensionPoint> void registerExtensionPoint(Class<T> point, Supplier<T> extension) {
        this.getActiveContainer().registerExtensionPoint(point, extension);
    }
}

