/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.labels;

import net.mehvahdjukaar.labels.LabelEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class LabelItem
extends Item {
    public LabelItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Direction direction = pContext.getClickedFace();
        BlockPos blockpos = pContext.getClickedPos();
        Direction facing = pContext.getHorizontalDirection();
        Player player = pContext.getPlayer();
        ItemStack itemstack = pContext.getItemInHand();
        if (player != null && !player.mayUseItemAt(blockpos, direction, itemstack)) {
            return InteractionResult.FAIL;
        }
        Level level = pContext.getLevel();
        LabelEntity label = LabelEntity.placeOnFace(level, pContext.getClickLocation(), direction, facing);
        CustomData customData = (CustomData)itemstack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        if (!customData.isEmpty()) {
            EntityType.updateCustomEntityTag((Level)level, (Player)player, (Entity)label, (CustomData)customData);
        }
        if (label.survives()) {
            if (!level.isClientSide) {
                label.playPlacementSound();
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, blockpos);
                level.addFreshEntity((Entity)label);
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        return super.use(level, player, usedHand);
    }
}

