/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.labels;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.labels.ClientConfigs;
import net.mehvahdjukaar.labels.LabelsMod;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.FastColor;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Nullable;

public class ColorManager
extends SimplePreparableReloadListener<List<Integer>> {
    private static final Map<DyeColor, Pair<Integer, Integer>> COLORS = new HashMap<DyeColor, Pair<Integer, Integer>>();

    public static int getDark(@Nullable DyeColor color) {
        Pair<Integer, Integer> integerIntegerPair = COLORS.get(color);
        return (Integer)integerIntegerPair.getSecond();
    }

    public static int getLight(@Nullable DyeColor color) {
        return (Integer)COLORS.get(color).getFirst();
    }

    protected List<Integer> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        ClientConfigs.Preset p = ClientConfigs.COLOR_PRESET.get();
        return SpriteUtils.parsePaletteStrip((ResourceManager)resourceManager, (ResourceLocation)LabelsMod.res("textures/entity/" + p.getName() + "label_colors.png"), (int)(DyeColor.values().length * 2 + 2));
    }

    public void apply(List<Integer> palette, ResourceManager manager, ProfilerFiller filler) {
        Iterator<Integer> i = palette.iterator();
        COLORS.put(null, (Pair<Integer, Integer>)Pair.of((Object)i.next(), (Object)i.next()));
        for (DyeColor d : DyeColor.values()) {
            int second;
            if (i.hasNext()) {
                COLORS.put(d, (Pair<Integer, Integer>)Pair.of((Object)i.next(), (Object)i.next()));
                continue;
            }
            int first = d.getFireworkColor();
            if (first == (second = d.getTextColor())) {
                second = d.getMapColor().col;
            }
            if (first == second) {
                second = FastColor.ARGB32.multiply((int)first, (int)0x101010FF);
            }
            COLORS.put(d, (Pair<Integer, Integer>)Pair.of((Object)first, (Object)second));
        }
    }
}

