/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.util;

import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LRUCache<K, V> {
    private final Lock lock = new ReentrantLock();
    private final Map<K, LruNode<K, V>> map = new ConcurrentHashMap<K, LruNode<K, V>>();
    private final Deque<LruNode<K, V>> deque = new ConcurrentLinkedDeque<LruNode<K, V>>();
    private final int capacity;

    public LRUCache(int capacity) {
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        try {
            this.lock.lockInterruptibly();
            if (this.map.containsKey(key)) {
                LruNode<K, V> node = this.map.get(key);
                this.deque.removeFirstOccurrence(node);
                this.deque.offerLast(node);
                Object v = node.value;
                return v;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        try {
            this.lock.lockInterruptibly();
            if (this.map.containsKey(key)) {
                LruNode<K, V> toRemove = this.map.remove(key);
                this.deque.removeFirstOccurrence(toRemove);
            } else if (this.map.size() == this.capacity) {
                LruNode<K, V> nodeToBeRemoved = this.deque.removeFirst();
                this.map.remove(nodeToBeRemoved.key);
            }
            LruNode<K, V> node = new LruNode<K, V>(key, value);
            this.map.put(key, node);
            this.deque.offerLast(node);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        try {
            this.lock.lockInterruptibly();
            this.map.clear();
            this.deque.clear();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<K, LruNode<K, V>> entry : this.map.entrySet()) {
            stringBuilder.append(entry.getKey()).append(" : ").append(entry.getValue().value).append("\n");
        }
        return stringBuilder.toString();
    }

    private record LruNode<K, V>(K key, V value) {
    }
}

