/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.map_data;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LABColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ColoredMapHandler {
    protected static int DITHERING = 1;
    public static final CustomMapData.Type<Patch, ColorData> COLOR_DATA = MapDataRegistry.registerCustomMapSavedData((ResourceLocation)Supplementaries.res("color_data"), ColorData::new, Patch.STREAM_CODEC);
    private static final Object2IntOpenHashMap<Block> BLOCK_IDS_CACHE = new Object2IntOpenHashMap();
    private static final Int2ObjectOpenHashMap<Block> IDS_TO_BLOCK_CACHE = new Int2ObjectOpenHashMap();
    private static final Object2IntOpenHashMap<Holder<Biome>> BIOME_IDS_CACHE = new Object2IntOpenHashMap();
    private static final Int2ObjectOpenHashMap<Holder<Biome>> IDS_TO_BIOME_CACHE = new Int2ObjectOpenHashMap();
    private static final Map<Pair<BlockAndBiome, Integer>, Integer> GLOBAL_COLOR_CACHE = new Object2IntOpenHashMap();
    private static final int[] IND2COLOR_BUFFER = new int[1024];

    public static void init() {
    }

    public static ColorData getColorData(MapItemSavedData data) {
        return (ColorData)COLOR_DATA.get(data);
    }

    @Nullable
    public static Block getSimilarColoredBlock(Block block) {
        Holder.Reference blockReference = block.builtInRegistryHolder();
        if (blockReference.is(ModTags.NOT_TINTED_ON_MAPS)) {
            return null;
        }
        if (blockReference.is(ModTags.TINTED_ON_MAPS_GC)) {
            if (block instanceof BushBlock) {
                return Blocks.SHORT_GRASS;
            }
            return Blocks.GRASS_BLOCK;
        }
        if (blockReference.is(ModTags.TINTED_ON_MAPS_FC) || block instanceof LeavesBlock) {
            return Blocks.OAK_LEAVES;
        }
        if (blockReference.is(ModTags.TINTED_ON_MAPS_WC)) {
            return Blocks.WATER;
        }
        if (blockReference.is(ModTags.TINTED_ON_MAPS_GENERIC)) {
            return block;
        }
        return null;
    }

    public static void onResourceReload() {
        GLOBAL_COLOR_CACHE.clear();
        System.arraycopy(new int[1024], 0, IND2COLOR_BUFFER, 0, 1024);
    }

    public static void clearIdCache() {
        IDS_TO_BLOCK_CACHE.clear();
        BLOCK_IDS_CACHE.clear();
        IDS_TO_BIOME_CACHE.clear();
        BIOME_IDS_CACHE.clear();
    }

    private static int getBlockId(Block block) {
        return BLOCK_IDS_CACHE.computeIntIfAbsent((Object)block, arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getId(arg_0));
    }

    private static Block getBlockFromId(int id) {
        return (Block)IDS_TO_BLOCK_CACHE.computeIfAbsent(id, arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).byId(arg_0));
    }

    private static int getBiomeId(Holder<Biome> biome, RegistryAccess registryAccess) {
        return BIOME_IDS_CACHE.computeIntIfAbsent(biome, r -> {
            Registry biomeReg = registryAccess.registryOrThrow(Registries.BIOME);
            return biomeReg.getId((Object)((Biome)r.value()));
        });
    }

    private static Holder<Biome> getBiomeFromId(int id, RegistryAccess registryAccess) {
        return (Holder)IDS_TO_BIOME_CACHE.computeIfAbsent(id, r -> {
            Registry biomeReg = registryAccess.registryOrThrow(Registries.BIOME);
            return (Holder)biomeReg.getHolder(r).orElseThrow();
        });
    }

    public static class ColorData
    implements CustomMapData<Counter, Patch>,
    BlockAndTintGetter {
        public static final int BIOME_SIZE = 4;
        public static final String MIN_X = "min_x";
        public static final String MAX_X = "max_x";
        public static final String MIN_Z = "min_z";
        private byte[][] data = null;
        private final List<Holder<Biome>> biomesIndexesPalette = new ArrayList<Holder<Biome>>();
        private final List<Block> blockIndexesPalette = new ArrayList<Block>();
        private BlockAndBiome lastEntryHack;

        @Nullable
        private BlockAndBiome getEntry(int x, int z) {
            if (this.data == null) {
                return null;
            }
            if (x < 0 || x >= 128 || z < 0 || z >= 128) {
                return null;
            }
            if (this.data[x] != null) {
                int paletteIndex = this.paletteIndex(x, z);
                return this.unpackPaletteIndex(paletteIndex);
            }
            return null;
        }

        @Nullable
        private BlockAndBiome unpackPaletteIndex(int packed) {
            if (packed == 0) {
                return null;
            }
            int bi = --packed & 0xF;
            int bli = packed >> 4;
            if (bi >= this.blockIndexesPalette.size() || bli >= this.biomesIndexesPalette.size()) {
                return null;
            }
            return BlockAndBiome.of(this.blockIndexesPalette.get(bi), this.biomesIndexesPalette.get(bli));
        }

        private byte packPaletteIndex(BlockAndBiome entry) {
            int blockIndex = this.blockIndexesPalette.indexOf(entry.block);
            int biomeIndex = this.biomesIndexesPalette.indexOf(entry.biome);
            return (byte)((blockIndex & 0xF | biomeIndex << 4) + 1);
        }

        private int paletteIndex(int x, int z) {
            if (this.data == null || this.data[x] == null) {
                return 0;
            }
            return Byte.toUnsignedInt(this.data[x][z]);
        }

        private void addEntry(MapItemSavedData md, int x, int z, BlockAndBiome entry) {
            boolean changedBiome;
            boolean changedBlock;
            Block block = entry.block;
            if (!this.blockIndexesPalette.contains(block)) {
                if (this.blockIndexesPalette.size() >= 16) {
                    return;
                }
                this.blockIndexesPalette.add(block);
                changedBlock = true;
            } else {
                changedBlock = false;
            }
            Holder<Biome> biome = entry.biome;
            if (!this.biomesIndexesPalette.contains(biome)) {
                if (this.biomesIndexesPalette.size() >= 16) {
                    return;
                }
                this.biomesIndexesPalette.add(biome);
                changedBiome = true;
            } else {
                changedBiome = false;
            }
            if (this.data == null) {
                this.data = new byte[128][];
            }
            if (this.data[x] == null) {
                this.data[x] = new byte[128];
            }
            this.data[x][z] = this.packPaletteIndex(entry);
            this.setDirty(md, counter -> counter.markDirty(x, z, changedBiome, changedBlock));
        }

        public void load(CompoundTag tag, HolderLookup.Provider provider) {
            byte i;
            int j;
            if (tag.contains("palette")) {
                CompoundTag t = tag.getCompound("palette");
                int minX = 0;
                int maxX = 127;
                int minZ = 0;
                for (int x = minX; x <= maxX; ++x) {
                    byte[] rowData = t.getByteArray("pos_" + x);
                    if (this.data == null) {
                        this.data = new byte[128][];
                    }
                    if (this.data[x] == null) {
                        this.data[x] = new byte[128];
                    }
                    System.arraycopy(rowData, 0, this.data[x], minZ, rowData.length);
                }
            }
            if (tag.contains("biomes")) {
                this.biomesIndexesPalette.clear();
                ListTag biomes = tag.getList("biomes", 10);
                for (j = 0; j < biomes.size(); ++j) {
                    CompoundTag c = biomes.getCompound(j);
                    i = c.getByte("index");
                    String id = c.getString("id");
                    try {
                        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)id));
                        provider.lookupOrThrow(Registries.BIOME).get(resourceKey).ifPresent(b -> this.biomesIndexesPalette.add(i, (Holder<Biome>)b));
                        continue;
                    }
                    catch (Exception error) {
                        Supplementaries.LOGGER.error("Error loading biome palette index {} with id {}", (Object)i, (Object)id, (Object)error);
                        Supplementaries.error();
                    }
                }
            }
            if (tag.contains("blocks")) {
                this.blockIndexesPalette.clear();
                ListTag blocks = tag.getList("blocks", 10);
                for (j = 0; j < blocks.size(); ++j) {
                    CompoundTag c = blocks.getCompound(j);
                    i = c.getByte("index");
                    String id = c.getString("id");
                    this.blockIndexesPalette.add(i, (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)id)));
                }
            }
        }

        public void save(CompoundTag tag, HolderLookup.Provider registries) {
            if (this.data != null) {
                this.clearUnusedPalette();
                CompoundTag t = new CompoundTag();
                for (int x = 0; x <= 127; ++x) {
                    if (this.data[x] == null) continue;
                    byte[] rowData = new byte[128];
                    System.arraycopy(this.data[x], 0, rowData, 0, rowData.length);
                    t.putByteArray("pos_" + x, rowData);
                }
                tag.put("palette", (Tag)t);
                if (!this.biomesIndexesPalette.isEmpty()) {
                    ListTag biomesList = new ListTag();
                    for (int i = 0; i < this.biomesIndexesPalette.size(); ++i) {
                        CompoundTag biomeTag = new CompoundTag();
                        biomeTag.putByte("index", (byte)i);
                        biomeTag.putString("id", this.biomesIndexesPalette.get(i).getRegisteredName());
                        biomesList.add((Object)biomeTag);
                    }
                    tag.put("biomes", (Tag)biomesList);
                }
                if (!this.blockIndexesPalette.isEmpty()) {
                    ListTag blocksList = new ListTag();
                    for (int i = 0; i < this.blockIndexesPalette.size(); ++i) {
                        CompoundTag blockTag = new CompoundTag();
                        blockTag.putByte("index", (byte)i);
                        blockTag.putString("id", Utils.getID((Block)this.blockIndexesPalette.get(i)).toString());
                        blocksList.add((Object)blockTag);
                    }
                    tag.put("blocks", (Tag)blocksList);
                }
            }
        }

        private void clearUnusedPalette() {
        }

        public Patch createUpdatePatch(Counter dc) {
            int minX = dc.minDirtyX;
            int maxX = dc.maxDirtyX;
            int minZ = dc.minDirtyZ;
            int maxZ = dc.maxDirtyZ;
            boolean pos = dc.posDirty;
            boolean block = dc.blockDirty;
            boolean biome = dc.biomesDirty;
            Int2ObjectArrayMap positions = null;
            if (pos && this.data != null && (minX != maxX || minZ != maxZ)) {
                positions = new Int2ObjectArrayMap();
                for (int x = minX; x <= maxX; ++x) {
                    byte[] rowData = new byte[maxZ - minZ + 1];
                    if (this.data[x] != null) {
                        System.arraycopy(this.data[x], minZ, rowData, 0, rowData.length);
                    }
                    positions.put(x, (Object)rowData);
                }
            }
            return new Patch(minX, maxX, minZ, Optional.ofNullable(positions), biome ? Optional.of(this.biomesIndexesPalette) : Optional.empty(), block ? Optional.of(this.blockIndexesPalette) : Optional.empty());
        }

        public void applyUpdatePatch(Patch patch) {
            if (patch.positions.isPresent()) {
                Int2ObjectArrayMap<byte[]> positions = patch.positions.get();
                int minX = patch.minX;
                int maxX = patch.maxX;
                int minZ = patch.minZ;
                for (int x = minX; x <= maxX; ++x) {
                    if (this.data == null) {
                        this.data = new byte[128][];
                    }
                    if (this.data[x] == null) {
                        this.data[x] = new byte[128];
                    }
                    byte[] rowData = (byte[])positions.get(x);
                    System.arraycopy(Preconditions.checkNotNull((Object)rowData), 0, this.data[x], minZ, rowData.length);
                }
            }
            if (patch.biomes.isPresent()) {
                this.biomesIndexesPalette.clear();
                this.biomesIndexesPalette.addAll((Collection<Holder<Biome>>)patch.biomes.get());
            }
            if (patch.blocks.isPresent()) {
                this.blockIndexesPalette.clear();
                this.blockIndexesPalette.addAll((Collection<Block>)patch.blocks.get());
            }
        }

        public boolean persistOnCopyOrLock() {
            return true;
        }

        public boolean persistOnRescale() {
            return false;
        }

        public CustomMapData.Type<Patch, ?> getType() {
            return COLOR_DATA;
        }

        public Counter createDirtyCounter() {
            return new Counter();
        }

        public void markColored(int x, int z, Block block, Level level, BlockPos pos, MapItemSavedData data) {
            Block simplifiedBlock = ColoredMapHandler.getSimilarColoredBlock(block);
            if (simplifiedBlock != null) {
                boolean odd = x % 2 == 0 ^ z % 2 == 1;
                pos = pos.offset(odd ? DITHERING : -DITHERING, 0, odd ? DITHERING : -DITHERING);
                Holder biome = level.getBiome(pos);
                BlockAndBiome pair = BlockAndBiome.of(simplifiedBlock, (Holder<Biome>)biome);
                if (!Objects.equals(this.getEntry(x, z), pair)) {
                    this.addEntry(data, x, z, pair);
                }
            } else if (this.data != null && this.data[x] != null && this.data[x][z] != 0) {
                this.data[x][z] = 0;
                this.setDirty(data, counter -> counter.markDirty(x, z, false, false));
                for (byte b : this.data[x]) {
                    if (b == 0) continue;
                    return;
                }
                this.data[x] = null;
            }
        }

        @Nullable
        public BlockEntity getBlockEntity(BlockPos pos) {
            return null;
        }

        public BlockState getBlockState(BlockPos pos) {
            BlockAndBiome entry = this.getEntry(pos.getX(), pos.getZ());
            return entry == null ? Blocks.AIR.defaultBlockState() : entry.block.defaultBlockState();
        }

        public FluidState getFluidState(BlockPos pos) {
            return this.getBlockState(pos).getFluidState();
        }

        public int getHeight() {
            return 0;
        }

        public int getMinBuildHeight() {
            return 0;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void processTexture(NativeImage texture, int startX, int startY, byte[] colors) {
            if (!ClientConfigs.Tweaks.COLORED_MAPS.get().booleanValue() || this.data == null) {
                return;
            }
            boolean tallGrass = ClientConfigs.Tweaks.TALL_GRASS_COLOR_CHANGE.get();
            boolean accurateConfig = ClientConfigs.Tweaks.ACCURATE_COLORED_MAPS.get();
            if (!accurateConfig) {
                Arrays.fill(IND2COLOR_BUFFER, 0);
            }
            BlockColors blockColors = Minecraft.getInstance().getBlockColors();
            for (int x = 0; x < 128; ++x) {
                for (int z = 0; z < 128; ++z) {
                    int alreadyKnownColor;
                    int index = this.paletteIndex(x, z);
                    if (index == 0) continue;
                    int newTint = -1;
                    int k = x + z * 128;
                    byte packedId = colors[k];
                    int brightnessInd = packedId & 3;
                    if (!accurateConfig && (alreadyKnownColor = IND2COLOR_BUFFER[index + brightnessInd * 256]) != 0) {
                        newTint = alreadyKnownColor;
                    }
                    if (newTint == -1) {
                        BlockAndBiome e;
                        this.lastEntryHack = e = this.getEntry(x, z);
                        if (e == null) continue;
                        Block block = e.block;
                        if (accurateConfig) {
                            BlockPos pos = new BlockPos(x, 64, z);
                            int tint = blockColors.getColor(block.defaultBlockState(), (BlockAndTintGetter)this, pos, 0);
                            if (tint != -1) {
                                newTint = ColorData.postProcessTint(tallGrass, packedId, block, tint);
                            }
                        } else {
                            ColoredMapHandler.IND2COLOR_BUFFER[index + brightnessInd * 256] = newTint = GLOBAL_COLOR_CACHE.computeIfAbsent((Pair<BlockAndBiome, Integer>)Pair.of((Object)e, (Object)brightnessInd), n -> {
                                BlockPos pos = new BlockPos(0, 64, 0);
                                int tint = blockColors.getColor(block.defaultBlockState(), (BlockAndTintGetter)this, pos, 0);
                                return ColorData.postProcessTint(tallGrass, packedId, block, tint);
                            }).intValue();
                        }
                    }
                    if (newTint == -1) continue;
                    texture.setPixelRGBA(startX + x, startY + z, newTint);
                }
            }
        }

        private static int postProcessTint(boolean tg, byte packedId, Block block, int tint) {
            float lumIncrease = 1.3f;
            MapColor mapColor = MapColor.byId((int)((packedId & 0xFF) >> 2));
            if (mapColor == MapColor.WATER) {
                lumIncrease = 2.0f;
            } else if (mapColor == MapColor.PLANT && block instanceof BushBlock && tg) {
                packedId = MapColor.GRASS.getPackedId(MapColor.Brightness.byId((int)(packedId & 3)));
            }
            int color = MapColor.getColorFromPackedId((int)packedId);
            tint = ColorUtils.swapFormat((int)tint);
            RGBColor tintColor = new RGBColor(tint);
            LABColor c = new RGBColor(color).asLAB();
            RGBColor gray = c.multiply(lumIncrease, 0.0f, 0.0f, 1.0f).asRGB();
            return gray.multiply(tintColor.red(), tintColor.green(), tintColor.blue(), 1.0f).asHSL().multiply(1.0f, 1.3f, 1.0f, 1.0f).asRGB().toInt();
        }

        public float getShade(Direction direction, boolean shade) {
            return 0.0f;
        }

        public LevelLightEngine getLightEngine() {
            return ClientRegistry.getLightEngine();
        }

        public int getBlockTint(BlockPos pos, ColorResolver colorResolver) {
            if (this.lastEntryHack != null) {
                if (pos == null || colorResolver == null) {
                    throw new IllegalStateException("Block position of Color resolvers were null. How? " + String.valueOf(pos) + String.valueOf(colorResolver));
                }
                int x = pos.getX();
                int z = pos.getZ();
                Biome b = (Biome)this.lastEntryHack.biome.value();
                boolean odd = x % 2 == 0 ^ z % 2 == 1;
                pos = pos.offset(odd ? DITHERING : -DITHERING, 0, odd ? DITHERING : -DITHERING);
                return colorResolver.getColor(b, (double)pos.getX() + 0.5, (double)pos.getZ() + 0.5);
            }
            return 0;
        }

        public void clear() {
            this.data = null;
            this.biomesIndexesPalette.clear();
            this.blockIndexesPalette.clear();
        }
    }

    public record Patch(int minX, int maxX, int minZ, Optional<Int2ObjectArrayMap<byte[]>> positions, Optional<List<Holder<Biome>>> biomes, Optional<List<Block>> blocks) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Patch> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Patch>(){

            public Patch decode(RegistryFriendlyByteBuf buf) {
                int minX = 0;
                int maxX = 0;
                int minZ = 0;
                boolean hasPositions = buf.readBoolean();
                Int2ObjectArrayMap positions = null;
                if (hasPositions) {
                    minX = buf.readInt();
                    maxX = buf.readInt();
                    minZ = buf.readInt();
                    int size = buf.readVarInt();
                    positions = new Int2ObjectArrayMap(size);
                    for (int i = 0; i < size; ++i) {
                        int x = buf.readVarInt();
                        byte[] rowData = buf.readByteArray();
                        positions.put(x, (Object)rowData);
                    }
                }
                boolean hasBiomes = buf.readBoolean();
                ArrayList<Holder<Biome>> biomes = null;
                if (hasBiomes) {
                    int size = buf.readVarInt();
                    biomes = new ArrayList<Holder<Biome>>(size);
                    for (int i = 0; i < size; ++i) {
                        int id = buf.readVarInt();
                        biomes.add(ColoredMapHandler.getBiomeFromId(id, buf.registryAccess()));
                    }
                }
                boolean hasBlocks = buf.readBoolean();
                ArrayList<Block> blocks = null;
                if (hasBlocks) {
                    int size = buf.readVarInt();
                    blocks = new ArrayList<Block>(size);
                    for (int i = 0; i < size; ++i) {
                        int id = buf.readVarInt();
                        blocks.add(ColoredMapHandler.getBlockFromId(id));
                    }
                }
                return new Patch(minX, maxX, minZ, Optional.ofNullable(positions), Optional.ofNullable(biomes), Optional.ofNullable(blocks));
            }

            public void encode(RegistryFriendlyByteBuf buf, Patch patch) {
                if (patch.positions.isPresent()) {
                    buf.writeBoolean(true);
                    buf.writeInt(patch.minX);
                    buf.writeInt(patch.maxX);
                    buf.writeInt(patch.minZ);
                    Int2ObjectArrayMap<byte[]> positions = patch.positions.get();
                    buf.writeVarInt(positions.size());
                    for (Int2ObjectMap.Entry entry : positions.int2ObjectEntrySet()) {
                        buf.writeVarInt(entry.getIntKey());
                        byte[] rowData = (byte[])entry.getValue();
                        buf.writeByteArray(rowData);
                    }
                } else {
                    buf.writeBoolean(false);
                }
                if (patch.biomes.isPresent()) {
                    buf.writeBoolean(true);
                    List<Holder<Biome>> biomes = patch.biomes.get();
                    buf.writeVarInt(biomes.size());
                    for (Holder<Biome> biome : biomes) {
                        int id = ColoredMapHandler.getBiomeId(biome, buf.registryAccess());
                        buf.writeVarInt(id);
                    }
                } else {
                    buf.writeBoolean(false);
                }
                if (patch.blocks.isPresent()) {
                    buf.writeBoolean(true);
                    List<Block> blocks = patch.blocks.get();
                    buf.writeVarInt(blocks.size());
                    for (Block block : blocks) {
                        int id = ColoredMapHandler.getBlockId(block);
                        buf.writeVarInt(id);
                    }
                } else {
                    buf.writeBoolean(false);
                }
            }
        };
    }

    public record BlockAndBiome(Block block, Holder<Biome> biome) {
        public static BlockAndBiome of(Block block, Holder<Biome> biome) {
            return new BlockAndBiome(block, biome);
        }
    }

    public static class Counter
    implements CustomMapData.DirtyCounter {
        private int minDirtyX = 0;
        private int maxDirtyX = 127;
        private int minDirtyZ = 0;
        private int maxDirtyZ = 127;
        private boolean posDirty = true;
        private boolean blockDirty = true;
        private boolean biomesDirty = true;

        public void markDirty(int x, int z, boolean changedBiome, boolean changedBlock) {
            if (changedBiome) {
                this.biomesDirty = true;
            }
            if (changedBlock) {
                this.blockDirty = true;
            }
            if (this.posDirty) {
                this.minDirtyX = Math.min(this.minDirtyX, x);
                this.minDirtyZ = Math.min(this.minDirtyZ, z);
                this.maxDirtyX = Math.max(this.maxDirtyX, x);
                this.maxDirtyZ = Math.max(this.maxDirtyZ, z);
            } else {
                this.posDirty = true;
                this.minDirtyX = x;
                this.minDirtyZ = z;
                this.maxDirtyX = x;
                this.maxDirtyZ = z;
            }
        }

        public boolean isDirty() {
            return this.posDirty || this.biomesDirty || this.blockDirty;
        }

        public void clearDirty() {
            this.biomesDirty = false;
            this.blockDirty = false;
            this.posDirty = false;
            this.minDirtyX = 0;
            this.minDirtyZ = 0;
            this.maxDirtyX = 0;
            this.maxDirtyZ = 0;
        }
    }
}

