/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.explosion;

import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.UnmodifiableIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.events.ClientEvents;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CannonBallExplosion
extends Explosion {
    private final BlockPos centerPos;
    private final float maxExplodedAmount;
    @Nullable
    private final Set<Block> whitelist;
    private float explosionAmountLeft;

    public CannonBallExplosion(Level level, @Nullable Entity source, double toBlowX, double toBlowY, double toBlowZ, BlockPos centerPos, float maxExplodedAmount, float maxRadius, @Nullable Set<Block> whitelist) {
        super(level, source, toBlowX, toBlowY, toBlowZ, maxRadius, false, Explosion.BlockInteraction.DESTROY);
        this.centerPos = centerPos;
        this.maxExplodedAmount = maxExplodedAmount;
        this.whitelist = whitelist;
    }

    public CannonBallExplosion(Level level, @Nullable Entity source, double toBlowX, double toBlowY, double toBlowZ, float radius, List<BlockPos> toBlow) {
        super(level, source, toBlowX, toBlowY, toBlowZ, radius, false, Explosion.BlockInteraction.DESTROY, toBlow);
        this.centerPos = BlockPos.containing((Position)new Vec3(toBlowX, toBlowY, toBlowZ));
        this.maxExplodedAmount = 0.0f;
        this.whitelist = null;
    }

    public void explode() {
        Vec3 center = new Vec3(this.x, this.y, this.z);
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> toVisit = new ArrayDeque<BlockPos>();
        AtomicReference<Float> explosionBudget = new AtomicReference<Float>(Float.valueOf(this.maxExplodedAmount));
        toVisit.add(this.centerPos);
        while (!toVisit.isEmpty() && (double)explosionBudget.get().floatValue() > 0.25) {
            BlockPos currentPos = (BlockPos)toVisit.poll();
            this.visit(currentPos, center, explosionBudget, this.getToBlow(), visited, toVisit);
        }
        this.explosionAmountLeft = explosionBudget.get().floatValue();
    }

    public float getExploded() {
        return this.maxExplodedAmount - this.explosionAmountLeft;
    }

    private void visit(BlockPos pos, Vec3 center, AtomicReference<Float> explosionBudget, List<BlockPos> toExplode, Set<BlockPos> visited, Queue<BlockPos> toVisit) {
        float r = this.radius + this.level.random.nextFloat();
        if (!pos.equals((Object)this.centerPos) && center.distanceToSqr(pos.getCenter()) > (double)(r * r)) {
            return;
        }
        if (!this.level.isInWorldBounds(pos) || visited.contains(pos)) {
            return;
        }
        visited.add(pos);
        BlockState blockState = this.level.getBlockState(pos);
        FluidState fluidState = this.level.getFluidState(pos);
        boolean canPropagateExplosion = false;
        if (!blockState.isAir()) {
            if (this.whitelist != null && !this.whitelist.contains(blockState.getBlock())) {
                return;
            }
            Optional optional = this.damageCalculator.getBlockExplosionResistance((Explosion)this, (BlockGetter)this.level, pos, blockState, fluidState);
            if (optional.isPresent()) {
                float resistance = (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                float newB = explosionBudget.get().floatValue() - resistance;
                if (newB > 0.0f && this.damageCalculator.shouldBlockExplode((Explosion)this, (BlockGetter)this.level, pos, blockState, 1.0f)) {
                    toExplode.add(pos);
                    explosionBudget.set(Float.valueOf(newB));
                    canPropagateExplosion = true;
                }
            }
        }
        if (!canPropagateExplosion) {
            return;
        }
        ArrayList<BlockPos> neighborPos = new ArrayList<BlockPos>();
        for (Direction d : Direction.values()) {
            neighborPos.add(pos.relative(d));
        }
        neighborPos.sort(Comparator.comparingDouble(p -> center.distanceToSqr(p.getCenter())));
        toVisit.addAll(neighborPos);
    }

    public void finalizeExplosion(boolean spawnParticles) {
        Player player;
        LivingEntity indirectSource;
        if (this.level.isClientSide) {
            ClientEvents.onExplosion(this);
        }
        if (spawnParticles) {
            this.level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        }
        boolean hasDrop = !((indirectSource = this.getIndirectSourceEntity()) instanceof Player && (player = (Player)indirectSource).isCreative());
        Util.shuffle((List)((ObjectArrayList)this.getToBlow()), (RandomSource)this.level.random);
        LinkedHashMultiset sounds = LinkedHashMultiset.create();
        for (BlockPos blockPos : this.getToBlow()) {
            BlockState blockState = this.level.getBlockState(blockPos);
            if (blockState.isAir()) continue;
            this.destroyBlockNoEffects(blockPos, this.level, (Entity)indirectSource, 512, (Multiset<SoundEvent>)sounds);
        }
        if (this.level.isClientSide && !sounds.isEmpty()) {
            UnmodifiableIterator iter = Multisets.copyHighestCountFirst((Multiset)sounds).iterator();
            for (int i = 0; i < 3 && iter.hasNext(); ++i) {
                SoundEvent sound = (SoundEvent)iter.next();
                this.level.playLocalSound(this.x, this.y, this.z, sound, SoundSource.BLOCKS, 2.5f, 0.6f + this.level.random.nextFloat() * 0.2f, false);
            }
        }
    }

    public boolean destroyBlockNoEffects(BlockPos pos, Level level, @Nullable Entity entity, int recursionLeft, Multiset<SoundEvent> sounds) {
        BlockState blockState = level.getBlockState(pos);
        if (blockState.isAir()) {
            return false;
        }
        FluidState fluidState = level.getFluidState(pos);
        if (level.isClientSide && !(blockState.getBlock() instanceof BaseFireBlock)) {
            sounds.add((Object)SuppPlatformStuff.getSoundType(blockState, pos, level, entity).getBreakSound());
            level.addDestroyBlockEffect(pos, blockState);
        }
        BlockEntity blockEntity = blockState.hasBlockEntity() ? level.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)blockState, (Level)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)entity, (ItemStack)ItemStack.EMPTY);
        boolean bl = level.setBlock(pos, fluidState.createLegacyBlock(), 3, recursionLeft);
        if (bl) {
            level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockState));
        }
        return bl;
    }
}

