/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.supplementaries.common.items.PresentItem;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRecipes;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class TrappedPresentRecipe
extends CustomRecipe {
    private final Ingredient tripwire;

    public TrappedPresentRecipe(CraftingBookCategory category, Ingredient tripwire) {
        super(category);
        this.tripwire = tripwire;
    }

    public boolean matches(CraftingInput craftingContainer, Level level) {
        int i = 0;
        int j = 0;
        for (int k = 0; k < craftingContainer.size(); ++k) {
            ItemStack itemstack = craftingContainer.getItem(k);
            if (itemstack.isEmpty()) continue;
            if (itemstack.getItem() instanceof PresentItem) {
                ItemContainerContents container = (ItemContainerContents)itemstack.get(DataComponents.CONTAINER);
                if (container == null) {
                    return false;
                }
                ++i;
            } else {
                if (!this.tripwire.test(itemstack)) {
                    return false;
                }
                ++j;
            }
            if (j <= 1 && i <= 1) continue;
            return false;
        }
        return i == 1 && j == 1;
    }

    public ItemStack assemble(CraftingInput craftingContainer, HolderLookup.Provider registryAccess) {
        ItemStack itemstack = ItemStack.EMPTY;
        DyeColor dyecolor = DyeColor.WHITE;
        for (int i = 0; i < craftingContainer.size(); ++i) {
            Item item;
            ItemStack stack = craftingContainer.getItem(i);
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof PresentItem)) continue;
            PresentItem pi = (PresentItem)item;
            itemstack = stack;
            dyecolor = pi.getColor();
        }
        ItemStack result = itemstack.transmuteCopy((ItemLike)ModRegistry.TRAPPED_PRESENTS.get(dyecolor).get(), 1);
        result.remove(ModComponents.ADDRESS.get());
        return result;
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x * y >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.TRAPPED_PRESENT.get();
    }

    public static class Serializer
    implements RecipeSerializer<TrappedPresentRecipe> {
        private static final MapCodec<TrappedPresentRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(CraftingRecipe::category), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.tripwire)).apply((Applicative)instance, TrappedPresentRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, TrappedPresentRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)CraftingBookCategory.STREAM_CODEC, CraftingRecipe::category, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.tripwire, TrappedPresentRecipe::new);

        public MapCodec<TrappedPresentRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TrappedPresentRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

