/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FaucetBlock;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetItemSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FaucetBlockTile
extends BlockEntity
implements IExtraModelDataProvider {
    private static final List<FaucetSource.BlState> BLOCK_INTERACTIONS = new ArrayList<FaucetSource.BlState>();
    private static final List<FaucetSource.Tile> TILE_INTERACTIONS = new ArrayList<FaucetSource.Tile>();
    private static final List<FaucetSource.Fluid> SOURCE_FLUID_INTERACTIONS = new ArrayList<FaucetSource.Fluid>();
    private static final List<FaucetItemSource> ITEM_INTERACTIONS = new ArrayList<FaucetItemSource>();
    private static final List<FaucetTarget.BlState> TARGET_BLOCK_INTERACTIONS = new ArrayList<FaucetTarget.BlState>();
    private static final List<FaucetTarget.Tile> TARGET_TILE_INTERACTIONS = new ArrayList<FaucetTarget.Tile>();
    private static final List<FaucetTarget.Fluid> TARGET_FLUID_INTERACTIONS = new ArrayList<FaucetTarget.Fluid>();
    public static final ModelDataKey<ResourceKey<SoftFluid>> FLUID = ModBlockProperties.FLUID;
    public static final ModelDataKey<Integer> FLUID_COLOR = ModBlockProperties.FLUID_COLOR;
    public static final int COOLDOWN_PER_BOTTLE = 20;
    private int transferCooldown = 0;
    public final SoftFluidTank tempFluidHolder = SoftFluidTank.create((int)5);
    public static final Predicate<Entity> NON_PLAYER = e -> e.isAlive() && !(e instanceof Player);

    public FaucetBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.FAUCET_TILE.get(), pos, state);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        if (this.level != null && !this.tempFluidHolder.isEmpty()) {
            int color = this.tempFluidHolder.getCachedFlowingColor((BlockAndTintGetter)this.level, this.worldPosition);
            builder.with(FLUID, (Object)((ResourceKey)this.tempFluidHolder.getFluid().getHolder().unwrapKey().get()));
            builder.with(FLUID_COLOR, (Object)color);
        }
    }

    public void updateLight() {
        if (this.level == null) {
            return;
        }
        int light = this.tempFluidHolder.getFluidValue().getLuminosity();
        if (light != 0) {
            light = (int)Mth.clamp((float)((float)light / 2.0f), (float)1.0f, (float)7.0f);
        }
        if (light != (Integer)this.getBlockState().getValue((Property)FaucetBlock.LIGHT_LEVEL)) {
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)FaucetBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(light)), 2);
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, FaucetBlockTile tile) {
        if (tile.transferCooldown > 0) {
            --tile.transferCooldown;
        } else if (tile.isOpen()) {
            int cooldown = tile.tryExtract(pLevel, pPos, pState, false);
            tile.transferCooldown += cooldown;
        }
    }

    public boolean updateContainedFluidVisuals(Level level, BlockPos pos, BlockState state) {
        boolean r = this.tryExtract(level, pos, state, true) != 0;
        this.updateLight();
        this.requestModelReload();
        return r;
    }

    private int tryExtract(Level level, BlockPos pos, BlockState state, boolean justVisual) {
        FluidState fluidState;
        Direction dir = (Direction)state.getValue((Property)FaucetBlock.FACING);
        BlockPos behind = pos.relative(dir.getOpposite());
        BlockState backState = level.getBlockState(behind);
        if (backState.isAir()) {
            return 0;
        }
        Integer filledAmount = this.runInteractions(BLOCK_INTERACTIONS, level, dir, behind, backState, justVisual);
        if (filledAmount != null) {
            return filledAmount;
        }
        BlockEntity tileBack = level.getBlockEntity(behind);
        if (tileBack != null && (filledAmount = this.runInteractions(TILE_INTERACTIONS, level, dir, behind, tileBack, justVisual)) != null) {
            return filledAmount;
        }
        if (!this.isConnectedBelow() && !justVisual && (CommonConfigs.Redstone.FAUCET_DROP_ITEMS.get().booleanValue() || CommonConfigs.Redstone.FAUCET_FILL_ENTITIES.get().booleanValue())) {
            for (FaucetItemSource bi : ITEM_INTERACTIONS) {
                ItemStack removed = bi.tryExtractItem(level, behind, backState, dir, tileBack);
                if (removed.isEmpty()) continue;
                if (!(CommonConfigs.Redstone.FAUCET_FILL_ENTITIES.get().booleanValue() && this.fillEntityBelow(removed) || !CommonConfigs.Redstone.FAUCET_DROP_ITEMS.get().booleanValue())) {
                    this.drop(removed);
                }
                return 20;
            }
        }
        if ((filledAmount = this.runInteractions(SOURCE_FLUID_INTERACTIONS, level, dir, behind, fluidState = level.getFluidState(behind), justVisual)) != null) {
            return filledAmount;
        }
        return 0;
    }

    @Nullable
    private <T, S extends FaucetSource<T>> Integer runInteractions(List<S> interactions, Level level, Direction dir, BlockPos pos, T source, boolean justVisual) {
        for (FaucetSource inter : interactions) {
            FluidOffer fluid = inter.getProvidedFluid(level, pos, dir, source);
            if (fluid == null) continue;
            if (justVisual) {
                this.tempFluidHolder.setFluid(fluid.fluid());
                return 20;
            }
            Integer amountFilled = this.tryFillingBlockBelow(fluid);
            if (amountFilled == null) continue;
            if (amountFilled == 0) {
                return 0;
            }
            inter.drain(level, pos, dir, source, amountFilled);
            return amountFilled * 20;
        }
        return null;
    }

    private Integer tryFillingBlockBelow(FluidOffer offer) {
        BlockPos below = this.worldPosition.below();
        BlockState belowState = this.level.getBlockState(below);
        for (FaucetTarget.BlState blState : TARGET_BLOCK_INTERACTIONS) {
            Integer res = blState.fill(this.level, below, belowState, offer);
            if (res == null) continue;
            return res;
        }
        BlockEntity tileBelow = this.level.getBlockEntity(below);
        if (tileBelow != null) {
            for (FaucetTarget.Tile bi : TARGET_TILE_INTERACTIONS) {
                Integer res = bi.fill(this.level, below, tileBelow, offer);
                if (res == null) continue;
                return res;
            }
        }
        FluidState fluidState = belowState.getFluidState();
        for (FaucetTarget.Fluid bi : TARGET_FLUID_INTERACTIONS) {
            Integer res = bi.fill(this.level, below, fluidState, offer);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public boolean isOpen() {
        return (Boolean)this.getBlockState().getValue((Property)BlockStateProperties.POWERED) ^ (Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ENABLED);
    }

    public boolean hasWater() {
        return (Boolean)this.getBlockState().getValue((Property)FaucetBlock.HAS_WATER);
    }

    public boolean isConnectedBelow() {
        return (Boolean)this.getBlockState().getValue((Property)FaucetBlock.CONNECTED);
    }

    private void drop(ItemStack extracted) {
        BlockPos pos = this.worldPosition;
        ItemEntity drop = new ItemEntity(this.level, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, extracted);
        drop.setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
        this.level.addFreshEntity((Entity)drop);
        float f = (this.level.random.nextFloat() - 0.5f) / 4.0f;
        this.level.playSound(null, pos, SoundEvents.CHICKEN_EGG, SoundSource.BLOCKS, 0.3f, 0.5f + f);
    }

    private boolean fillEntityBelow(ItemStack stack) {
        List list = this.level.getEntities((Entity)null, new AABB(this.worldPosition).move(0.0, -0.75, 0.0), NON_PLAYER);
        Collections.shuffle(list);
        for (Entity entity : list) {
            if (!(stack = ItemsUtil.tryAddingItem(stack, this.level, entity)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.transferCooldown = tag.getInt("TransferCooldown");
        this.tempFluidHolder.load(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("TransferCooldown", this.transferCooldown);
        this.tempFluidHolder.save(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public static void registerInteraction(Object interaction) {
        FaucetSource<BlockState> bs;
        boolean success = false;
        if (interaction instanceof FaucetSource.BlState) {
            bs = (FaucetSource.BlState)interaction;
            BLOCK_INTERACTIONS.add((FaucetSource.BlState)bs);
            success = true;
        }
        if (interaction instanceof FaucetSource.Tile) {
            FaucetSource.Tile ts = (FaucetSource.Tile)interaction;
            TILE_INTERACTIONS.add(ts);
            success = true;
        }
        if (interaction instanceof FaucetSource.Fluid) {
            bs = (FaucetSource.Fluid)interaction;
            SOURCE_FLUID_INTERACTIONS.add((FaucetSource.Fluid)bs);
            success = true;
        }
        if (interaction instanceof FaucetTarget.BlState) {
            FaucetTarget.BlState tb = (FaucetTarget.BlState)interaction;
            TARGET_BLOCK_INTERACTIONS.add(tb);
            success = true;
        }
        if (interaction instanceof FaucetTarget.Tile) {
            FaucetTarget.Tile tt = (FaucetTarget.Tile)interaction;
            TARGET_TILE_INTERACTIONS.add(tt);
            success = true;
        }
        if (interaction instanceof FaucetTarget.Fluid) {
            FaucetTarget.Fluid tf = (FaucetTarget.Fluid)interaction;
            TARGET_FLUID_INTERACTIONS.add(tf);
            success = true;
        }
        if (interaction instanceof FaucetItemSource) {
            FaucetItemSource is = (FaucetItemSource)interaction;
            ITEM_INTERACTIONS.add(is);
            success = true;
        }
        if (!success) {
            throw new UnsupportedOperationException("Unsupported faucet interaction class: " + interaction.getClass().getSimpleName());
        }
    }

    public static void clearBehaviors() {
        BLOCK_INTERACTIONS.clear();
        TILE_INTERACTIONS.clear();
        SOURCE_FLUID_INTERACTIONS.clear();
        ITEM_INTERACTIONS.clear();
        TARGET_BLOCK_INTERACTIONS.clear();
        TARGET_TILE_INTERACTIONS.clear();
        TARGET_FLUID_INTERACTIONS.clear();
    }

    @FunctionalInterface
    public static interface FillAction {
        public int tryExecute(int var1);
    }
}

