/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.serialization.DynamicOps;
import net.mehvahdjukaar.supplementaries.common.items.BambooSpikesTippedItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BambooSpikesBlockTile
extends BlockEntity {
    public static final float POTION_MULTIPLIER = 0.1f;
    public static final int MAX_CHARGES = 16;
    @NotNull
    protected PotionContents potion = PotionContents.EMPTY;
    protected int charges = 0;
    protected long lastTicked = 0L;

    public BambooSpikesBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.BAMBOO_SPIKES_TILE.get(), pos, state);
    }

    public int getColor() {
        if (this.hasPotion()) {
            return this.potion.getColor();
        }
        return 0xFFFFFF;
    }

    public boolean hasPotion() {
        return this.charges != 0 && this.potion != PotionContents.EMPTY;
    }

    public boolean isOnCooldown(Level world) {
        return world.getGameTime() - this.lastTicked < 20L;
    }

    public boolean consumeCharge(Level world) {
        if (CommonConfigs.Functional.ONLY_ALLOW_HARMFUL.get().booleanValue()) {
            for (MobEffectInstance e : this.potion.getAllEffects()) {
                if (!((MobEffect)e.getEffect().value()).isBeneficial()) continue;
                return true;
            }
        }
        this.lastTicked = world.getGameTime();
        --this.charges;
        this.setChanged();
        if (this.charges <= 0) {
            this.charges = 0;
            this.potion = PotionContents.EMPTY;
            return true;
        }
        return false;
    }

    public boolean tryApplyPotion(PotionContents potion) {
        return this.tryApplyPotion(potion, 16);
    }

    public boolean tryApplyPotion(PotionContents newPotion, int charges) {
        if ((!this.hasPotion() || this.potion.equals((Object)newPotion) && this.charges != 16) && BambooSpikesTippedItem.isPotionValid(newPotion) && charges > 0) {
            this.potion = newPotion;
            this.charges = 16;
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.charges = Math.clamp((long)charges, 0, 16);
            return true;
        }
        return false;
    }

    public boolean interactWithEntity(LivingEntity le, @NotNull Level world) {
        if (this.hasPotion() && !this.isOnCooldown(world)) {
            boolean used = false;
            for (MobEffectInstance effectInstance : this.potion.getAllEffects()) {
                if (!le.canBeAffected(effectInstance) || le.hasEffect(effectInstance.getEffect())) continue;
                MobEffect effect = (MobEffect)effectInstance.getEffect().value();
                if (effect.isInstantenous()) {
                    float health = 0.5f;
                    effect.applyInstantenousEffect(null, null, le, effectInstance.getAmplifier(), (double)health);
                } else {
                    le.addEffect(new MobEffectInstance(effectInstance.getEffect(), (int)((float)effectInstance.getDuration() * 0.1f), effectInstance.getAmplifier()));
                }
                used = true;
            }
            if (used) {
                this.makeParticle(world);
                return this.consumeCharge(world);
            }
        }
        return false;
    }

    public void makeParticle(Level level) {
        int color = this.getColor();
        BlockPos pos = this.getBlockPos();
        level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)color), (double)pos.getX() + 0.5 + ((double)level.random.nextFloat() - 0.5) * 0.75, (double)pos.getY() + 0.5 + ((double)level.random.nextFloat() - 0.5) * 0.75, (double)pos.getZ() + 0.5 + ((double)level.random.nextFloat() - 0.5) * 0.75, 0.0, 0.0, 0.0);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("Charges", this.charges);
        tag.putLong("LastTicked", this.lastTicked);
        if (this.hasPotion()) {
            RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            tag.put("Potion", (Tag)PotionContents.CODEC.encodeStart((DynamicOps)ops, (Object)this.potion).getOrThrow());
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.charges = tag.getInt("Charges");
        this.lastTicked = tag.getLong("LastTicked");
        if (tag.contains("Potion")) {
            RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            PotionContents.CODEC.decode((DynamicOps)ops, (Object)tag.get("Potion")).ifSuccess(p -> {
                this.potion = (PotionContents)p.getFirst();
            });
        } else {
            this.potion = PotionContents.EMPTY;
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        PotionContents potion = (PotionContents)componentInput.get(DataComponents.POTION_CONTENTS);
        if (potion != null) {
            this.potion = potion;
            this.charges = Mth.clamp((int)((Integer)componentInput.getOrDefault(ModComponents.CHARGES.get(), (Object)16)), (int)0, (int)16);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        if (this.hasPotion()) {
            components.set(DataComponents.POTION_CONTENTS, (Object)this.potion);
            components.set(ModComponents.CHARGES.get(), (Object)Mth.clamp((int)this.charges, (int)0, (int)16));
        }
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("Potion");
        tag.remove("Charges");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

