/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FenceMimicBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SignPostBlock
extends FenceMimicBlock
implements EntityBlock,
IRotatable {
    public SignPostBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof SignPostItem) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof SignPostBlockTile) {
                SignPostBlockTile tile = (SignPostBlockTile)blockEntity;
                return tile.handleInteraction(state, serverLevel, pos, player, hand, hitResult, stack);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.SUCCESS;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SignPostBlockTile) {
            SignPostBlockTile tile = (SignPostBlockTile)blockEntity;
            Block block = tile.getHeldBlock().getBlock();
            return block.getCloneItemStack(level, pos, block.defaultBlockState());
        }
        return super.getCloneItemStack(level, pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SignPostBlockTile) {
            SignPostBlockTile tile = (SignPostBlockTile)blockEntity;
            SignPostBlockTile.Sign sign = tile.getClickedSign(target.getLocation());
            if (sign.active()) {
                return sign.getItem();
            }
            return new ItemStack((ItemLike)tile.getHeldBlock().getBlock());
        }
        return new ItemStack((ItemLike)this);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof SignPostBlockTile) {
            SignPostBlockTile tile = (SignPostBlockTile)object;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(new ItemStack((ItemLike)tile.getHeldBlock().getBlock()));
            SignPostBlockTile.Sign up = tile.getSignUp();
            SignPostBlockTile.Sign down = tile.getSignDown();
            if (up.active()) {
                list.add(up.getItem());
            }
            if (down.active()) {
                list.add(down.getItem());
            }
            return list;
        }
        return super.getDrops(state, builder);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rot) {
        return state;
    }

    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        return Optional.of(state);
    }

    public Optional<Direction> rotateOverAxis(BlockState state, LevelAccessor world, BlockPos pos, Rotation rot, Direction axis, @Nullable Vec3 hit) {
        boolean success = false;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof SignPostBlockTile) {
            float angle;
            SignPostBlockTile tile = (SignPostBlockTile)blockEntity;
            boolean simple = hit == null;
            boolean ccw = rot.equals((Object)Rotation.COUNTERCLOCKWISE_90);
            float f = simple ? (float)(ccw ? 90 : -90) : (angle = 22.5f * (float)(ccw ? 1 : -1));
            if (simple) {
                if (tile.rotateSign(true, angle, false)) {
                    success = true;
                }
                if (tile.rotateSign(false, angle, false)) {
                    success = true;
                }
            } else {
                boolean up;
                boolean bl = up = hit.y % (double)((int)hit.y) > 0.5;
                if (tile.rotateSign(up, angle, true)) {
                    success = true;
                } else if (tile.rotateSign(!up, angle, true)) {
                    success = true;
                }
            }
            if (success) {
                tile.setChanged();
                if (world instanceof Level) {
                    Level level = (Level)world;
                    level.sendBlockUpdated(pos, state, state, 3);
                }
                return Optional.of(Direction.UP);
            }
        }
        return Optional.empty();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new SignPostBlockTile(pPos, pState);
    }
}

