/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidConsumer;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PancakeBlock
extends WaterBlock
implements ISoftFluidConsumer {
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[8];
    public static final IntegerProperty PANCAKES;
    public static final EnumProperty<ModBlockProperties.Topping> TOPPING;

    public PancakeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PANCAKES, (Comparable)Integer.valueOf(1))).setValue(TOPPING, (Comparable)((Object)ModBlockProperties.Topping.NONE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.canEat(false)) {
            player.getFoodData().eat(1, 0.1f);
            player.playSound(SoundEvents.GENERIC_EAT, 1.0f, 1.0f);
            if (!level.isClientSide) {
                this.removeLayer(state, pos, level, player);
                return InteractionResult.CONSUME;
            }
            Minecraft.getInstance().particleEngine.destroy(player.blockPosition().above(1), state);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Item item = stack.getItem();
        Pair<ModBlockProperties.Topping, Item> found = ModBlockProperties.Topping.fromItem(stack.getItem());
        if (PancakeBlock.setTopping(state, level, pos, (ModBlockProperties.Topping)((Object)found.getFirst()))) {
            Item empty = (Item)found.getSecond();
            ItemStack returnItem = empty.getDefaultInstance();
            if (!player.isCreative()) {
                Utils.swapItem((Player)player, (InteractionHand)handIn, (ItemStack)returnItem);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (item == this.asItem()) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static boolean setTopping(BlockState state, Level worldIn, BlockPos pos, ModBlockProperties.Topping topping) {
        if (state.getValue(TOPPING) == ModBlockProperties.Topping.NONE && topping != ModBlockProperties.Topping.NONE) {
            if (!worldIn.isClientSide) {
                worldIn.setBlock(pos, (BlockState)state.setValue(TOPPING, (Comparable)((Object)topping)), 3);
                worldIn.playSound(null, pos, SoundEvents.HONEY_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
            return true;
        }
        return false;
    }

    private void removeLayer(BlockState state, BlockPos pos, Level world, Player player) {
        BlockPos up;
        BlockState upState;
        int i = (Integer)state.getValue((Property)PANCAKES);
        if (i == 8 && (upState = world.getBlockState(up = pos.above())).getBlock() == state.getBlock()) {
            this.removeLayer(upState, up, world, player);
            return;
        }
        if (i > 1) {
            world.setBlock(pos, (BlockState)state.setValue((Property)PANCAKES, (Comparable)Integer.valueOf(i - 1)), 3);
        } else {
            world.removeBlock(pos, false);
        }
        if (state.getValue(TOPPING) != ModBlockProperties.Topping.NONE) {
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 160));
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        if (blockstate.is((Block)this)) {
            return (BlockState)blockstate.setValue((Property)PANCAKES, (Comparable)Integer.valueOf(Math.min(8, (Integer)blockstate.getValue((Property)PANCAKES) + 1)));
        }
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    protected boolean isValidGround(BlockState state, BlockGetter level, BlockPos pos) {
        return !state.getCollisionShape(level, pos).getFaceShape(Direction.UP).isEmpty() || state.isFaceSturdy(level, pos, Direction.UP);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        return this.isValidGround(worldIn.getBlockState(blockpos), (BlockGetter)worldIn, blockpos);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (!stateIn.canSurvive((LevelReader)worldIn, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return useContext.getItemInHand().getItem() == this.asItem() && (Integer)state.getValue((Property)PANCAKES) < 8 || super.canBeReplaced(state, useContext);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER[(Integer)state.getValue((Property)PANCAKES) - 1];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PANCAKES, TOPPING, WATERLOGGED});
    }

    public boolean tryAcceptingFluid(Level world, BlockState state, BlockPos pos, SoftFluidStack fluid) {
        ModBlockProperties.Topping topping = ModBlockProperties.Topping.fromFluid(fluid);
        if (state.getValue(TOPPING) == ModBlockProperties.Topping.NONE && topping != ModBlockProperties.Topping.NONE) {
            world.setBlock(pos, (BlockState)state.setValue(TOPPING, (Comparable)((Object)topping)), 2);
            world.playSound(null, pos, SoundEvents.HONEY_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.2f);
            return true;
        }
        return false;
    }

    static {
        Arrays.setAll(SHAPE_BY_LAYER, l -> Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)(2.0 + (double)(l * 2)), (double)14.0));
        PANCAKES = ModBlockProperties.PANCAKES_1_8;
        TOPPING = ModBlockProperties.TOPPING;
    }
}

