/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.TreeMap;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FeatherBlock
extends Block {
    protected static final VoxelShape COLLISION_SHAPE;
    private static final TreeMap<Float, VoxelShape> COLLISIONS;
    private final VoxelShape COLLISION_CHECK_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.1, (double)16.0);

    public FeatherBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float height) {
        if (!world.isClientSide) {
            if (height > 2.0f) {
                world.playSound(null, pos, SoundEvents.WOOL_FALL, SoundSource.BLOCKS, 1.0f, 0.9f);
            }
            double amount = Math.min(6.0, (double)height * 0.8);
            NetworkHelper.sendToAllClientPlayersInDefaultRange((ServerLevel)((ServerLevel)world), (BlockPos)pos, (CustomPacketPayload)new ClientBoundParticlePacket(entity.position(), ClientBoundParticlePacket.Kind.FEATHER, (int)amount, new Vec3(0.0, (double)height, 0.0)));
        }
    }

    public void updateEntityAfterFallOn(BlockGetter reader, Entity entity) {
        entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.4, 1.0));
    }

    private boolean isColliding(Entity e, BlockPos pos) {
        if (e == null) {
            return false;
        }
        VoxelShape voxelshape = this.COLLISION_CHECK_SHAPE.move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        return Shapes.joinIsNotEmpty((VoxelShape)voxelshape, (VoxelShape)Shapes.create((AABB)e.getBoundingBox()), (BooleanOp)BooleanOp.AND);
    }

    public void entityInside(BlockState state, Level level, BlockPos blockPos, Entity entity) {
        if (!(level.isClientSide || entity instanceof LivingEntity && !entity.getBlockStateOn().is((Block)this))) {
            boolean isMoving;
            RandomSource random = level.getRandom();
            boolean bl = isMoving = entity.xOld != entity.getX() || entity.zOld != entity.getZ();
            if (isMoving && random.nextInt(10) == 0) {
                double dy = 0.001;
                NetworkHelper.sendToAllClientPlayersInParticleRange((ServerLevel)((ServerLevel)level), (BlockPos)blockPos, (CustomPacketPayload)new ClientBoundParticlePacket(entity.position(), ClientBoundParticlePacket.Kind.FEATHER, 1, new Vec3(0.0, dy, 0.0)));
            }
        }
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Float key;
        LivingEntity entity;
        float dy;
        EntityCollisionContext entityCollisionContext;
        Entity e;
        if (collisionContext instanceof EntityCollisionContext && (e = (entityCollisionContext = (EntityCollisionContext)collisionContext).getEntity()) instanceof LivingEntity && (dy = (float)((entity = (LivingEntity)e).getY() - (double)blockPos.getY())) > 0.0f && (key = COLLISIONS.lowerKey(Float.valueOf(dy))) != null) {
            return COLLISIONS.getOrDefault(key, COLLISION_SHAPE);
        }
        return Shapes.block();
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        SoundType soundtype = state.getSoundType();
        level.playSound(null, pos, soundtype.getBreakSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
        if (level.isClientSide) {
            RandomSource r = level.random;
            for (int i = 0; i < 10; ++i) {
                level.addParticle((ParticleOptions)ModParticles.FEATHER_PARTICLE.get(), (double)((float)pos.getX() + r.nextFloat()), (double)((float)pos.getY() + r.nextFloat()), (double)((float)pos.getZ() + r.nextFloat()), (0.5 - (double)r.nextFloat()) * 0.02, (0.5 - (double)r.nextFloat()) * 0.02, (0.5 - (double)r.nextFloat()) * 0.02);
            }
        }
    }

    static {
        float y;
        COLLISION_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
        COLLISIONS = new TreeMap();
        float i = 0.0015f;
        COLLISIONS.put(Float.valueOf(y - i), Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)y, (double)1.0));
        for (y = (float)COLLISION_SHAPE.max(Direction.Axis.Y); y < 1.0f; y += (i *= 1.131f)) {
            COLLISIONS.put(Float.valueOf(y), Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)y, (double)1.0));
        }
        COLLISIONS.put(Float.valueOf(1.0f), Shapes.block());
        COLLISIONS.put(Float.valueOf(0.0f), Shapes.block());
    }
}

