/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.block.MimicBlock;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.RopeKnotBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRopeKnotBlock
extends MimicBlock
implements SimpleWaterloggedBlock,
EntityBlock,
IRotatable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final EnumProperty<ModBlockProperties.PostType> POST_TYPE = ModBlockProperties.POST_TYPE;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    private final Map<BlockState, VoxelShape> shapeMap;

    protected AbstractRopeKnotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        Pair<Map<BlockState, VoxelShape>, Map<BlockState, VoxelShape>> s = this.makeShapes();
        this.shapeMap = (Map)s.getFirst();
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(POST_TYPE, (Comparable)((Object)ModBlockProperties.PostType.POST))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, POST_TYPE, AXIS, NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new RopeKnotBlockTile(pPos, pState);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
            try {
                return tile.getShape();
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error("Failed to get block shape for rope knot block at {}", (Object)pos);
            }
        }
        return super.getShape(state, world, pos, context);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.shapeMap.getOrDefault(state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), Shapes.block());
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.shapeMap.getOrDefault(state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), Shapes.block());
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
            try {
                return tile.getCollisionShape();
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error("Failed to get collision shape for rope knot block at {}", (Object)pos);
            }
        }
        return super.getCollisionShape(state, world, pos, context);
    }

    protected Pair<Map<BlockState, VoxelShape>, Map<BlockState, VoxelShape>> makeShapes() {
        HashMap<BlockState, VoxelShape> shapesBuilder = new HashMap<BlockState, VoxelShape>();
        HashMap<BlockState, VoxelShape> collisionBuilder = new HashMap<BlockState, VoxelShape>();
        VoxelShape down = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape up = Block.box((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape north = this.getSideShape();
        VoxelShape south = MthUtils.rotateVoxelShape((VoxelShape)north, (Direction)Direction.SOUTH);
        VoxelShape west = MthUtils.rotateVoxelShape((VoxelShape)north, (Direction)Direction.WEST);
        VoxelShape east = MthUtils.rotateVoxelShape((VoxelShape)north, (Direction)Direction.EAST);
        for (BlockState state : this.stateDefinition.getPossibleStates()) {
            VoxelShape v;
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) continue;
            int w = ((ModBlockProperties.PostType)((Object)state.getValue(POST_TYPE))).getWidth();
            double o = (double)(16 - w) / 2.0;
            VoxelShape c = switch ((Direction.Axis)state.getValue(AXIS)) {
                default -> {
                    v = Block.box((double)o, (double)0.0, (double)o, (double)(o + (double)w), (double)16.0, (double)(o + (double)w));
                    yield Block.box((double)o, (double)0.0, (double)o, (double)(o + (double)w), (double)24.0, (double)(o + (double)w));
                }
                case Direction.Axis.X -> v = Block.box((double)0.0, (double)o, (double)o, (double)16.0, (double)(o + (double)w), (double)(o + (double)w));
                case Direction.Axis.Z -> v = Block.box((double)o, (double)o, (double)0.0, (double)(o + (double)w), (double)(o + (double)w), (double)16.0);
            };
            if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)down);
            }
            if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)up);
            }
            if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)north);
            }
            if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)south);
            }
            if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)west);
            }
            if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)east);
            }
            c = Shapes.or((VoxelShape)c, (VoxelShape)v);
            c = c.optimize();
            v = v.optimize();
            boolean flag = true;
            for (VoxelShape existing : shapesBuilder.values()) {
                if (!existing.equals(v)) continue;
                shapesBuilder.put(state, existing);
                flag = false;
                break;
            }
            if (flag) {
                shapesBuilder.put(state, v);
            }
            boolean flag2 = true;
            for (VoxelShape existing : collisionBuilder.values()) {
                if (!existing.equals(c)) continue;
                collisionBuilder.put(state, existing);
                flag2 = false;
                break;
            }
            if (!flag2) continue;
            collisionBuilder.put(state, c);
        }
        return Pair.of((Object)ImmutableMap.copyOf(shapesBuilder), (Object)ImmutableMap.copyOf(collisionBuilder));
    }

    public abstract VoxelShape getSideShape();

    public BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                BlockState blockState = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
                break;
            }
            case COUNTERCLOCKWISE_90: {
                BlockState blockState = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)NORTH)));
                break;
            }
            case CLOCKWISE_90: {
                BlockState blockState = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)SOUTH)));
                break;
            }
            default: {
                BlockState blockState = state = state;
            }
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            return state;
        }
        return switch ((Direction.Axis)state.getValue(AXIS)) {
            case Direction.Axis.X -> (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
            case Direction.Axis.Z -> (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
            default -> state;
        };
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            default -> super.mirror(state, mirror);
        };
    }

    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        if (axis.getAxis() == Direction.Axis.Y) {
            return Optional.ofNullable(this.rotate(state, rotation));
        }
        return Optional.empty();
    }

    public void onRotated(BlockState newState, BlockState oldState, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        BlockEntity blockEntity;
        if (axis.getAxis() == Direction.Axis.Y && (blockEntity = world.getBlockEntity(pos)) instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
            BlockState mimic = tile.getHeldBlock();
            BlockState newMimic = tile.getHeldBlock().rotate(rotation);
            if (newMimic != mimic) {
                tile.setHeldBlock(newMimic);
                tile.setChanged();
            }
        }
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.is(FluidTags.WATER) && fluidstate.getAmount() == 8;
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nullable
    public static BlockState convertToRopeKnot(ModBlockProperties.PostType type, BlockState state, Level world, BlockPos pos) {
        if (state.getBlock() instanceof EntityBlock) {
            return null;
        }
        Direction.Axis axis = Direction.Axis.Y;
        if (state.hasProperty((Property)BlockStateProperties.AXIS)) {
            axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
        }
        BlockState newState = (BlockState)((BlockState)ModRegistry.ROPE_KNOT.get().defaultBlockState().setValue(AXIS, (Comparable)axis)).setValue(POST_TYPE, (Comparable)((Object)type));
        if (!world.setBlock(pos, newState = Block.updateFromNeighbourShapes((BlockState)newState, (LevelAccessor)world, (BlockPos)pos), 0)) {
            return null;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
            tile.setHeldBlock(state);
            tile.setChanged();
        }
        newState.updateNeighbourShapes((LevelAccessor)world, pos, 6);
        return newState;
    }
}

