/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import net.mehvahdjukaar.supplementaries.client.particles.DirectionOrientedBillboardParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class WindTrailParticle
extends DirectionOrientedBillboardParticle {
    private final float maxAlpha;
    private final Entity entity;
    private final double xOff;
    private final double yOff;
    private final double zOff;

    protected WindTrailParticle(ClientLevel level, double xOff, double yOff, double zOff, Entity trackingEntity, SpriteSet sprites) {
        super(level, trackingEntity.xo + xOff, trackingEntity.yo + yOff, trackingEntity.zo + zOff);
        this.pickSprite(sprites);
        this.entity = trackingEntity;
        this.xOff = xOff;
        this.yOff = yOff;
        this.zOff = zOff;
        this.lifetime = 5 + this.random.nextInt(10);
        double normalizedTick = (double)this.entity.tickCount / (double)this.lifetime;
        if (normalizedTick < 0.5) {
            this.age += this.random.nextInt(Mth.ceil((double)((0.5 - normalizedTick) * (double)this.lifetime)));
        }
        this.quadSize *= 7.0f;
        this.maxAlpha = 0.3f + this.random.nextFloat() * 0.65f;
        Vec3 sp = this.entity.getDeltaMovement();
        this.xd = sp.x;
        this.yd = sp.y;
        this.zd = sp.z;
        this.updateAlpha();
    }

    private void updateAlpha() {
        this.alpha = (float)((double)this.maxAlpha * Mth.clamp((double)(this.speed() * 1.0 - 0.15), (double)0.0, (double)1.0));
        float percentage = (float)this.age / (float)this.lifetime;
        float fadeStart = 0.5f;
        if (percentage > fadeStart) {
            float fadeFactor = (1.0f - percentage) / (1.0f - fadeStart);
            this.alpha *= fadeFactor;
        }
    }

    private double speed() {
        return Math.sqrt(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd);
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        if (this.entity == null || this.entity.isRemoved()) {
            this.remove();
            return;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        this.x = this.entity.xo + this.xOff;
        this.y = this.entity.yo + this.yOff;
        this.z = this.entity.zo + this.zOff;
        Vec3 sp = this.entity.getDeltaMovement();
        this.xd = sp.x;
        this.yd = sp.y;
        this.zd = sp.z;
        this.updateAlpha();
    }

    protected float getU0() {
        return super.getU0();
    }

    protected float getV0() {
        float p = (float)this.age / (float)this.lifetime;
        return this.sprite.getV(p / 24.0f);
    }

    protected float getV1() {
        float p = (float)this.age / (float)this.lifetime;
        return this.sprite.getV((8.0f + p * 16.0f) / 24.0f * 16.0f / 16.0f);
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double entityId, double a, double b) {
            Entity entity = worldIn.getEntity((int)entityId);
            if (entity != null) {
                return new WindTrailParticle(worldIn, x, y, z, entity, this.sprite);
            }
            return null;
        }
    }
}

