/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.wand;

import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.nicguzzo.wands.WandsExpectPlatform;
import net.nicguzzo.wands.WandsMod;
import net.nicguzzo.wands.config.WandsConfig;
import net.nicguzzo.wands.items.MagicBagItem;
import net.nicguzzo.wands.items.PaletteItem;
import net.nicguzzo.wands.items.WandItem;
import net.nicguzzo.wands.mixin.DropExperienceBlockAccessor;
import net.nicguzzo.wands.networking.Networking;
import net.nicguzzo.wands.utils.BlockBuffer;
import net.nicguzzo.wands.utils.CircularBuffer;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.utils.WandUtils;
import net.nicguzzo.wands.wand.BlockAccounting;
import net.nicguzzo.wands.wand.CopyBuffer;
import net.nicguzzo.wands.wand.Palette;
import net.nicguzzo.wands.wand.WandMode;
import net.nicguzzo.wands.wand.WandProps;

public class Wand {
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public int x1 = 0;
    public int y1 = 0;
    public int z1 = 0;
    public int x2 = 0;
    public int y2 = 0;
    public int z2 = 0;
    public int bb1_x = 0;
    public int bb1_y = 0;
    public int bb1_z = 0;
    public int bb2_x = 0;
    public int bb2_y = 0;
    public int bb2_z = 0;
    public int fill_nx = 0;
    public int fill_ny = 0;
    public int fill_nz = 0;
    private BlockPos p1 = null;
    private BlockPos p2 = null;
    public BlockState p1_state = null;
    public HitResult lastHitResult = null;
    public boolean valid = false;
    public Player player;
    public Level level;
    public BlockState block_state;
    public BlockState offhand_state = null;
    Block offhand_block = null;
    public BlockPos pos;
    public Direction side = Direction.NORTH;
    public Direction lastPlayerDirection = Direction.NORTH;
    public Vec3 hit;
    public ItemStack wand_stack;
    ItemStack[] tools = new ItemStack[36];
    int n_tools = 0;
    ItemStack offhand;
    ItemStack digger_item;
    public int digger_item_slot = 0;
    public float y0 = 0.0f;
    public float block_height = 1.0f;
    boolean is_stair = false;
    boolean is_slab_top = false;
    boolean is_slab_bottom = false;
    public boolean is_alt_pressed = false;
    public boolean is_shift_pressed = false;
    public boolean replace;
    public boolean destroy;
    public boolean use;
    boolean stop = false;
    ItemStack bucket = null;
    public boolean is_double_slab = false;
    public int grid_voxel_index = 0;
    boolean has_bucket = false;
    public boolean has_water_bucket = false;
    public boolean has_lava_bucket = false;
    public boolean has_empty_bucket = false;
    boolean has_water_potion = false;
    int send_sound = -1;
    boolean has_offhand = false;
    public boolean has_hoe = false;
    public boolean has_shovel = false;
    public boolean has_axe = false;
    public boolean has_shear = false;
    public boolean force_render = false;
    public boolean limit_reached = false;
    public WandProps.Plane plane = WandProps.Plane.XZ;
    public Direction.Axis axis = Direction.Axis.Y;
    public Rotation rotation;
    public WandProps.StateMode state_mode = WandProps.StateMode.CLONE;
    private boolean no_tool;
    private boolean damaged_tool;
    public boolean match_state = false;
    public boolean mine_to_inventory = true;
    public boolean stop_on_full_inventory = true;
    public boolean target_air = false;
    public boolean unbreakable = false;
    public boolean removes_water = false;
    public boolean removes_lava = false;
    public boolean can_blast = false;
    public RandomSource random = RandomSource.create();
    public Palette palette = new Palette();
    public Map<Item, BlockAccounting> block_accounting = new HashMap<Item, BlockAccounting>();
    public BlockBuffer block_buffer = new BlockBuffer(WandsConfig.max_limit);
    public CircularBuffer undo_buffer = new CircularBuffer(WandsConfig.max_limit);
    public Vector<CopyBuffer> copy_paste_buffer = new Vector();
    private final BlockPos.MutableBlockPos tmp_pos = new BlockPos.MutableBlockPos();
    private int blocks_sent_to_inv = 0;
    public int MAX_COPY_VOL = WandsConfig.max_limit;
    public int radius = 0;
    public boolean preview;
    public boolean creative = true;
    public WandProps.Mode mode = null;
    public boolean prnt = false;
    public int limit = WandsConfig.max_limit;
    Inventory player_inv;
    public boolean slab_stair_bottom = true;
    static boolean once = true;
    WandMode[] modes = null;
    int[] inv_aux = new int[36];
    int inv_aux_last = 0;
    public boolean drop_on_player = true;
    public CompoundTag player_data;

    public BlockPos getP1() {
        return this.p1;
    }

    public void setP1(BlockPos p1) {
        this.p1 = p1;
    }

    public BlockPos getP2() {
        return this.p2;
    }

    public void setP2(BlockPos p2) {
        this.p2 = p2;
    }

    public Wand() {
        this.modes = new WandMode[WandProps.modes.length];
        for (int i = 0; i < this.modes.length; ++i) {
            this.modes[i] = WandProps.modes[i].get_mode();
        }
    }

    public void clear() {
        this.setP1(null);
        this.setP2(null);
        this.p1_state = null;
        this.valid = false;
        this.block_height = 1.0f;
        this.y0 = 0.0f;
        this.fill_nx = 0;
        this.fill_ny = 0;
        this.fill_nz = 0;
    }

    public void do_or_preview(Player player, Level level, BlockState block_state, BlockPos pos, Direction side, Vec3 hit, ItemStack wand_stack, WandItem wand_item, boolean prnt) {
        boolean is_water_bucket;
        ItemStack stack;
        int i;
        if (wand_stack == null || wand_item == null) {
            return;
        }
        this.limit = wand_item.limit;
        if (this.limit > WandsConfig.max_limit) {
            this.limit = WandsConfig.max_limit;
        }
        this.unbreakable = wand_item.unbreakable;
        this.removes_water = wand_item.removes_water;
        this.removes_lava = wand_item.removes_lava;
        this.can_blast = wand_item.can_blast;
        this.replace = WandProps.getAction(wand_stack) == WandProps.Action.REPLACE;
        this.destroy = WandProps.getAction(wand_stack) == WandProps.Action.DESTROY;
        this.use = WandProps.getAction(wand_stack) == WandProps.Action.USE;
        this.target_air = WandProps.getFlag(wand_stack, WandProps.Flag.TARGET_AIR);
        if ((this.destroy || this.replace) && WandsMod.config.disable_destroy_replace) {
            this.destroy = false;
            this.replace = false;
            WandProps.setAction(wand_stack, WandProps.Action.PLACE);
        }
        this.player = player;
        this.level = level;
        this.block_state = block_state;
        this.pos = pos;
        this.side = side;
        this.hit = hit;
        this.wand_stack = wand_stack;
        this.prnt = prnt;
        if (this.player == null || this.level == null || this.pos == null || this.side == null || this.hit == null || this.wand_stack == null) {
            return;
        }
        this.creative = Compat.is_creative(player);
        this.check_advancements();
        this.mode = WandProps.getMode(wand_stack);
        this.axis = WandProps.getAxis(wand_stack);
        this.plane = WandProps.getPlane(wand_stack);
        this.rotation = WandProps.getRotation(wand_stack);
        this.state_mode = WandProps.getStateMode(wand_stack);
        this.slab_stair_bottom = WandProps.getFlag(wand_stack, WandProps.Flag.STAIRSLAB);
        this.match_state = WandProps.getFlag(wand_stack, WandProps.Flag.MATCHSTATE);
        this.player_inv = Compat.get_inventory(player);
        this.y0 = 0.0f;
        this.block_height = 1.0f;
        this.is_slab_top = false;
        this.is_double_slab = false;
        this.is_slab_bottom = false;
        this.is_stair = false;
        this.preview = level.isClientSide();
        this.offhand_state = null;
        this.stop = false;
        this.radius = 0;
        this.limit_reached = false;
        this.send_sound = -1;
        this.random.setSeed(this.palette.seed);
        this.palette.random.setSeed(this.palette.seed);
        if (block_state == null || pos == null || side == null || level == null || player == null || hit == null || wand_stack == null) {
            return;
        }
        if (once) {
            once = false;
            WandsMod.config.generate_lists();
        }
        boolean is_copy_paste = this.mode == WandProps.Mode.COPY || this.mode == WandProps.Mode.PASTE;
        this.valid = false;
        this.offhand = player.getOffhandItem();
        this.has_offhand = false;
        this.has_hoe = false;
        this.has_shovel = false;
        this.has_axe = false;
        this.update_tools();
        if (this.offhand != null && WandUtils.is_shulker(this.offhand)) {
            this.offhand = null;
        }
        this.palette.item = null;
        this.palette.has_palette = false;
        this.has_bucket = false;
        this.has_water_bucket = false;
        this.has_lava_bucket = false;
        this.has_empty_bucket = false;
        if (this.offhand != null && this.offhand.getItem() instanceof PaletteItem) {
            this.palette.item = this.offhand;
            this.palette.has_palette = true;
        }
        if (this.offhand != null && this.offhand.getItem() instanceof BucketItem && this.mode != WandProps.Mode.DIRECTION) {
            this.bucket = this.offhand;
            this.has_bucket = true;
            this.has_empty_bucket = this.bucket.isStackable();
            if (!this.has_empty_bucket) {
                this.has_water_bucket = this.bucket.getItem().equals(Fluids.WATER.getBucket());
                if (!this.has_water_bucket) {
                    this.has_lava_bucket = this.bucket.getItem().equals(Fluids.LAVA.getBucket());
                }
            }
            this.replace = false;
            this.destroy = false;
            this.use = false;
        }
        if (this.offhand != null && this.offhand.getItem() instanceof PotionItem) {
            PotionContents potion_c;
            this.has_water_potion = false;
            if (this.offhand.has(DataComponents.POTION_CONTENTS) && (potion_c = (PotionContents)this.offhand.get(DataComponents.POTION_CONTENTS)) != null) {
                this.has_water_potion = potion_c.is(Potions.WATER);
            }
            if (!this.creative && this.has_water_potion) {
                int nbuckets = 0;
                for (i = 0; i < 36; ++i) {
                    stack = this.player_inv.getItem(i);
                    is_water_bucket = stack.getItem().equals(Fluids.WATER.getBucket());
                    if (!(stack.getItem() instanceof BucketItem) || !is_water_bucket) continue;
                    ++nbuckets;
                }
                if (nbuckets < 2) {
                    this.has_water_potion = false;
                    if (!this.preview) {
                        player.displayClientMessage((Component)Compat.literal("You need 2 water buckets in the inventory."), false);
                    }
                    return;
                }
            }
        }
        if (this.offhand != null) {
            this.offhand_block = Block.byItem((Item)this.offhand.getItem());
            if (this.offhand_block != Blocks.AIR) {
                this.has_offhand = true;
            }
        }
        if (!(this.offhand == null || this.offhand.isEmpty() || this.palette.has_palette || this.has_bucket || this.destroy)) {
            if (this.offhand.get(DataComponents.CUSTOM_DATA) != null) {
                this.offhand = null;
                this.has_offhand = false;
                this.offhand_block = null;
            }
            if (this.offhand != null && !this.offhand.isStackable() && !this.has_water_potion) {
                if (!this.preview) {
                    player.displayClientMessage((Component)Compat.literal("Wand offhand must be stackable! ").withStyle(ChatFormatting.RED), false);
                }
                this.offhand = null;
                this.has_offhand = false;
                this.offhand_block = null;
                return;
            }
        }
        this.block_accounting.clear();
        if (this.palette.has_palette) {
            this.palette.update_palette(this.block_accounting, level);
        }
        if (!this.palette.has_palette && !this.has_bucket && this.offhand_block != null && Blocks.AIR != this.offhand_block) {
            this.offhand_state = this.offhand_block.defaultBlockState();
        }
        if (this.replace && this.mode != WandProps.Mode.PASTE && !this.palette.has_palette && (Blocks.AIR == this.offhand_block || this.offhand_block == null)) {
            this.valid = false;
            if (!this.preview) {
                player.displayClientMessage((Component)Compat.literal("you need a block or palette in the left hand"), false);
            }
            return;
        }
        this.update_inv_aux();
        this.blocks_sent_to_inv = 0;
        int m = this.mode.ordinal();
        if (m >= 0 && m < this.modes.length && this.modes[m] != null) {
            this.modes[m].place_in_buffer(this);
        }
        if (!this.preview) {
            if (this.limit_reached && this.mode != WandProps.Mode.VEIN) {
                player.displayClientMessage((Component)Compat.literal("wand limit reached"), false);
            }
            if (this.mode != WandProps.Mode.BLAST) {
                if (this.palette.has_palette && !this.destroy && !this.use && !is_copy_paste) {
                    for (a = 0; a < this.block_buffer.get_length() && a < this.limit && a < WandsConfig.max_limit; ++a) {
                        BlockAccounting pa;
                        Item it;
                        if (!this.replace && !this.can_place(level.getBlockState(this.block_buffer.get(a)), this.block_buffer.get(a))) {
                            this.block_buffer.state[a] = null;
                            this.block_buffer.item[a] = null;
                            continue;
                        }
                        BlockState st = this.block_buffer.state[a];
                        if (st == null || (it = this.block_buffer.item[a]) == null || (pa = this.block_accounting.get(it)) == null) continue;
                        ++pa.needed;
                        if (st.getBlock() instanceof SlabBlock) {
                            if (st.getValue((Property)SlabBlock.TYPE) != SlabType.DOUBLE) continue;
                            ++pa.needed;
                            continue;
                        }
                        if (!(st.getBlock() instanceof SnowLayerBlock)) continue;
                        int sn = (Integer)st.getValue((Property)SnowLayerBlock.LAYERS);
                        pa.needed += sn - 1;
                    }
                } else if (!is_copy_paste) {
                    if (this.has_bucket) {
                        this.has_bucket = false;
                        if (this.has_water_bucket || this.has_lava_bucket) {
                            if (this.creative) {
                                this.has_bucket = true;
                                if (this.has_water_bucket) {
                                    block_state = Blocks.WATER.defaultBlockState();
                                }
                                if (this.has_lava_bucket) {
                                    block_state = Blocks.LAVA.defaultBlockState();
                                }
                            } else {
                                if (this.has_water_bucket) {
                                    for (i = 0; i < 36; ++i) {
                                        stack = this.player_inv.getItem(i);
                                        is_water_bucket = stack.getItem().equals(Fluids.WATER.getBucket());
                                        if (!(stack.getItem() instanceof BucketItem) || !is_water_bucket) continue;
                                        this.has_bucket = true;
                                        this.has_water_bucket = true;
                                        block_state = Blocks.WATER.defaultBlockState();
                                        break;
                                    }
                                    if (!this.has_bucket) {
                                        player.displayClientMessage((Component)Compat.literal("You need another water bucket in the inventory."), false);
                                        return;
                                    }
                                }
                                if (this.has_lava_bucket) {
                                    block_state = Blocks.LAVA.defaultBlockState();
                                }
                            }
                        }
                        if (this.has_empty_bucket) {
                            this.has_bucket = true;
                            block_state = Blocks.AIR.defaultBlockState();
                        }
                    }
                    BlockAccounting pa = new BlockAccounting();
                    for (int a = 0; a < this.block_buffer.get_length() && a < this.limit && a < WandsConfig.max_limit; ++a) {
                        if (this.has_empty_bucket || this.has_water_bucket || this.has_lava_bucket) {
                            this.block_buffer.state[a] = block_state;
                            if (!this.has_lava_bucket) continue;
                            this.block_buffer.item[a] = this.bucket.getItem();
                            ++pa.needed;
                            continue;
                        }
                        if (!(this.replace || this.destroy || this.use || this.can_place(level.getBlockState(this.block_buffer.get(a)), this.block_buffer.get(a)))) {
                            this.block_buffer.state[a] = null;
                            this.block_buffer.item[a] = null;
                            continue;
                        }
                        ++pa.needed;
                    }
                    if (this.block_buffer.get_length() > 0 && pa.needed > 0) {
                        this.block_accounting.put(this.block_buffer.item[0], pa);
                    }
                } else {
                    for (a = 0; a < this.block_buffer.get_length() && a < this.limit && a < WandsConfig.max_limit; ++a) {
                        if (!(this.replace || this.destroy || this.can_place(level.getBlockState(this.block_buffer.get(a)), this.block_buffer.get(a)))) {
                            this.block_buffer.state[a] = null;
                            this.block_buffer.item[a] = null;
                            continue;
                        }
                        BlockAccounting pa = this.block_accounting.get(this.block_buffer.item[a]);
                        if (pa == null) {
                            pa = new BlockAccounting();
                            ++pa.needed;
                            this.block_accounting.put(this.block_buffer.item[a], pa);
                            continue;
                        }
                        ++pa.needed;
                    }
                }
            }
            this.check_inventory();
            int placed = 0;
            AABB bb = player.getBoundingBox();
            if (this.mode != WandProps.Mode.COPY) {
                for (int a = 0; a < this.block_buffer.get_length() && a < this.limit && a < WandsConfig.max_limit; ++a) {
                    this.tmp_pos.set(this.block_buffer.buffer_x[a], this.block_buffer.buffer_y[a], this.block_buffer.buffer_z[a]);
                    if (!(this.destroy || this.has_bucket || this.use)) {
                        if (bb.intersects((double)this.tmp_pos.getX(), (double)this.tmp_pos.getY(), (double)this.tmp_pos.getZ(), (double)(this.tmp_pos.getX() + 1), (double)(this.tmp_pos.getY() + 1), (double)(this.tmp_pos.getZ() + 1))) continue;
                        boolean pp = false;
                        for (Player pl : Compat.player_level(player).players()) {
                            if (!pl.getBoundingBox().intersects((double)this.tmp_pos.getX(), (double)this.tmp_pos.getY(), (double)this.tmp_pos.getZ(), (double)(this.tmp_pos.getX() + 1), (double)(this.tmp_pos.getY() + 1), (double)(this.tmp_pos.getZ() + 1))) continue;
                            pp = true;
                            break;
                        }
                        if (pp) continue;
                    }
                    Item item = this.block_buffer.item[a];
                    BlockAccounting pa = null;
                    if (item != null) {
                        pa = this.block_accounting.get(item);
                    }
                    if ((this.destroy || this.use || this.creative || this.has_bucket || pa != null && pa.placed < pa.in_player) && this.place_block((BlockPos)this.tmp_pos, this.block_buffer.state[a])) {
                        if (pa != null) {
                            ++pa.placed;
                        }
                        ++placed;
                    }
                    if (this.stop) break;
                }
            }
            this.modes[m].action(this);
            this.remove_from_inventory(placed);
            if (placed > 0 || this.no_tool || this.damaged_tool) {
                if (this.blocks_sent_to_inv > 0) {
                    MutableComponent mc = Compat.literal(this.blocks_sent_to_inv + " blocks sent to bag/shulker").withStyle(ChatFormatting.BLUE);
                    player.displayClientMessage((Component)mc, false);
                }
                ItemStack is = ItemStack.EMPTY;
                if (!this.no_tool && !this.damaged_tool) {
                    if (this.p1_state != null) {
                        is = this.p1_state.getBlock().asItem().getDefaultInstance();
                    } else if (block_state != null) {
                        is = block_state.getBlock().asItem().getDefaultInstance();
                    }
                }
                if (!is.isEmpty()) {
                    NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new Networking.SndPacket(pos, this.destroy, is, this.send_sound));
                }
                if (this.no_tool || this.damaged_tool) {
                    NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new Networking.ToastPacket(this.no_tool, this.damaged_tool));
                }
                this.no_tool = false;
                this.damaged_tool = false;
            }
        }
        if (this.getP2() != null) {
            this.setP1(null);
            this.setP2(null);
            this.valid = false;
        }
    }

    ItemStack consume_item(BlockAccounting pa, ItemStack stack_item) {
        if (pa != null && pa.placed > 0) {
            if (WandUtils.is_magicbag(stack_item)) {
                int total = MagicBagItem.getTotal(stack_item);
                if (pa.placed <= total) {
                    MagicBagItem.dec(stack_item, pa.placed);
                    pa.placed = 0;
                } else {
                    MagicBagItem.dec(stack_item, total);
                    pa.placed -= total;
                }
            } else {
                if (stack_item.getItem().equals(Fluids.LAVA.getBucket())) {
                    --pa.placed;
                    ItemStack ret = Items.BUCKET.getDefaultInstance();
                    return ret;
                }
                if (pa.placed <= stack_item.getCount()) {
                    stack_item.setCount(stack_item.getCount() - pa.placed);
                    pa.placed = 0;
                } else {
                    pa.placed -= stack_item.getCount();
                    stack_item.setCount(0);
                }
            }
            return ItemStack.EMPTY;
        }
        return null;
    }

    public void skip() {
        int skip_probability = WandProps.getVal(this.wand_stack, WandProps.Value.SKIPBLOCK);
        if (skip_probability > 0) {
            for (int a = 0; a < this.block_buffer.get_length(); ++a) {
                boolean skip;
                int r = this.random.nextInt(100);
                boolean bl = skip = r >= skip_probability;
                if (skip) continue;
                this.block_buffer.state[a] = null;
            }
        }
    }

    public void calc_pv_bbox(BlockPos bp1, BlockPos bp2) {
        this.x1 = bp1.getX();
        this.y1 = bp1.getY();
        this.z1 = bp1.getZ();
        this.x2 = bp2.getX();
        this.y2 = bp2.getY();
        this.z2 = bp2.getZ();
        if (!bp1.equals((Object)bp2)) {
            if (this.x1 >= this.x2) {
                ++this.x1;
                this.bb1_x = this.x2;
                this.bb2_x = this.x1;
            } else {
                ++this.x2;
                this.bb1_x = this.x1;
                this.bb2_x = this.x2;
            }
            if (this.y1 >= this.y2) {
                ++this.y1;
                this.bb1_y = this.y2;
                this.bb2_y = this.y1;
            } else {
                ++this.y2;
                this.bb1_y = this.y1;
                this.bb2_y = this.y2;
            }
            if (this.z1 >= this.z2) {
                ++this.z1;
                this.bb1_z = this.z2;
                this.bb2_z = this.z1;
            } else {
                ++this.z2;
                this.bb1_z = this.z1;
                this.bb2_z = this.z2;
            }
        } else {
            this.x2 = this.x1 + 1;
            this.y2 = this.y1 + 1;
            this.z2 = this.z1 + 1;
            this.bb1_x = this.x1;
            this.bb1_y = this.y1;
            this.bb1_z = this.z1;
            this.bb2_x = this.x2;
            this.bb2_y = this.y2;
            this.bb2_z = this.z2;
        }
    }

    public BlockState rotate_mirror(BlockState st, int mirroraxis) {
        switch (mirroraxis) {
            case 1: {
                if (this.rotation == Rotation.NONE || this.rotation == Rotation.CLOCKWISE_180) {
                    return st.mirror(Mirror.FRONT_BACK).rotate(this.rotation);
                }
                return st.mirror(Mirror.FRONT_BACK).rotate(this.rotation.getRotated(Rotation.CLOCKWISE_180));
            }
            case 2: {
                if (this.rotation == Rotation.NONE || this.rotation == Rotation.CLOCKWISE_180) {
                    return st.mirror(Mirror.FRONT_BACK).rotate(this.rotation.getRotated(Rotation.CLOCKWISE_180));
                }
                return st.mirror(Mirror.FRONT_BACK).rotate(this.rotation);
            }
        }
        return st.rotate(this.rotation);
    }

    public BlockState get_state() {
        BlockState st = this.block_state;
        if (this.palette.has_palette) {
            st = this.palette.get_state(this);
        } else {
            if (this.offhand_state != null && !this.offhand_state.isAir()) {
                st = this.offhand_state;
            } else if ((this.mode == WandProps.Mode.FILL || this.mode == WandProps.Mode.LINE || this.mode == WandProps.Mode.CIRCLE) && this.p1_state != null) {
                st = this.p1_state;
            }
            st = this.state_for_placement(st, null);
        }
        return st;
    }

    public Item get_item(BlockState state) {
        if (state != null) {
            return state.getBlock().asItem();
        }
        return null;
    }

    BlockState state_for_placement(BlockState st, BlockPos bp) {
        if (this.mode == WandProps.Mode.PASTE) {
            return st;
        }
        Block blk = st.getBlock();
        if (blk instanceof LeavesBlock) {
            return (BlockState)blk.defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true));
        }
        if (blk instanceof WallBlock || blk instanceof CrossCollisionBlock) {
            BlockHitResult hit_res = new BlockHitResult(this.hit, this.side, bp != null ? bp : this.pos, true);
            BlockPlaceContext pctx = new BlockPlaceContext(this.player, InteractionHand.OFF_HAND, st.getBlock().asItem().getDefaultInstance(), hit_res);
            return st.getBlock().getStateForPlacement(pctx);
        }
        if (this.state_mode == WandProps.StateMode.TARGET) {
            BlockHitResult hit_res = new BlockHitResult(this.hit, this.side, bp != null ? bp : this.pos, true);
            BlockPlaceContext pctx = new BlockPlaceContext(this.player, InteractionHand.OFF_HAND, st.getBlock().asItem().getDefaultInstance(), hit_res);
            return st.getBlock().getStateForPlacement(pctx);
        }
        if (this.state_mode == WandProps.StateMode.APPLY) {
            if (blk instanceof SlabBlock) {
                SlabType slab_type = this.slab_stair_bottom ? SlabType.BOTTOM : SlabType.TOP;
                return (BlockState)blk.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)slab_type);
            }
            if (blk instanceof StairBlock) {
                Half h = this.slab_stair_bottom ? Half.BOTTOM : Half.TOP;
                return ((BlockState)blk.defaultBlockState().setValue((Property)StairBlock.HALF, (Comparable)h)).rotate(this.rotation);
            }
            if (blk instanceof RotatedPillarBlock) {
                return (BlockState)blk.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)this.axis);
            }
            BlockHitResult hit_res = new BlockHitResult(this.hit, this.side, bp != null ? bp : this.pos, true);
            BlockPlaceContext pctx = new BlockPlaceContext(this.player, InteractionHand.OFF_HAND, st.getBlock().asItem().getDefaultInstance(), hit_res);
            return st.getBlock().getStateForPlacement(pctx);
        }
        return st;
    }

    public void undo(int n) {
        if (this.undo_buffer != null) {
            for (int i = 0; i < n && i < this.undo_buffer.size(); ++i) {
                CircularBuffer.P p = this.undo_buffer.peek();
                if (p == null) continue;
                if (!p.destroyed) {
                    if (!this.level.destroyBlock((BlockPos)p.pos, false)) continue;
                    this.undo_buffer.pop();
                    continue;
                }
                if (!p.state.canSurvive((LevelReader)this.level, (BlockPos)p.pos) || !this.level.setBlockAndUpdate((BlockPos)p.pos, p.state)) continue;
                this.undo_buffer.pop();
            }
        }
    }

    public void redo(int n) {
        if (this.undo_buffer != null) {
            for (int i = 0; i < n && this.undo_buffer.can_go_forward(); ++i) {
                this.undo_buffer.forward();
                CircularBuffer.P p = this.undo_buffer.peek();
                if (p == null || p.pos == null || p.state == null) continue;
                if (!p.destroyed) {
                    this.level.setBlockAndUpdate((BlockPos)p.pos, p.state);
                    continue;
                }
                this.level.setBlockAndUpdate((BlockPos)p.pos, Blocks.AIR.defaultBlockState());
            }
        }
    }

    public void validate_buffer() {
        boolean bl = this.valid = this.block_buffer.get_length() > 0 && this.block_buffer.get_length() <= this.limit;
        if (!this.preview && this.block_buffer.get_length() > this.limit) {
            this.limit_reached = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void fill(BlockPos from, BlockPos to, boolean hollow, int xskip, int yskip, int zskip) {
        int xs = from.getX();
        int xe = to.getX();
        int ys = from.getY();
        int ye = to.getY();
        int zs = from.getZ();
        int ze = to.getZ();
        int ox = xs >= xe ? -1 : 1;
        int oy = ys >= ye ? -1 : 1;
        int oz = zs >= ze ? -1 : 1;
        int nx = xs >= xe ? xs - xe : xe - xs;
        int ny = ys >= ye ? ys - ye : ye - ys;
        int nz = zs >= ze ? zs - ze : ze - zs;
        int limit = this.limit;
        int ll = 0;
        this.block_buffer.reset();
        this.fill_nx = nx;
        this.fill_ny = ny;
        this.fill_nz = nz;
        int z = zs;
        int z0 = 0;
        while (true) {
            if (z0 > nz) {
                this.skip();
                return;
            }
            if (zskip == 0 || z0 % (zskip + 1) == 0) {
                int y = ys;
                for (int y0 = 0; y0 <= ny; y += oy, ++y0) {
                    if (yskip != 0 && y0 % (yskip + 1) != 0) continue;
                    int x = xs;
                    block7: for (int x0 = 0; x0 <= nx; x += ox, ++x0) {
                        if (hollow) {
                            switch (this.axis) {
                                case X: {
                                    if (y == ys || y == ye || z == zs || z == ze) break;
                                    continue block7;
                                }
                                case Y: {
                                    if (x == xs || x == xe || z == zs || z == ze) break;
                                    continue block7;
                                }
                                case Z: {
                                    if (x != xs && x != xe && y != ys && y != ye) continue block7;
                                }
                            }
                        }
                        if (xskip != 0 && x0 % (xskip + 1) != 0 || ll >= limit) continue;
                        if (ll >= WandsConfig.max_limit) continue;
                        this.add_to_buffer(x, y, z);
                        ++ll;
                    }
                }
            }
            z += oz;
            ++z0;
        }
    }

    void hurt_main_hand(ItemStack stack) {
        if (!this.unbreakable) {
            stack.hurtAndBreak(1, (LivingEntity)this.player, EquipmentSlot.MAINHAND);
        }
    }

    void hurt_tool(ItemStack stack, int tool_slot) {
        if (!this.unbreakable) {
            stack.hurtAndBreak(1, (LivingEntity)this.player, EquipmentSlot.OFFHAND);
        }
    }

    boolean place_block(BlockPos block_pos, BlockState state) {
        boolean placed = false;
        if (!WandsExpectPlatform.claimCanInteract((ServerLevel)this.level, block_pos, this.player)) {
            this.player.displayClientMessage((Component)Compat.literal("can't use wand on claimed chunk"), false);
            return false;
        }
        if (state == null) {
            return false;
        }
        Block blk = state.getBlock();
        if (WandsConfig.denied.contains(blk)) {
            return false;
        }
        BlockState st = this.level.getBlockState(block_pos);
        Block actual_blk = st.getBlock();
        if (WandsConfig.denied.contains(actual_blk)) {
            return false;
        }
        if (this.destroy && this.mode != WandProps.Mode.VEIN && this.has_offhand && this.offhand_block != null && this.offhand_state != st) {
            return false;
        }
        int wand_durability = this.wand_stack.getMaxDamage() - this.wand_stack.getDamageValue();
        int tool_durability = -1;
        if (this.use && this.has_shear && state.is(Blocks.PUMPKIN)) {
            BlockState carved_pumpkin = (BlockState)Blocks.CARVED_PUMPKIN.defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)this.player.getDirection().getOpposite());
            this.level.setBlockAndUpdate(block_pos, carved_pumpkin);
            if (!this.creative) {
                ItemStack pumpkin_seeds = Items.PUMPKIN_SEEDS.getDefaultInstance();
                pumpkin_seeds.setCount(4);
                this.drop(block_pos, state, null, pumpkin_seeds);
                this.hurt_main_hand(this.wand_stack);
                this.consume_xp();
            }
            return true;
        }
        if (this.use && this.has_water_potion && state.is(BlockTags.CONVERTABLE_TO_MUD)) {
            this.level.setBlockAndUpdate(block_pos, Blocks.MUD.defaultBlockState());
            this.send_sound = Sounds.SPLASH.ordinal();
            if (!this.creative) {
                this.hurt_main_hand(this.wand_stack);
                this.consume_xp();
            }
            return true;
        }
        boolean _can_destroy = this.creative;
        this.no_tool = false;
        if (!this.creative) {
            boolean will_break;
            if (this.destroy || this.replace || this.use) {
                _can_destroy = this.can_destroy(st, true);
                if (this.digger_item != null) {
                    tool_durability = this.digger_item.getMaxDamage() - this.digger_item.getDamageValue();
                } else {
                    this.no_tool = true;
                    return false;
                }
            }
            boolean bl = will_break = wand_durability == 1 || tool_durability == 1;
            if (will_break) {
                this.damaged_tool = true;
                return false;
            }
        } else if (this.creative && this.use) {
            this.can_destroy(st, true);
            if (this.digger_item == null) {
                this.no_tool = true;
                return false;
            }
        }
        this.p1_state = state;
        if (!this.destroy) {
            if (this.offhand != null) {
                blk = Block.byItem((Item)this.offhand.getItem());
            }
            if (!this.replace && !state.canSurvive((LevelReader)this.level, block_pos)) {
                return false;
            }
            if (blk instanceof SnowLayerBlock) {
                int layers;
                BlockState below = this.level.getBlockState(block_pos.below());
                if (below.getBlock() instanceof SnowLayerBlock && (layers = ((Integer)below.getValue((Property)SnowLayerBlock.LAYERS)).intValue()) < 8) {
                    block_pos = block_pos.below();
                    state = (BlockState)state.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(layers + 1));
                }
            } else if (blk instanceof CrossCollisionBlock || blk instanceof DoorBlock) {
                BlockHitResult hit_res = new BlockHitResult(new Vec3((double)block_pos.getX() + 0.5, (double)block_pos.getY() + 1.0, (double)block_pos.getZ() + 0.5), this.side, block_pos, true);
                UseOnContext uctx = new UseOnContext(this.player, InteractionHand.OFF_HAND, hit_res);
                BlockPlaceContext pctx = new BlockPlaceContext(uctx);
                state = state.getBlock().getStateForPlacement(pctx);
            }
        }
        if (this.use && this.digger_item != null && (this.has_hoe || this.has_shovel || this.has_axe || this.has_shear)) {
            BlockHitResult hit_res = new BlockHitResult(new Vec3((double)block_pos.getX() + 0.5, (double)block_pos.getY() + 1.0, (double)block_pos.getZ() + 0.5), Direction.UP, block_pos, true);
            UseOnContext ctx = new UseOnContext(this.player, InteractionHand.OFF_HAND, hit_res);
            if (this.digger_item.useOn(ctx) != InteractionResult.PASS) {
                if (!this.creative) {
                    this.hurt_main_hand(this.wand_stack);
                    this.hurt_tool(this.digger_item, this.digger_item_slot);
                    this.consume_xp();
                }
            } else {
                return false;
            }
            return true;
        }
        if (this.creative) {
            if (this.destroy) {
                if (this.destroyBlock(block_pos, false)) {
                    if (this.undo_buffer != null) {
                        this.undo_buffer.put(block_pos, this.level.getBlockState(block_pos), this.destroy);
                    }
                    return true;
                }
            } else if (!this.use && (state = this.state_for_placement(state, block_pos)) != null && state.canSurvive((LevelReader)this.level, block_pos) && this.level.setBlockAndUpdate(block_pos, state)) {
                blk.setPlacedBy(this.level, block_pos, state, (LivingEntity)this.player, blk.asItem().getDefaultInstance());
                if (this.undo_buffer != null) {
                    this.undo_buffer.put(block_pos, state, this.destroy);
                }
                return true;
            }
        } else {
            float xp = WandUtils.calc_xp(this.player.experienceLevel, this.player.experienceProgress);
            float dec = 0.0f;
            float BLOCKS_PER_XP = WandsMod.config.blocks_per_xp;
            if (BLOCKS_PER_XP != 0.0f) {
                dec = 1.0f / BLOCKS_PER_XP;
            }
            if (BLOCKS_PER_XP == 0.0f || xp - dec >= 0.0f) {
                if (WandsMod.config.destroy_in_survival_drop && (this.destroy || this.replace) && _can_destroy) {
                    placed = this.destroyBlock(block_pos, true);
                }
                if ((!this.destroy || this.replace && placed) && !this.use && state != null && state.canSurvive((LevelReader)this.level, block_pos) && this.level.setBlockAndUpdate(block_pos, state)) {
                    blk.setPlacedBy(this.level, block_pos, state, (LivingEntity)this.player, blk.asItem().getDefaultInstance());
                    placed = true;
                }
                if (this.replace && !placed) {
                    if (this.digger_item.getItem() == Items.AIR) {
                        this.player.displayClientMessage((Component)Compat.literal("incorrect tool"), false);
                    }
                    this.stop = true;
                }
            } else {
                if (BLOCKS_PER_XP != 0.0f && xp - dec < 0.0f) {
                    this.player.displayClientMessage((Component)Compat.literal("not enough xp"), false);
                    this.stop = true;
                }
                if (wand_durability == 1) {
                    this.player.displayClientMessage((Component)Compat.literal("wand damaged"), false);
                    if (!WandsMod.config.allow_wand_to_break || this.digger_item == null || this.digger_item.getItem() != Items.AIR) {
                        this.stop = true;
                    }
                }
            }
            if (placed) {
                if ((this.destroy || this.replace) && this.digger_item != null) {
                    this.hurt_tool(this.digger_item, this.digger_item_slot);
                }
                if (!this.unbreakable) {
                    this.hurt_main_hand(this.wand_stack);
                }
                this.consume_xp();
            }
        }
        return placed;
    }

    public boolean destroyBlock(BlockPos blockPos, boolean bl) {
        BlockState blockState = this.level.getBlockState(blockPos);
        if (blockState.isAir()) {
            return false;
        }
        FluidState fluidState = this.level.getFluidState(blockPos);
        if (!(blockState.getBlock() instanceof BaseFireBlock)) {
            // empty if block
        }
        if (bl) {
            BlockEntity blockEntity;
            BlockEntity blockEntity2 = blockEntity = blockState.hasBlockEntity() ? this.level.getBlockEntity(blockPos) : null;
            if (this.mine_to_inventory) {
                if (this.level instanceof ServerLevel && !this.drop(blockPos, blockState, blockEntity, null)) {
                    return false;
                }
            } else {
                blockState.getBlock().playerDestroy(this.level, this.player, this.pos, blockState, blockEntity, this.digger_item);
            }
        }
        this.player.awardStat(Stats.BLOCK_MINED.get((Object)blockState.getBlock()));
        this.player.causeFoodExhaustion(0.005f);
        boolean bl2 = this.level.setBlock(blockPos, fluidState.createLegacyBlock(), 3, 512);
        if (bl2) {
            // empty if block
        }
        return bl2;
    }

    boolean drop(BlockPos blockPos, BlockState blockState, BlockEntity blockEntity, ItemStack drop_item) {
        DropExperienceBlock dblock;
        int xp;
        BlockPos drop_pos = this.drop_on_player ? this.player.getOnPos().above() : blockPos;
        if (drop_item != null) {
            if (!this.place_into(drop_item) && !this.stop) {
                Block.popResource((Level)this.level, (BlockPos)drop_pos, (ItemStack)drop_item);
            }
        } else {
            Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)this.level), (BlockPos)blockPos, (BlockEntity)blockEntity, (Entity)this.player, (ItemStack)this.digger_item).forEach(itemStackx -> {
                if (!this.place_into((ItemStack)itemStackx) && !this.stop) {
                    Block.popResource((Level)this.level, (BlockPos)drop_pos, (ItemStack)itemStackx);
                }
            });
        }
        if (!this.stop && this.digger_item != null && blockState.getBlock() instanceof DropExperienceBlock && !Compat.has_silktouch(this.digger_item, this.level) && (xp = ((DropExperienceBlockAccessor)(dblock = (DropExperienceBlock)blockState.getBlock())).getXpRange().sample(this.level.random)) > 0 && ((ServerLevel)this.level).getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            ExperienceOrb.award((ServerLevel)((ServerLevel)this.level), (Vec3)Vec3.atCenterOf((Vec3i)drop_pos), (int)xp);
        }
        if (this.stop) {
            if (!this.preview) {
                this.player.displayClientMessage((Component)Compat.literal("inventory full"), false);
            }
            return false;
        }
        return true;
    }

    boolean place_into(ItemStack item_to_place) {
        ItemStack oh = this.player.getOffhandItem();
        if (!oh.isEmpty()) {
            if (WandUtils.is_shulker(oh)) {
                return this.place_into_shulker(oh, item_to_place, false);
            }
            if (WandUtils.is_magicbag(oh)) {
                return this.place_into_bag(oh, item_to_place);
            }
        }
        for (int pi = 0; pi < this.inv_aux_last; ++pi) {
            ItemStack stack = this.player_inv.getItem(this.inv_aux[pi]);
            if (WandUtils.is_shulker(stack) && this.place_into_shulker(stack, item_to_place, true)) {
                return true;
            }
            if (!WandUtils.is_magicbag(stack) || !this.place_into_bag(stack, item_to_place)) continue;
            return true;
        }
        return false;
    }

    boolean place_into_bag(ItemStack bag, ItemStack item_to_place) {
        ItemStack mb_item = MagicBagItem.getItem(bag, (HolderLookup.Provider)this.level.registryAccess());
        int total = MagicBagItem.getTotal(bag);
        if (mb_item.isEmpty() && total == 0) {
            MagicBagItem.setItem(bag, item_to_place, (HolderLookup.Provider)this.level.registryAccess());
            mb_item = item_to_place;
        }
        if (mb_item.getItem() == item_to_place.getItem() && MagicBagItem.inc(bag, item_to_place.getCount())) {
            this.blocks_sent_to_inv += item_to_place.getCount();
            return true;
        }
        return false;
    }

    boolean place_into_shulker(ItemStack shulker, ItemStack item_to_place, boolean bag_only) {
        ItemContainerContents contents = (ItemContainerContents)shulker.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        for (ItemStack slot_item : contents.nonEmptyItems()) {
            ItemStack bag_with_same_item;
            if (!WandUtils.is_magicbag(slot_item) || (bag_with_same_item = MagicBagItem.getItem(slot_item, (HolderLookup.Provider)this.level.registryAccess())).getItem() != item_to_place.getItem()) continue;
            if (!this.place_into_bag(slot_item, item_to_place)) break;
            return true;
        }
        if (!bag_only) {
            Iterator it2 = contents.nonEmptyItems().iterator();
            int item_count = item_to_place.getCount();
            int slots = 0;
            while (it2.hasNext()) {
                ++slots;
                ItemStack slot_item = (ItemStack)it2.next();
                if (slot_item == null) continue;
                if (Compat.is_same(item_to_place, slot_item)) {
                    int total = item_count + slot_item.getCount();
                    if (total <= slot_item.getMaxStackSize()) {
                        slot_item.setCount(total);
                        this.blocks_sent_to_inv += item_count;
                        return true;
                    }
                    this.blocks_sent_to_inv += slot_item.getMaxStackSize() - slot_item.getCount();
                    slot_item.setCount(slot_item.getMaxStackSize());
                    item_count = total - slot_item.getMaxStackSize();
                    continue;
                }
                if (!WandUtils.is_magicbag(slot_item) || !this.place_into_bag(slot_item, item_to_place)) continue;
                return true;
            }
            item_to_place.setCount(item_count);
            if (item_count > 0) {
                ArrayList list;
                if (slots >= 0 && slots < 27 && (list = new ArrayList(contents.stream().toList())).size() < 27) {
                    list.add(item_to_place);
                    this.blocks_sent_to_inv += item_count;
                    shulker.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(list));
                    return true;
                }
                if (this.stop_on_full_inventory) {
                    this.stop = true;
                }
            }
        }
        return false;
    }

    public void update_inv_aux() {
        this.inv_aux_last = 0;
        for (int s = 0; s < 36; ++s) {
            ItemStack stack = this.player_inv.getItem(s);
            if (WandUtils.is_shulker(stack)) {
                this.inv_aux[this.inv_aux_last] = s;
                ++this.inv_aux_last;
                continue;
            }
            if (!WandUtils.is_magicbag(stack)) continue;
            this.inv_aux[this.inv_aux_last] = s;
            ++this.inv_aux_last;
        }
    }

    public boolean add_to_buffer(int x, int y, int z) {
        if (!this.level.isOutsideBuildHeight(y) && this.block_buffer.get_length() < this.limit) {
            BlockState st = this.level.getBlockState((BlockPos)this.tmp_pos.set(x, y, z));
            if (this.destroy || this.replace || this.use ? !st.isAir() || this.mode == WandProps.Mode.AREA : this.can_place(st, (BlockPos)this.tmp_pos)) {
                return this.block_buffer.add(x, y, z, this);
            }
        } else {
            this.limit_reached = true;
        }
        return false;
    }

    void consume_xp() {
        float BLOCKS_PER_XP = WandsMod.config.blocks_per_xp;
        if (BLOCKS_PER_XP != 0.0f) {
            float diff = WandUtils.calc_xp_to_next_level(this.player.experienceLevel);
            float prog = this.player.experienceProgress;
            if (diff > 0.0f && BLOCKS_PER_XP != 0.0f) {
                float a = 1.0f / diff / BLOCKS_PER_XP;
                if (prog - a > 0.0f) {
                    prog -= a;
                } else {
                    prog = prog > 0.0f ? 1.0f + (a - prog) : 1.0f;
                    if (this.player.experienceLevel > 0) {
                        --this.player.experienceLevel;
                        a = 1.0f / diff / BLOCKS_PER_XP;
                        if (prog - a > 0.0f) {
                            prog -= a;
                        }
                    }
                }
                this.player.experienceProgress = prog;
            }
        }
    }

    public void update_tools() {
        this.digger_item_slot = -1;
        this.n_tools = 0;
        int[] tools_slots = this.player_data.getIntArray("Tools");
        for (int t = 0; t < tools_slots.length; ++t) {
            ItemStack tool_item = this.player.getInventory().getItem(tools_slots[t]);
            if (tool_item.isEmpty()) continue;
            this.tools[this.n_tools] = tool_item;
            ++this.n_tools;
            Item item = tool_item.getItem();
            this.has_hoe = this.has_hoe || item instanceof HoeItem;
            this.has_shovel = this.has_shovel || item instanceof ShovelItem;
            this.has_axe = this.has_axe || item instanceof AxeItem;
            this.has_shear = this.has_shear || item instanceof ShearsItem;
        }
    }

    public boolean can_destroy(BlockState state, boolean check_speed) {
        this.digger_item = null;
        for (int i = 0; i < this.n_tools; ++i) {
            if (this.tools[i] == null) continue;
            int dmg = this.tools[i].getMaxDamage() - this.tools[i].getDamageValue();
            if (this.tools[i].isEmpty() || dmg <= 1 || !((this.destroy || this.replace) && this.can_dig(state, check_speed, this.tools[i])) && (!this.use || !(this.tools[i].getItem() instanceof HoeItem && WandUtils.is_tillable(state) || this.tools[i].getItem() instanceof AxeItem && WandUtils.is_strippable(state) || this.tools[i].getItem() instanceof ShovelItem && WandUtils.is_flattenable(state)) && (!(this.tools[i].getItem() instanceof ShearsItem) || !this.can_shear(state)))) continue;
            if (this.digger_item == null) {
                this.digger_item = this.tools[i];
                this.digger_item_slot = i;
            }
            return true;
        }
        return false;
    }

    boolean can_dig(BlockState state, boolean check_speed, ItemStack digger) {
        boolean is_glass = state.getBlock() instanceof TransparentBlock;
        boolean is_snow_layer = false;
        boolean can_shear = false;
        Block blk = state.getBlock();
        if (blk instanceof SnowLayerBlock) {
            is_snow_layer = (Integer)state.getValue((Property)SnowLayerBlock.LAYERS) == 1;
        }
        Item item_digger = digger.getItem();
        if (digger != null && !digger.isEmpty() && (item_digger instanceof DiggerItem || item_digger instanceof ShearsItem)) {
            boolean is_allowed = false;
            boolean minable = false;
            if (item_digger instanceof ShearsItem) {
                can_shear = this.can_shear(state);
                is_allowed = is_allowed || WandsConfig.shears_allowed.contains(blk);
            } else if (item_digger instanceof PickaxeItem) {
                is_allowed = is_allowed || WandsConfig.pickaxe_allowed.contains(blk);
            } else if (item_digger instanceof AxeItem) {
                is_allowed = is_allowed || WandsConfig.axe_allowed.contains(blk);
            } else if (item_digger instanceof ShovelItem) {
                is_allowed = is_allowed || WandsConfig.shovel_allowed.contains(blk);
            } else if (item_digger instanceof HoeItem) {
                boolean bl = is_allowed = is_allowed || WandsConfig.hoe_allowed.contains(blk);
            }
            if (check_speed) {
                float destroy_speed = item_digger.getDestroySpeed(digger, state);
                boolean correct_tool = false;
                if (!digger.isEmpty()) {
                    Tool tool = (Tool)digger.get(DataComponents.TOOL);
                    correct_tool = tool != null && tool.isCorrectForDrops(state);
                }
                return this.creative || destroy_speed > 1.0f && correct_tool || is_glass || is_snow_layer || is_allowed || can_shear;
            }
            return true;
        }
        return false;
    }

    public boolean replace_fluid(BlockState state) {
        if (this.removes_water && this.removes_lava) {
            return state.getFluidState().is(FluidTags.WATER) || state.getFluidState().is(FluidTags.LAVA);
        }
        if (this.removes_water) {
            return state.getFluidState().is(FluidTags.WATER);
        }
        return false;
    }

    public boolean can_place(BlockState state, BlockPos p) {
        if (this.offhand_state != null && WandUtils.is_plant(this.offhand_state)) {
            return (state.isAir() || this.replace_fluid(state)) && this.offhand_state.canSurvive((LevelReader)this.level, p);
        }
        return state.isAir() || this.replace_fluid(state) || WandUtils.is_plant(state) || state.getBlock() instanceof SnowLayerBlock || this.has_empty_bucket && state.getFluidState().is(FluidTags.WATER) || this.has_empty_bucket && state.getFluidState().is(FluidTags.LAVA);
    }

    public boolean can_shear(BlockState state) {
        return state.is(BlockTags.LEAVES) || state.is(Blocks.COBWEB) || state.is(Blocks.SHORT_GRASS) || state.is(Blocks.FERN) || state.is(Blocks.DEAD_BUSH) || state.is(Blocks.VINE) || state.is(Blocks.TRIPWIRE) || state.is(Blocks.PUMPKIN) || state.is(BlockTags.WOOL) || state.is(Blocks.HANGING_ROOTS);
    }

    void check_inventory() {
        if (!(this.creative && this.mode != WandProps.Mode.BLAST || this.destroy || this.use || this.has_water_bucket || this.mode == WandProps.Mode.COPY)) {
            ItemStack stack;
            for (int i = 0; i < 36; ++i) {
                stack = this.player_inv.getItem(i);
                if (stack.getItem() == Items.AIR) continue;
                if (WandUtils.is_shulker(stack)) {
                    for (Map.Entry<Item, BlockAccounting> pa : this.block_accounting.entrySet()) {
                        pa.getValue().in_player += WandUtils.count_in_shulker(stack, pa.getKey(), (HolderLookup.Provider)this.level.registryAccess());
                    }
                    continue;
                }
                if (WandUtils.is_magicbag(stack)) {
                    BlockAccounting ba;
                    int total = MagicBagItem.getTotal(stack);
                    ItemStack stack2 = MagicBagItem.getItem(stack, (HolderLookup.Provider)this.level.registryAccess());
                    if (stack2.isEmpty() || total <= 0 || (ba = this.block_accounting.get(stack2.getItem())) == null) continue;
                    ba.in_player += total;
                    continue;
                }
                if (stack.get(DataComponents.CUSTOM_DATA) != null) continue;
                for (Map.Entry<Item, BlockAccounting> pa : this.block_accounting.entrySet()) {
                    Item item = pa.getKey();
                    if (item == null || stack.isEmpty() || item != stack.getItem()) continue;
                    pa.getValue().in_player += stack.getCount();
                }
            }
            ItemStack oh = this.player.getOffhandItem();
            if (oh != null && !oh.isEmpty()) {
                BlockAccounting ba;
                if (oh.getItem() instanceof MagicBagItem) {
                    BlockAccounting ba2;
                    stack = MagicBagItem.getItem(oh, (HolderLookup.Provider)this.level.registryAccess());
                    int total = MagicBagItem.getTotal(oh);
                    if (!stack.isEmpty() && total > 0 && (ba2 = this.block_accounting.get(stack.getItem())) != null) {
                        ba2.in_player += total;
                    }
                } else if (this.offhand != null && (ba = this.block_accounting.get(this.offhand.getItem())) != null) {
                    ba.in_player += this.offhand.getCount();
                }
            }
            for (Map.Entry<Item, BlockAccounting> pa : this.block_accounting.entrySet()) {
                if (pa.getValue().in_player >= pa.getValue().needed) continue;
                MutableComponent name = Compat.translatable(pa.getKey().getDescriptionId());
                MutableComponent mc = Compat.literal("Not enough ").withStyle(ChatFormatting.RED).append((Component)name);
                mc.append(". " + pa.getValue().in_player);
                mc.append("/");
                mc.append("" + pa.getValue().needed);
                this.player.displayClientMessage((Component)mc, false);
            }
        }
    }

    void remove_from_inventory(int placed) {
        if (!this.creative && (!this.destroy && placed > 0 || this.mode == WandProps.Mode.BLAST)) {
            BlockAccounting pa;
            int i;
            BlockAccounting pa2;
            BlockAccounting pa3;
            ItemStack bag_it;
            ItemStack stack_item2;
            for (int pi = 0; pi < 36; ++pi) {
                ItemStack stack = this.player_inv.getItem(pi);
                if (stack.getItem() == Items.AIR || !WandUtils.is_shulker(stack)) continue;
                for (ItemStack stack_item2 : ((ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).nonEmptyItems()) {
                    if (stack_item2.isEmpty()) continue;
                    if (WandUtils.is_magicbag(stack_item2)) {
                        bag_it = MagicBagItem.getItem(stack_item2, (HolderLookup.Provider)this.level.registryAccess());
                        pa3 = this.block_accounting.get(bag_it.getItem());
                        this.consume_item(pa3, stack_item2);
                        continue;
                    }
                    pa2 = this.block_accounting.get(stack_item2.getItem());
                    this.consume_item(pa2, stack_item2);
                }
            }
            ItemStack oh = this.player.getOffhandItem();
            if (!oh.isEmpty() && oh.getItem() instanceof MagicBagItem) {
                stack_item2 = MagicBagItem.getItem(oh, (HolderLookup.Provider)this.level.registryAccess());
                BlockAccounting pa4 = this.block_accounting.get(stack_item2.getItem());
                this.consume_item(pa4, oh);
            }
            for (i = 0; i < 36; ++i) {
                stack_item2 = this.player_inv.getItem(i);
                if (!WandUtils.is_magicbag(stack_item2)) continue;
                bag_it = MagicBagItem.getItem(stack_item2, (HolderLookup.Provider)this.level.registryAccess());
                pa3 = this.block_accounting.get(bag_it.getItem());
                this.consume_item(pa3, stack_item2);
            }
            for (i = 0; i < 36; ++i) {
                ItemStack rep;
                stack_item2 = this.player_inv.getItem(i);
                if (stack_item2.getItem() == Items.AIR || WandUtils.is_shulker(stack_item2) || WandUtils.is_magicbag(stack_item2) || stack_item2.get(DataComponents.CUSTOM_DATA) != null || (rep = this.consume_item(pa2 = this.block_accounting.get(stack_item2.getItem()), stack_item2)) == null || rep.isEmpty()) continue;
                this.player_inv.setItem(i, rep);
            }
            if (this.offhand != null && !this.offhand.isEmpty() && !WandUtils.is_magicbag(this.offhand) && (pa = this.block_accounting.get(this.offhand.getItem())) != null) {
                this.consume_item(pa, this.offhand);
            }
        }
    }

    boolean check_advancement(ServerAdvancementManager server_advancements, PlayerAdvancements player_advancements, String a) {
        ResourceLocation res = ResourceLocation.tryParse((String)a);
        if (res == null) {
            WandsMod.log("bad advancement: " + String.valueOf(res), this.prnt);
            return false;
        }
        AdvancementHolder adv = server_advancements.get(res);
        if (adv == null) {
            WandsMod.log("bad advancement: " + String.valueOf(res), this.prnt);
            return false;
        }
        AdvancementProgress prog = player_advancements.getOrStartProgress(adv);
        return prog.isDone();
    }

    void check_advancements() {
        if (!this.creative && WandsMod.config.check_advancements && !this.level.isClientSide()) {
            PlayerAdvancements advs = ((ServerPlayer)this.player).getAdvancements();
            MinecraftServer server = this.player.getServer();
            if (server == null) {
                return;
            }
            ServerAdvancementManager advancements = server.getAdvancements();
            if (advancements == null) {
                return;
            }
            if (!Objects.equals(WandsMod.config.advancement_allow_stone_wand, "") && ((WandItem)this.wand_stack.getItem()).tier == 0 && !this.check_advancement(advancements, advs, WandsMod.config.advancement_allow_stone_wand)) {
                return;
            }
            if (!Objects.equals(WandsMod.config.advancement_allow_iron_wand, "") && ((WandItem)this.wand_stack.getItem()).tier == 1 && !this.check_advancement(advancements, advs, WandsMod.config.advancement_allow_iron_wand)) {
                return;
            }
            if (!Objects.equals(WandsMod.config.advancement_allow_diamond_wand, "") && ((WandItem)this.wand_stack.getItem()).tier == 2 && !this.check_advancement(advancements, advs, WandsMod.config.advancement_allow_diamond_wand)) {
                return;
            }
            if (!Objects.equals(WandsMod.config.advancement_allow_netherite_wand, "") && ((WandItem)this.wand_stack.getItem()).tier == 3 && !this.check_advancement(advancements, advs, WandsMod.config.advancement_allow_netherite_wand)) {
                return;
            }
        }
    }

    public BlockPos get_pos_from_air(Vec3 hit) {
        if (this.player == null) {
            return new BlockPos((int)hit.x, (int)hit.y, (int)hit.z);
        }
        Direction dir = this.player.getDirection();
        int offx = 0;
        int offy = 0;
        int offz = 0;
        switch (dir) {
            case NORTH: 
            case SOUTH: {
                if (!(hit.x < 0.0)) break;
                offx = -1;
                break;
            }
            case EAST: 
            case WEST: {
                if (!(hit.z < 0.0)) break;
                offz = -1;
            }
        }
        if (hit.y < 0.0) {
            offy = -1;
        }
        return new BlockPos((int)hit.x + offx, (int)hit.y + offy, (int)hit.z + offz);
    }

    public void copy() {
        if (this.mode == WandProps.Mode.COPY) {
            int m = this.mode.ordinal();
            this.modes[m].place_in_buffer(this);
        }
    }

    public static enum Sounds {
        SPLASH{

            @Override
            public SoundEvent get_sound() {
                return SoundEvents.GENERIC_SPLASH;
            }
        };


        public abstract SoundEvent get_sound();
    }
}

