/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.wand;

import java.util.Map;
import java.util.Vector;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nicguzzo.wands.items.PaletteItem;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.wand.BlockAccounting;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandProps;

public class Palette {
    public ItemStack item = null;
    public boolean has_palette = false;
    public int slot = 0;
    public RandomSource random = RandomSource.create();
    public volatile long seed = System.currentTimeMillis();
    public Vector<PaletteSlot> palette_slots = new Vector();

    void update_palette(Map<Item, BlockAccounting> block_accounting, Level level) {
        this.slot = 0;
        if (this.item != null && this.item.getItem() instanceof PaletteItem) {
            this.palette_slots.clear();
            CompoundTag tag = Compat.getTags(this.item);
            ListTag palette_inv = tag.getList("Palette", 10);
            int s = palette_inv.size();
            for (int i = 0; i < s; ++i) {
                Block blk;
                CompoundTag stackTag = (CompoundTag)palette_inv.get(i);
                ItemStack stack = ItemStack.EMPTY;
                if (level != null) {
                    stack = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)stackTag.getCompound("Block")).orElse(ItemStack.EMPTY);
                }
                if (stack.isEmpty() || (blk = Block.byItem((Item)stack.getItem())) == Blocks.AIR) continue;
                PaletteSlot psl = new PaletteSlot(i, blk.defaultBlockState(), stack);
                if (block_accounting.get(stack.getItem()) == null) {
                    block_accounting.put(stack.getItem(), new BlockAccounting());
                }
                this.palette_slots.add(psl);
            }
        }
    }

    public BlockState get_state(Wand wand) {
        BlockState st = wand.block_state;
        if (!wand.preview) {
            // empty if block
        }
        if (this.palette_slots.size() > 0) {
            PaletteItem.PaletteMode palette_mode = PaletteItem.getMode(this.item);
            int bound = this.palette_slots.size();
            if (palette_mode == PaletteItem.PaletteMode.RANDOM) {
                this.slot = this.random.nextInt(bound);
            }
            PaletteSlot ps = this.palette_slots.get(this.slot);
            if (!(palette_mode != PaletteItem.PaletteMode.ROUND_ROBIN || wand.mode == WandProps.Mode.DIRECTION && wand.level.isClientSide())) {
                this.slot = (this.slot + 1) % bound;
            }
            st = ps.state;
            Block blk = st.getBlock();
            if (palette_mode == PaletteItem.PaletteMode.RANDOM && blk instanceof SnowLayerBlock) {
                int sn = this.random.nextInt(7);
                st = (BlockState)st.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(sn + 1));
            }
            st = wand.state_for_placement(st, null);
            if (PaletteItem.getRotate(this.item)) {
                st = ps.state.getBlock().defaultBlockState().rotate(Rotation.getRandom((RandomSource)this.random));
            }
        }
        return st;
    }

    public boolean state_in_slot(BlockState bs) {
        boolean cond = false;
        if (this.has_palette) {
            for (PaletteSlot slot : this.palette_slots) {
                if (!bs.equals(slot.state)) continue;
                cond = true;
                break;
            }
        }
        return cond;
    }

    public static class PaletteSlot {
        public ItemStack stack;
        public BlockState state;
        public int slot;

        PaletteSlot(int s, BlockState b, ItemStack stk) {
            this.slot = s;
            this.state = b;
            this.stack = stk;
        }
    }
}

