/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.networking;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.nicguzzo.wands.utils.Compat;
import org.jetbrains.annotations.NotNull;

public class Networking {
    public static ResourceLocation KB_PACKET = Compat.create_resource("key_packet");
    public static ResourceLocation SND_PACKET = Compat.create_resource("sound_packet");
    public static ResourceLocation TOAST_PACKET = Compat.create_resource("toast_packet");
    public static ResourceLocation PALETTE_PACKET = Compat.create_resource("palette_packet");
    public static ResourceLocation STATE_PACKET = Compat.create_resource("state_packet");
    public static ResourceLocation WAND_PACKET = Compat.create_resource("wand_packet");
    public static ResourceLocation PLAYER_DATA_PACKET = Compat.create_resource("player_data_packet");
    public static ResourceLocation POS_PACKET = Compat.create_resource("pos_packet");
    public static ResourceLocation CONF_PACKET = Compat.create_resource("conf_packet");
    public static ResourceLocation GLOBAL_SETTINGS_PACKET = Compat.create_resource("global_settings_packet");

    public record GlobalSettingsPacket(boolean drop_pos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<GlobalSettingsPacket> TYPE = new CustomPacketPayload.Type(GLOBAL_SETTINGS_PACKET);
        public static final StreamCodec<ByteBuf, GlobalSettingsPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, GlobalSettingsPacket::drop_pos, GlobalSettingsPacket::new);

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record ConfPacket(float blocks_per_xp, boolean destroy_in_survival_drop, boolean survival_unenchanted_drops, boolean allow_wand_to_break, boolean allow_offhand_to_break, boolean mend_tools) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ConfPacket> TYPE = new CustomPacketPayload.Type(CONF_PACKET);
        public static final StreamCodec<RegistryFriendlyByteBuf, ConfPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, ConfPacket::blocks_per_xp, (StreamCodec)ByteBufCodecs.BOOL, ConfPacket::destroy_in_survival_drop, (StreamCodec)ByteBufCodecs.BOOL, ConfPacket::survival_unenchanted_drops, (StreamCodec)ByteBufCodecs.BOOL, ConfPacket::allow_wand_to_break, (StreamCodec)ByteBufCodecs.BOOL, ConfPacket::allow_offhand_to_break, (StreamCodec)ByteBufCodecs.BOOL, ConfPacket::mend_tools, ConfPacket::new);

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record PosPacket(int dir, int has_p1_p2, BlockPos p1, BlockPos p2, Vec3d hit, long seed) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PosPacket> TYPE = new CustomPacketPayload.Type(POS_PACKET);
        public static final StreamCodec<RegistryFriendlyByteBuf, PosPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, PosPacket::dir, (StreamCodec)ByteBufCodecs.VAR_INT, PosPacket::has_p1_p2, (StreamCodec)BlockPos.STREAM_CODEC, PosPacket::p1, (StreamCodec)BlockPos.STREAM_CODEC, PosPacket::p2, Vec3d.STREAM_CODEC, PosPacket::hit, (StreamCodec)ByteBufCodecs.VAR_LONG, PosPacket::seed, PosPacket::new);

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record StatePacket(int mode, int slot, boolean xp, int levels, float prog) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<StatePacket> TYPE = new CustomPacketPayload.Type(STATE_PACKET);
        public static final StreamCodec<ByteBuf, StatePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, StatePacket::mode, (StreamCodec)ByteBufCodecs.VAR_INT, StatePacket::slot, (StreamCodec)ByteBufCodecs.BOOL, StatePacket::xp, (StreamCodec)ByteBufCodecs.VAR_INT, StatePacket::levels, (StreamCodec)ByteBufCodecs.FLOAT, StatePacket::prog, StatePacket::new);

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record PlayerDataPacket(CompoundTag tag) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerDataPacket> TYPE = new CustomPacketPayload.Type(PLAYER_DATA_PACKET);
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerDataPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)CompoundTag.CODEC), PlayerDataPacket::tag, PlayerDataPacket::new);

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record WandPacket(ItemStack item_stack) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<WandPacket> TYPE = new CustomPacketPayload.Type(WAND_PACKET);
        public static final StreamCodec<RegistryFriendlyByteBuf, WandPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, WandPacket::item_stack, WandPacket::new);

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record PalettePacket(boolean mode, boolean rotate) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PalettePacket> TYPE = new CustomPacketPayload.Type(PALETTE_PACKET);
        public static final StreamCodec<ByteBuf, PalettePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, PalettePacket::mode, (StreamCodec)ByteBufCodecs.BOOL, PalettePacket::rotate, PalettePacket::new);

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record ToastPacket(boolean no_tool, boolean damaged_tool) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ToastPacket> TYPE = new CustomPacketPayload.Type(TOAST_PACKET);
        public static final StreamCodec<RegistryFriendlyByteBuf, ToastPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ToastPacket::no_tool, (StreamCodec)ByteBufCodecs.BOOL, ToastPacket::damaged_tool, ToastPacket::new);

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record SndPacket(BlockPos pos, boolean destroy, ItemStack item_stack, int i_sound) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SndPacket> TYPE = new CustomPacketPayload.Type(SND_PACKET);
        public static final StreamCodec<RegistryFriendlyByteBuf, SndPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SndPacket::pos, (StreamCodec)ByteBufCodecs.BOOL, SndPacket::destroy, (StreamCodec)ItemStack.STREAM_CODEC, SndPacket::item_stack, (StreamCodec)ByteBufCodecs.VAR_INT, SndPacket::i_sound, SndPacket::new);

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record KbPacket(int key, boolean shift, boolean alt) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<KbPacket> TYPE = new CustomPacketPayload.Type(KB_PACKET);
        public static final StreamCodec<ByteBuf, KbPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, KbPacket::key, (StreamCodec)ByteBufCodecs.BOOL, KbPacket::shift, (StreamCodec)ByteBufCodecs.BOOL, KbPacket::alt, KbPacket::new);

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public static class Vec3d {
        public double x;
        public double y;
        public double z;
        public static final StreamCodec<ByteBuf, Vec3d> STREAM_CODEC = new StreamCodec<ByteBuf, Vec3d>(){

            @NotNull
            public Vec3d decode(ByteBuf byteBuf) {
                double x = byteBuf.readDouble();
                double y = byteBuf.readDouble();
                double z = byteBuf.readDouble();
                return new Vec3d(x, y, z);
            }

            public void encode(ByteBuf byteBuf, Vec3d v) {
                byteBuf.writeDouble(v.x);
                byteBuf.writeDouble(v.y);
                byteBuf.writeDouble(v.z);
            }
        };

        public Vec3d(double _x, double _y, double _z) {
            this.x = _x;
            this.y = _y;
            this.z = _z;
        }
    }
}

