/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.menues;

import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.nicguzzo.wands.WandsMod;
import net.nicguzzo.wands.items.PaletteItem;
import net.nicguzzo.wands.utils.Compat;

public class PaletteMenu
extends AbstractContainerMenu {
    public ItemStack palette;
    private final SimpleContainer inventory;
    public final Inventory playerInventory;

    public PaletteMenu(int syncId, Inventory playerInventory, FriendlyByteBuf packetByteBuf) {
        this(syncId, playerInventory, ItemStack.parse((HolderLookup.Provider)playerInventory.player.level().registryAccess(), (Tag)packetByteBuf.readNbt()).orElse(ItemStack.EMPTY));
    }

    public PaletteMenu(int syncId, Inventory playerInventory, ItemStack palette) {
        super((MenuType)WandsMod.PALETTE_CONTAINER.get(), syncId);
        this.palette = palette;
        this.playerInventory = playerInventory;
        this.inventory = PaletteItem.getInventory(palette, playerInventory.player.level());
        if (palette.getItem() instanceof PaletteItem) {
            int n;
            int o;
            for (o = 0; o < 3; ++o) {
                for (n = 0; n < 9; ++n) {
                    this.addSlot(new Slot((Container)this.inventory, n + o * 9, 8 + n * 18, 18 + o * 18));
                }
            }
            for (o = 0; o < 3; ++o) {
                for (n = 0; n < 9; ++n) {
                    this.addSlot(new Slot((Container)playerInventory, n + o * 9 + 9, 8 + n * 18, 84 + o * 18));
                }
            }
            for (o = 0; o < 9; ++o) {
                this.addSlot(new Slot((Container)playerInventory, o, 8 + o * 18, 142));
            }
        } else {
            Player player = playerInventory.player;
            this.removed(player);
        }
    }

    public void slotsChanged(Container inventory) {
        super.slotsChanged(inventory);
        this.broadcastChanges();
    }

    public void removed(Player player) {
        Inventory inventory = Compat.get_inventory(player);
        if (!inventory.getSelected().isEmpty()) {
            Compat.set_carried(player, this, ItemStack.EMPTY);
        }
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    boolean can_pickup(ItemStack itemStack) {
        Item item = itemStack.getItem();
        Block blk = Block.byItem((Item)item);
        return itemStack.isStackable() && blk != Blocks.AIR;
    }

    void insert(ItemStack itemStack) {
        for (int o = 0; o < 27; ++o) {
            Slot slot = (Slot)this.slots.get(o);
            if (!slot.getItem().isEmpty()) continue;
            slot.set(itemStack);
            slot.setChanged();
            break;
        }
    }

    public void clicked(int slotIndex, int button, ClickType actionType, Player player) {
        try {
            if (actionType != ClickType.QUICK_CRAFT && button == 1) {
                Compat.set_carried(player, this, ItemStack.EMPTY);
            }
            if (slotIndex >= 0 && slotIndex < 63) {
                Slot slot = (Slot)this.slots.get(slotIndex);
                if (actionType == ClickType.QUICK_CRAFT && slotIndex < 27) {
                    ItemStack itemStack = Compat.get_carried(player, this);
                    slot.set(itemStack);
                    PaletteItem.setInventory(this.palette, this.inventory, player.level());
                    return;
                }
                if (slot != null) {
                    ItemStack itemStack;
                    ItemStack itemStack2;
                    if (actionType == ClickType.CLONE && this.can_pickup(itemStack2 = (itemStack = slot.getItem()).copy())) {
                        itemStack2.setCount(1);
                        Compat.set_carried(player, this, itemStack2);
                    }
                    if (button == 1) {
                        if (slotIndex < 27 && actionType == ClickType.PICKUP && !(itemStack = slot.getItem()).isEmpty()) {
                            slot.set(ItemStack.EMPTY);
                            slot.setChanged();
                        }
                        PaletteItem.setInventory(this.palette, this.inventory, player.level());
                        return;
                    }
                    if (button == 0) {
                        if (slotIndex < 27) {
                            if (actionType == ClickType.PICKUP || actionType == ClickType.QUICK_CRAFT) {
                                itemStack = slot.getItem();
                                if (!itemStack.isEmpty()) {
                                    itemStack2 = itemStack.copy();
                                    if (this.can_pickup(itemStack2)) {
                                        itemStack2.setCount(1);
                                        Compat.set_carried(player, this, itemStack2);
                                    }
                                } else {
                                    itemStack = Compat.get_carried(player, this);
                                    if (!itemStack.isEmpty()) {
                                        slot.set(itemStack);
                                        Compat.set_carried(player, this, ItemStack.EMPTY);
                                    }
                                }
                                slot.setChanged();
                            }
                        } else if ((actionType == ClickType.PICKUP || actionType == ClickType.QUICK_MOVE) && this.can_pickup(itemStack2 = (itemStack = slot.getItem()).copy())) {
                            itemStack2.setCount(1);
                            if (actionType == ClickType.PICKUP) {
                                Compat.set_carried(player, this, itemStack2);
                            } else {
                                this.insert(itemStack2);
                            }
                        }
                    }
                }
            }
            PaletteItem.setInventory(this.palette, this.inventory, player.level());
        }
        catch (Exception var8) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)var8, (String)"Container click");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Click info");
            crashReportCategory.setDetail("Menu Type", () -> this.getType() != null ? BuiltInRegistries.MENU.getKey((Object)this.getType()).toString() : "<no type>");
            crashReportCategory.setDetail("Menu Class", () -> ((Object)((Object)this)).getClass().getCanonicalName());
            crashReportCategory.setDetail("Slot Count", (Object)this.slots.size());
            crashReportCategory.setDetail("Slot", (Object)slotIndex);
            crashReportCategory.setDetail("Button", (Object)button);
            crashReportCategory.setDetail("Type", (Object)actionType);
            throw new ReportedException(crashReport);
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }
}

