/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.items;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.nicguzzo.wands.utils.Compat;

public class PaletteItem
extends Item {
    public static Component mode_val_random = Compat.translatable("item.wands.random");
    public static Component mode_val_rr = Compat.translatable("item.wands.round_robin");

    public PaletteItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        CompoundTag tag = Compat.getTags(stack);
        ListTag inventory = tag.getList("Palette", 10);
        int s = inventory.size();
        for (int i = 0; i < s; ++i) {
            Optional is2;
            CompoundTag stackTag = (CompoundTag)inventory.get(i);
            ItemStack stack2 = ItemStack.EMPTY;
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null && tag.contains("Block") && (is2 = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)tag.getCompound("Block"))).isPresent()) {
                stack2 = (ItemStack)is2.get();
            }
            if (stack2.isEmpty()) continue;
            list.add((Component)Component.translatable((String)stack2.getItem().getDescriptionId()).withStyle(ChatFormatting.GREEN));
        }
        PaletteMode mode = PaletteItem.getMode(stack);
        MutableComponent mode_val = mode == PaletteMode.ROUND_ROBIN ? Compat.literal("mode: " + mode_val_rr.getString()) : Compat.literal("mode: " + mode_val_random.getString());
        list.add((Component)mode_val);
        list.add((Component)Compat.literal("rotate: " + (tag.getBoolean("rotate") ? "on" : "off")));
    }

    public static PaletteMode getMode(ItemStack stack) {
        CompoundTag tag;
        int mode;
        if (stack != null && !stack.isEmpty() && (mode = (tag = Compat.getTags(stack)).getInt("mode")) < PaletteMode.values().length) {
            return PaletteMode.values()[mode];
        }
        return PaletteMode.RANDOM;
    }

    public static boolean getRotate(ItemStack stack) {
        if (stack != null && !stack.isEmpty()) {
            CompoundTag tag = Compat.getTags(stack);
            return tag.getBoolean("rotate");
        }
        return false;
    }

    public static void toggleRotate(ItemStack stack) {
        if (stack != null && !stack.isEmpty()) {
            CompoundTag tag;
            boolean rotate = (tag = Compat.getTags(stack)).getBoolean("rotate");
            tag.putBoolean("rotate", !rotate);
        }
    }

    public static void nextMode(ItemStack stack) {
        if (stack != null && !stack.isEmpty()) {
            CompoundTag tag = Compat.getTags(stack);
            int mode = (tag.getInt("mode") + 1) % 2;
            tag.putInt("mode", mode);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand interactionHand) {
        ItemStack paletteItemStack = player.getItemInHand(interactionHand);
        if (!world.isClientSide()) {
            Compat.open_menu((ServerPlayer)player, paletteItemStack, 1);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(interactionHand));
    }

    public static SimpleContainer getInventory(ItemStack stack, Level level) {
        SimpleContainer inventory = new SimpleContainer(27);
        if (level == null) {
            return inventory;
        }
        CompoundTag tag = Compat.getTags(stack);
        ListTag inventory_tag = tag.getList("Palette", 10);
        for (int i = 0; i < inventory_tag.size(); ++i) {
            CompoundTag slot_tag = (CompoundTag)inventory_tag.get(i);
            if (!slot_tag.contains("Slot") || !slot_tag.contains("Block")) continue;
            int slot = slot_tag.getInt("Slot");
            Tag item_tag = slot_tag.get("Block");
            Optional is = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)item_tag);
            if (!is.isPresent()) continue;
            inventory.setItem(slot, (ItemStack)is.get());
        }
        return inventory;
    }

    public static void setInventory(ItemStack stack, SimpleContainer inventory, Level level) {
        if (level != null) {
            CompoundTag tag = Compat.getTags(stack);
            ListTag inventory_tag = tag.getList("Palette", 10);
            inventory_tag.clear();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                if (inventory.getItem(i).isEmpty()) continue;
                Tag item_tag = inventory.getItem(i).save((HolderLookup.Provider)level.registryAccess());
                CompoundTag slot_tag = new CompoundTag();
                slot_tag.putInt("Slot", i);
                slot_tag.put("Block", item_tag);
                inventory_tag.add((Object)slot_tag);
            }
            tag.put("Palette", (Tag)inventory_tag);
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
    }

    public static enum PaletteMode {
        RANDOM,
        ROUND_ROBIN;

    }
}

