/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.items;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.nicguzzo.wands.utils.Compat;
import org.jetbrains.annotations.NotNull;

public class MagicBagItem
extends Item {
    public int tier;
    public int limit = Integer.MAX_VALUE;

    public MagicBagItem(int tier, int limit, Item.Properties properties) {
        super(properties);
        this.tier = tier;
        if (limit > 0) {
            this.limit = limit;
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand interactionHand) {
        ItemStack magic_bag = player.getItemInHand(interactionHand);
        if (!world.isClientSide()) {
            Compat.open_menu((ServerPlayer)player, magic_bag, 2);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(interactionHand));
    }

    public static int getTotal(ItemStack bag) {
        if (bag != null && bag.getItem() instanceof MagicBagItem) {
            CompoundTag tag = Compat.getTags(bag);
            return tag.getInt("total");
        }
        return 0;
    }

    public static boolean inc(ItemStack bag, int n) {
        if (bag != null && bag.getItem() instanceof MagicBagItem) {
            int lim = ((MagicBagItem)bag.getItem()).limit;
            CompoundTag tag = Compat.getTags(bag);
            int total = tag.getInt("total");
            if (total + n < lim) {
                tag.putInt("total", total + n);
                CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)bag, (CompoundTag)tag);
                return true;
            }
        }
        return false;
    }

    public static void dec(ItemStack bag, int n) {
        if (bag != null && bag.getItem() instanceof MagicBagItem) {
            CompoundTag tag = Compat.getTags(bag);
            int total = tag.getInt("total");
            if (total - n >= 0) {
                tag.putInt("total", total - n);
            } else {
                tag.putInt("total", 0);
            }
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)bag, (CompoundTag)tag);
        }
    }

    public static void setItem(ItemStack bag, ItemStack item, HolderLookup.Provider ra) {
        if (bag != null && item != null && !item.isEmpty() && bag.getItem() instanceof MagicBagItem) {
            ItemStack item2 = item.copy();
            item2.setCount(1);
            CompoundTag tag = Compat.getTags(bag);
            if (ra != null) {
                tag.put("item", item2.save(ra, (Tag)new CompoundTag()));
                CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)bag, (CompoundTag)tag);
            }
        }
        if (item.isEmpty()) {
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)bag, (CompoundTag)new CompoundTag());
        }
    }

    public static ItemStack getItem(ItemStack bag, HolderLookup.Provider ra) {
        if (bag != null && bag.getItem() instanceof MagicBagItem) {
            Optional item;
            CompoundTag tag = Compat.getTags(bag);
            if (ra != null && tag.contains("item") && (item = ItemStack.parse((HolderLookup.Provider)ra, (Tag)tag.getCompound("item"))).isPresent()) {
                return (ItemStack)item.get();
            }
        }
        return ItemStack.EMPTY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        ItemStack i = MagicBagItem.getItem(stack, tooltipContext.registries());
        if (i.isEmpty()) {
            list.add((Component)Compat.literal("item: none"));
        } else {
            list.add((Component)Compat.literal("item: ").append((Component)Component.translatable((String)i.getItem().getDescriptionId())));
        }
        list.add((Component)Compat.literal("total: " + MagicBagItem.getTotal(stack)));
    }

    @NotNull
    public Component getName(ItemStack itemStack) {
        ItemStack item;
        if (Platform.getEnvironment() == Env.CLIENT && !itemStack.isEmpty() && itemStack.getItem() instanceof MagicBagItem && !(item = MagicBagItem.getItem(itemStack, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())).isEmpty()) {
            return Compat.literal("Bag of ").append((Component)Component.translatable((String)item.getItem().getDescriptionId())).append(" - Tier " + (this.tier + 1));
        }
        return super.getName(itemStack);
    }
}

