/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.client.screens;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.nicguzzo.wands.client.WandsModClient;
import net.nicguzzo.wands.client.gui.Btn;
import net.nicguzzo.wands.items.PaletteItem;
import net.nicguzzo.wands.menues.PaletteMenu;
import net.nicguzzo.wands.utils.Compat;

public class PaletteScreen
extends AbstractContainerScreen<PaletteMenu> {
    private static final ResourceLocation TEXTURE = Compat.create_resource_mc("textures/gui/container/shulker_box.png");
    private Btn btn_mode;
    private Btn btn_rotate;
    Component mode_val;
    Component rot_on = Compat.literal("rotate: on");
    Component rot_off = Compat.literal("rotate: off");

    public PaletteScreen(PaletteMenu handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    public void init() {
        super.init();
        this.btn_mode = new Btn(this.width / 2 + this.imageWidth / 2, this.height / 2 - 80, 40, 20, (Component)Compat.literal("mode"), (x, y) -> {
            if (((PaletteMenu)this.menu).palette != null) {
                PaletteItem.nextMode(((PaletteMenu)this.menu).palette);
                WandsModClient.send_palette(true, false);
            }
        });
        this.btn_rotate = new Btn(this.width / 2 + this.imageWidth / 2, this.height / 2 - 60, 40, 20, (Component)Compat.literal("rotate"), (x, y) -> {
            if (((PaletteMenu)this.menu).palette != null) {
                PaletteItem.toggleRotate(((PaletteMenu)this.menu).palette);
                WandsModClient.send_palette(false, true);
            }
        });
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        super.render(gui, mouseX, mouseY, delta);
        Minecraft client = Minecraft.getInstance();
        if (((PaletteMenu)this.menu).palette != null) {
            PaletteItem.PaletteMode mode = PaletteItem.getMode(((PaletteMenu)this.menu).palette);
            switch (mode) {
                case RANDOM: {
                    this.mode_val = PaletteItem.mode_val_random;
                    break;
                }
                case ROUND_ROBIN: {
                    this.mode_val = PaletteItem.mode_val_rr;
                    break;
                }
                default: {
                    this.mode_val = PaletteItem.mode_val_random;
                }
            }
            CompoundTag tag = Compat.getTags(((PaletteMenu)this.menu).palette);
            boolean rot = tag.getBoolean("rotate");
            gui.drawString(client.font, rot ? this.rot_on : this.rot_off, this.width / 2 - 30, this.height / 2 - 77, 0x404040, false);
            gui.drawString(client.font, this.mode_val, this.width / 2 + 30, this.height / 2 - 77, 0x404040, false);
            this.btn_mode.render(gui, this.font, mouseX, mouseY);
            this.btn_rotate.render(gui, this.font, mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics gui, float f, int i, int j) {
        Compat.set_color(1.0f, 1.0f, 1.0f, 1.0f);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        gui.blit(TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    boolean is_hovering(int i, int j, int k, int l, double d, double e) {
        int m = this.leftPos;
        int n = this.topPos;
        return (d -= (double)m) >= (double)(i - 1) && d < (double)(i + k + 1) && (e -= (double)n) >= (double)(j - 1) && e < (double)(j + l + 1);
    }

    public final Slot find_slot(double d, double e) {
        for (int i = 0; i < ((PaletteMenu)this.menu).slots.size(); ++i) {
            Slot slot = (Slot)((PaletteMenu)this.menu).slots.get(i);
            if (!this.is_hovering(slot.x, slot.y, 16, 16, d, e) || !slot.isActive()) continue;
            return slot;
        }
        return null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.btn_mode.click((int)mouseX, (int)mouseY);
        this.btn_rotate.click((int)mouseX, (int)mouseY);
        Slot slot = this.find_slot(mouseX, mouseY);
        if (slot != null) {
            switch (button) {
                case 0: {
                    if (PaletteScreen.hasShiftDown()) {
                        this.slotClicked(slot, slot.index, button, ClickType.QUICK_MOVE);
                        break;
                    }
                    this.slotClicked(slot, slot.index, button, ClickType.PICKUP);
                    break;
                }
                case 1: {
                    this.slotClicked(slot, slot.index, button, ClickType.PICKUP);
                    break;
                }
                case 2: {
                    this.slotClicked(slot, slot.index, button, ClickType.CLONE);
                }
            }
        }
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        Slot slot = this.find_slot(mouseX, mouseY);
        if (slot != null) {
            Minecraft client = Minecraft.getInstance();
            ItemStack itemStack = Compat.get_carried((Player)client.player, this.menu);
            if (itemStack != ItemStack.EMPTY && slot.getItem() == ItemStack.EMPTY) {
                this.slotClicked(slot, slot.index, button, ClickType.QUICK_CRAFT);
            }
        }
        return true;
    }
}

