/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.nicguzzo.wands.items.MagicBagItem;
import net.nicguzzo.wands.menues.MagicBagMenu;
import net.nicguzzo.wands.utils.Compat;

public class MagicBagScreen
extends AbstractContainerScreen<MagicBagMenu> {
    private static final ResourceLocation TEXTURE = Compat.create_resource("textures/gui/magicbag.png");
    ItemStack bag_stack = null;
    Item bag_item = null;
    int tier = 0;

    public MagicBagScreen(MagicBagMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    public void init() {
        super.init();
        this.bag_stack = ((MagicBagMenu)this.menu).bag;
        if (this.bag_stack != null && this.bag_stack.getItem() instanceof MagicBagItem) {
            this.bag_item = this.bag_stack.getItem();
            this.tier = ((MagicBagItem)this.bag_item).tier;
        }
    }

    protected void renderBg(GuiGraphics gui, float f, int i, int j) {
        Compat.set_color(1.0f, 1.0f, 1.0f, 1.0f);
        Compat.set_texture(TEXTURE);
        Compat.set_pos_tex_shader();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        gui.blit(TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        gui.blit(TEXTURE, x + this.imageWidth - 64, y + 10, 200.0f, (float)(64 * this.tier), 41, 64, 256, 256);
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        super.render(gui, mouseX, mouseY, delta);
        Minecraft client = Minecraft.getInstance();
        int text_color = -1;
        RenderSystem.disableDepthTest();
        ItemStack item = MagicBagItem.getItem(this.bag_stack, (HolderLookup.Provider)client.level.registryAccess());
        if (!item.isEmpty()) {
            MutableComponent text = Component.translatable((String)item.getItem().getDescriptionId());
            int w = this.font.width((FormattedText)text);
            gui.drawString(client.font, text.getString(), this.width / 2 - w / 2, this.height / 2 - 20, text_color, false);
        }
        MutableComponent text2 = Compat.literal("" + MagicBagItem.getTotal(this.bag_stack));
        int w2 = this.font.width((FormattedText)text2);
        gui.drawString(client.font, (Component)text2, this.width / 2 - w2 / 2, this.height / 2 - 32, text_color, false);
        this.renderTooltip(gui, mouseX, mouseY);
        RenderSystem.enableDepthTest();
    }
}

