/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.Env;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.nicguzzo.wands.config.WandsConfig;
import net.nicguzzo.wands.items.MagicBagItem;
import net.nicguzzo.wands.items.PaletteItem;
import net.nicguzzo.wands.items.WandItem;
import net.nicguzzo.wands.menues.MagicBagMenu;
import net.nicguzzo.wands.menues.PaletteMenu;
import net.nicguzzo.wands.menues.WandMenu;
import net.nicguzzo.wands.networking.Networking;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.utils.WandUtils;
import net.nicguzzo.wands.wand.PlayerWand;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandProps;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WandsMod {
    public static int platform = -1;
    public static final WandsConfig config = WandsConfig.get_instance();
    public static final String MOD_ID = "wands";
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean has_opac = false;
    public static boolean has_ftbchunks = false;
    public static boolean has_flan = false;
    public static boolean has_goml = false;
    public static final Supplier<RegistrarManager> REGISTRIES = Suppliers.memoize(() -> RegistrarManager.get((String)MOD_ID));
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((String)"wands", (ResourceKey)Registries.CREATIVE_MODE_TAB);
    public static final RegistrySupplier<CreativeModeTab> WANDS_TAB = TABS.register("wands_tab", () -> CreativeTabRegistry.create((Component)Component.translatable((String)"itemGroup.wands.wands_tab"), () -> new ItemStack((ItemLike)DIAMOND_WAND_ITEM.get())));
    static ResourceLocation stone_wand = Compat.create_resource("stone_wand");
    static ResourceLocation iron_wand = Compat.create_resource("iron_wand");
    static ResourceLocation diamond_wand = Compat.create_resource("diamond_wand");
    static ResourceLocation netherite_wand = Compat.create_resource("netherite_wand");
    static ResourceLocation creative_wand = Compat.create_resource("creative_wand");
    static ResourceLocation palette = Compat.create_resource("palette");
    static ResourceLocation magic_bag_1 = Compat.create_resource("magic_bag_1");
    static ResourceLocation magic_bag_2 = Compat.create_resource("magic_bag_2");
    static ResourceLocation magic_bag_3 = Compat.create_resource("magic_bag_3");
    static ResourceKey<Item> stone_wand_key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)stone_wand);
    static ResourceKey<Item> iron_wand_key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)iron_wand);
    static ResourceKey<Item> diamond_wand_key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)diamond_wand);
    static ResourceKey<Item> netherite_wand_key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)netherite_wand);
    static ResourceKey<Item> creative_wand_key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)creative_wand);
    static ResourceKey<Item> palette_key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)palette);
    static ResourceKey<Item> magic_bag_1_key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)magic_bag_1);
    static ResourceKey<Item> magic_bag_2_key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)magic_bag_2);
    static ResourceKey<Item> magic_bag_3_key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)magic_bag_3);
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"wands", (ResourceKey)Registries.ITEM);
    public static final DeferredRegister<MenuType<?>> MENUES = DeferredRegister.create((String)"wands", (ResourceKey)Registries.MENU);
    public static final RegistrySupplier<Item> STONE_WAND_ITEM = ITEMS.register(stone_wand, () -> new WandItem(0, WandsMod.config.stone_wand_limit, false, false, false, false, new Item.Properties().durability(WandsMod.config.stone_wand_durability).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<Item> IRON_WAND_ITEM = ITEMS.register(iron_wand, () -> new WandItem(1, WandsMod.config.iron_wand_limit, false, false, false, false, new Item.Properties().durability(WandsMod.config.iron_wand_durability).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<Item> DIAMOND_WAND_ITEM = ITEMS.register(diamond_wand, () -> new WandItem(2, WandsMod.config.diamond_wand_limit, true, false, false, false, new Item.Properties().durability(WandsMod.config.diamond_wand_durability).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<Item> NETHERITE_WAND_ITEM = ITEMS.register(netherite_wand, () -> new WandItem(3, WandsMod.config.netherite_wand_limit, true, true, false, true, new Item.Properties().fireResistant().durability(WandsMod.config.netherite_wand_durability).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<Item> CREATIVE_WAND_ITEM = ITEMS.register(creative_wand, () -> new WandItem(4, WandsMod.config.creative_wand_limit, true, true, true, true, new Item.Properties().fireResistant().stacksTo(1).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<Item> PALETTE_ITEM = ITEMS.register("palette", () -> new PaletteItem(new Item.Properties().stacksTo(1).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<Item> MAGIC_BAG_1 = ITEMS.register("magic_bag_1", () -> new MagicBagItem(0, WandsMod.config.magic_bag_1_limit, new Item.Properties().stacksTo(1).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<Item> MAGIC_BAG_2 = ITEMS.register("magic_bag_2", () -> new MagicBagItem(1, WandsMod.config.magic_bag_2_limit, new Item.Properties().stacksTo(1).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<Item> MAGIC_BAG_3 = ITEMS.register("magic_bag_3", () -> new MagicBagItem(2, Integer.MAX_VALUE, new Item.Properties().stacksTo(1).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<MenuType<PaletteMenu>> PALETTE_CONTAINER = MENUES.register("palette_menu", () -> MenuRegistry.ofExtended(PaletteMenu::new));
    public static final RegistrySupplier<MenuType<WandMenu>> WAND_CONTAINER = MENUES.register("wand_menu", () -> MenuRegistry.ofExtended(WandMenu::new));
    public static final RegistrySupplier<MenuType<MagicBagMenu>> MAGIC_WAND_CONTANIER = MENUES.register("magic_bag_menu", () -> MenuRegistry.ofExtended(MagicBagMenu::new));
    public static boolean is_forge = false;
    public static boolean is_neoforge = false;
    public static boolean is_fabric = false;

    public static void init() {
        ITEMS.register();
        MENUES.register();
        TABS.register();
        if (Platform.getEnvironment() == Env.SERVER) {
            NetworkManager.registerS2CPayloadType(Networking.ConfPacket.TYPE, Networking.ConfPacket.STREAM_CODEC);
            NetworkManager.registerS2CPayloadType(Networking.SndPacket.TYPE, Networking.SndPacket.STREAM_CODEC);
            NetworkManager.registerS2CPayloadType(Networking.ToastPacket.TYPE, Networking.ToastPacket.STREAM_CODEC);
            NetworkManager.registerS2CPayloadType(Networking.StatePacket.TYPE, Networking.StatePacket.STREAM_CODEC);
            NetworkManager.registerS2CPayloadType(Networking.PlayerDataPacket.TYPE, Networking.PlayerDataPacket.STREAM_CODEC);
        }
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, Networking.KbPacket.TYPE, Networking.KbPacket.STREAM_CODEC, (data, context) -> WandsMod.process_keys(context.getPlayer(), data.key(), data.shift(), data.alt()));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, Networking.PalettePacket.TYPE, Networking.PalettePacket.STREAM_CODEC, (data, context) -> WandsMod.process_palette(context.getPlayer(), data.mode(), data.rotate()));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, Networking.WandPacket.TYPE, Networking.WandPacket.STREAM_CODEC, (data, context) -> {
            ItemStack wand_stack = context.getPlayer().getMainHandItem();
            wand_stack.applyComponents(data.item_stack().getComponents());
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, Networking.PosPacket.TYPE, Networking.PosPacket.STREAM_CODEC, (data, context) -> {
            BlockPos pos;
            BlockState block_state;
            Player player = context.getPlayer();
            if (player == null) {
                LOGGER.error("player is null");
                return;
            }
            Level level = Compat.player_level(player);
            ItemStack stack = context.getPlayer().getMainHandItem();
            if (!WandUtils.is_wand(stack)) {
                LOGGER.error("player doesn't have a wand in main hand");
                return;
            }
            Wand wand = PlayerWand.get(player);
            if (wand == null) {
                LOGGER.error("wand is null");
                return;
            }
            int d = data.dir();
            int has_p1_p2 = data.has_p1_p2();
            Direction side = Direction.values()[d];
            BlockPos p1 = has_p1_p2 == 1 ? data.p1() : null;
            BlockPos p2 = has_p1_p2 == 2 ? data.p2() : null;
            if (has_p1_p2 == 3) {
                p1 = data.p1();
                p2 = data.p2();
            }
            if (p1 == null) {
                LOGGER.info("needs at least 1 position");
                return;
            }
            if (p2 != null) {
                block_state = level.getBlockState(p2);
                pos = p2;
            } else {
                block_state = level.getBlockState(p1);
                pos = p1;
            }
            if (block_state.isAir()) {
                block_state = level.getBlockState(p1);
            }
            wand.setP1(p1);
            wand.setP2(p2);
            Vec3 hit = new Vec3(data.hit().x, data.hit().y, data.hit().z);
            wand.palette.seed = data.seed();
            wand.do_or_preview(player, level, block_state, pos, side, hit, stack, (WandItem)stack.getItem(), true);
            wand.clear();
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, Networking.GlobalSettingsPacket.TYPE, Networking.GlobalSettingsPacket.STREAM_CODEC, (packet, context) -> {
            Wand wand;
            Player player = context.getPlayer();
            if (player != null && (wand = PlayerWand.get(player)) != null) {
                wand.drop_on_player = packet.drop_pos();
            }
        });
        PlayerEvent.PLAYER_JOIN.register(player -> {
            Wand wand = null;
            wand = PlayerWand.get((Player)player);
            if (wand == null) {
                PlayerWand.add_player((Player)player);
                wand = PlayerWand.get((Player)player);
            }
            if (!Compat.player_level((Player)player).isClientSide()) {
                if (config != null) {
                    NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new Networking.ConfPacket(WandsMod.config.blocks_per_xp, WandsMod.config.destroy_in_survival_drop, WandsMod.config.survival_unenchanted_drops, WandsMod.config.allow_wand_to_break, WandsMod.config.allow_offhand_to_break, WandsMod.config.mend_tools));
                }
                NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new Networking.PlayerDataPacket(wand.player_data));
            }
        });
        PlayerEvent.PLAYER_QUIT.register(player -> PlayerWand.remove_player((Player)player));
    }

    public static void send_state(ServerPlayer player, Wand wand) {
        ItemStack wand_stack;
        if (wand != null && player != null && !Compat.player_level((Player)player).isClientSide() && (wand_stack = player.getMainHandItem()).getItem() instanceof WandItem) {
            WandProps.Mode mode = WandProps.getMode(wand_stack);
            int slot = 0;
            if (wand.palette.palette_slots.size() != 0) {
                slot = (wand.palette.slot + 1) % wand.palette.palette_slots.size();
            }
            float BLOCKS_PER_XP = WandsMod.config.blocks_per_xp;
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new Networking.StatePacket(mode.ordinal(), slot, BLOCKS_PER_XP != 0.0f, player.experienceLevel, player.experienceProgress));
        }
    }

    public static void process_palette(Player player, boolean mode, boolean rotate) {
        ItemStack item_stack = player.getMainHandItem();
        ItemStack palette = null;
        if (!item_stack.isEmpty() && item_stack.getItem() instanceof PaletteItem) {
            palette = item_stack;
        } else {
            ItemStack offhand_stack = player.getOffhandItem();
            if (!offhand_stack.isEmpty() && offhand_stack.getItem() instanceof PaletteItem) {
                palette = offhand_stack;
            }
        }
        if (palette != null) {
            if (mode) {
                PaletteItem.nextMode(palette);
            }
            if (rotate) {
                PaletteItem.toggleRotate(palette);
            }
        }
    }

    public static void process_keys(Player player, int key, boolean shift, boolean alt) {
        Wand wand;
        ItemStack main_stack = player.getMainHandItem();
        ItemStack offhand_stack = player.getOffhandItem();
        boolean is_wand = main_stack.getItem() instanceof WandItem;
        boolean is_palette = main_stack.getItem() instanceof PaletteItem || offhand_stack.getItem() instanceof PaletteItem;
        boolean creative = Compat.is_creative(player);
        if (is_palette && key >= 0 && key < WandKeys.values().length) {
            switch (WandKeys.values()[key].ordinal()) {
                case 17: {
                    if (offhand_stack.getItem() instanceof PaletteItem) {
                        Compat.open_menu((ServerPlayer)player, offhand_stack, 1);
                        break;
                    }
                    ItemStack mainhand_stack = player.getMainHandItem();
                    if (!(mainhand_stack.getItem() instanceof PaletteItem)) break;
                    Compat.open_menu((ServerPlayer)player, mainhand_stack, 1);
                    break;
                }
                case 16: {
                    if (offhand_stack.isEmpty() || !(offhand_stack.getItem() instanceof PaletteItem)) break;
                    PaletteItem.nextMode(offhand_stack);
                    player.displayClientMessage((Component)Compat.literal("Palette mode: " + String.valueOf((Object)PaletteItem.getMode(offhand_stack))), false);
                }
            }
        }
        if (is_wand) {
            int inc;
            wand = PlayerWand.get(player);
            WandItem wand_item = (WandItem)main_stack.getItem();
            if (wand == null) {
                return;
            }
            WandProps.Mode mode = WandProps.getMode(main_stack);
            int n = inc = shift ? 10 : 1;
            if (key >= 0 && key < WandKeys.values().length) {
                block4 : switch (WandKeys.values()[key].ordinal()) {
                    case 15: {
                        WandProps.toggleFlag(main_stack, WandProps.Flag.INCSELBLOCK);
                        break;
                    }
                    case 14: {
                        WandProps.toggleFlag(main_stack, WandProps.Flag.DIAGSPREAD);
                        break;
                    }
                    case 13: {
                        WandProps.setStateMode(main_stack, WandProps.StateMode.APPLY);
                        WandProps.toggleFlag(main_stack, WandProps.Flag.STAIRSLAB);
                        break;
                    }
                    case 11: {
                        if (mode != WandProps.Mode.GRID) break;
                        WandProps.incGrid(main_stack, WandProps.Value.GRIDN, inc, wand_item.limit);
                        break;
                    }
                    case 12: {
                        if (mode != WandProps.Mode.GRID) break;
                        WandProps.decVal(main_stack, WandProps.Value.GRIDN, inc);
                        break;
                    }
                    case 9: {
                        switch (mode) {
                            case DIRECTION: {
                                WandProps.incVal(main_stack, WandProps.Value.MULTIPLIER, inc);
                                break;
                            }
                            case ROW_COL: {
                                WandProps.incVal(main_stack, WandProps.Value.ROWCOLLIM, inc);
                                break;
                            }
                            case GRID: {
                                WandProps.incGrid(main_stack, WandProps.Value.GRIDM, inc, wand_item.limit);
                                break;
                            }
                            case AREA: {
                                WandProps.incVal(main_stack, WandProps.Value.AREALIM, inc);
                            }
                        }
                        break;
                    }
                    case 10: {
                        switch (mode) {
                            case DIRECTION: {
                                WandProps.decVal(main_stack, WandProps.Value.MULTIPLIER, inc);
                                break;
                            }
                            case ROW_COL: {
                                WandProps.decVal(main_stack, WandProps.Value.ROWCOLLIM, inc);
                                break;
                            }
                            case GRID: {
                                WandProps.decVal(main_stack, WandProps.Value.GRIDM, inc);
                                break;
                            }
                            case AREA: {
                                WandProps.decVal(main_stack, WandProps.Value.AREALIM, inc);
                            }
                        }
                        break;
                    }
                    case 2: {
                        if (shift) {
                            WandProps.prevAction(main_stack);
                        } else {
                            WandProps.nextAction(main_stack);
                        }
                        player.displayClientMessage((Component)Compat.literal("Wand Action: ").append((Component)Compat.translatable(WandProps.getAction(main_stack).toString())), false);
                        break;
                    }
                    case 0: {
                        Compat.open_menu((ServerPlayer)player, main_stack, 0);
                        break;
                    }
                    case 1: {
                        if (shift) {
                            WandProps.prevMode(main_stack, wand_item.can_blast);
                            break;
                        }
                        WandProps.nextMode(main_stack, wand_item.can_blast);
                        break;
                    }
                    case 3: {
                        switch (mode) {
                            case CIRCLE: 
                            case FILL: {
                                WandProps.nextPlane(main_stack);
                                player.displayClientMessage((Component)Compat.literal("Wand Plane: " + String.valueOf((Object)WandProps.getPlane(main_stack))), false);
                                WandsMod.send_state((ServerPlayer)player, wand);
                                break block4;
                            }
                            case DIRECTION: 
                            case PASTE: {
                                break block4;
                            }
                        }
                        WandProps.nextOrientation(main_stack);
                        player.displayClientMessage((Component)Compat.literal("Wand Orientation: ").append((Component)Compat.translatable(WandProps.getOrientation(main_stack).toString())), false);
                        break;
                    }
                    case 5: {
                        WandProps.toggleFlag(main_stack, WandProps.Flag.INVERTED);
                        player.displayClientMessage((Component)Compat.literal("Wand inverted: " + WandProps.getFlag(main_stack, WandProps.Flag.INVERTED)), false);
                        break;
                    }
                    case 6: {
                        switch (wand.mode) {
                            case FILL: {
                                WandProps.toggleFlag(main_stack, WandProps.Flag.RFILLED);
                                player.displayClientMessage((Component)Compat.literal("Wand fill rect: " + WandProps.getFlag(main_stack, WandProps.Flag.RFILLED)), false);
                                break;
                            }
                            case CIRCLE: {
                                WandProps.toggleFlag(main_stack, WandProps.Flag.CFILLED);
                                player.displayClientMessage((Component)Compat.literal("Wand circle fill: " + WandProps.getFlag(main_stack, WandProps.Flag.CFILLED)), false);
                            }
                        }
                        break;
                    }
                    case 7: {
                        WandProps.nextRotation(main_stack);
                        WandProps.setStateMode(main_stack, WandProps.StateMode.APPLY);
                        break;
                    }
                    case 4: {
                        if (!creative || Compat.player_level(player).isClientSide() || wand == null) break;
                        int n2 = 1;
                        if (alt) {
                            n2 = 10;
                        }
                        if (shift) {
                            wand.redo(n2);
                            break;
                        }
                        wand.undo(n2);
                        break;
                    }
                    case 18: {
                        if (wand != null) {
                            wand.clear();
                        }
                        if (player == null) break;
                        player.displayClientMessage((Component)Compat.literal("wand cleared"), false);
                    }
                }
            }
        }
        if (!main_stack.isEmpty() && main_stack.getItem() instanceof PaletteItem && key >= 0 && key < WandKeys.values().length && Objects.requireNonNull(WandKeys.values()[key]) == WandKeys.PALETTE_MODE) {
            PaletteItem.nextMode(main_stack);
            player.displayClientMessage((Component)Compat.literal("Palette mode: " + String.valueOf((Object)PaletteItem.getMode(main_stack))), false);
        }
        if (is_wand && key < 0) {
            wand = null;
            if (!Compat.player_level(player).isClientSide() && (wand = PlayerWand.get(player)) == null) {
                PlayerWand.add_player(player);
                wand = PlayerWand.get(player);
            }
            if (wand != null) {
                wand.is_alt_pressed = alt;
                wand.is_shift_pressed = shift;
            }
        }
    }

    public static void log(String s, boolean b) {
        if (b) {
            LOGGER.info(s);
        }
    }

    public static enum WandKeys {
        MENU,
        MODE,
        ACTION,
        ORIENTATION,
        UNDO,
        INVERT,
        FILL,
        ROTATE,
        CONF,
        M_INC,
        M_DEC,
        N_INC,
        N_DEC,
        TOGGLE_STAIRSLAB,
        DIAGONAL_SPREAD,
        INC_SEL_BLK,
        PALETTE_MODE,
        PALETTE_MENU,
        CLEAR;

    }
}

