/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.menu;

import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.menu.ModMenus;
import net.blay09.mods.waystones.menu.WaystoneModifierSlot;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class WaystoneModifierMenu
extends AbstractContainerMenu {
    private final Container container;
    private final Waystone waystone;

    public WaystoneModifierMenu(int windowId, Inventory playerInventory, Waystone waystone) {
        this(windowId, playerInventory, waystone, (Container)new SimpleContainer(5));
    }

    public WaystoneModifierMenu(int windowId, Inventory playerInventory, Waystone waystone, Container container) {
        super((MenuType)ModMenus.waystoneModifiers.get(), windowId);
        this.container = container;
        this.waystone = waystone;
        this.addSlot(new WaystoneModifierSlot(container, 0, 80, 45));
        this.addSlot(new WaystoneModifierSlot(container, 1, 80, 17));
        this.addSlot(new WaystoneModifierSlot(container, 2, 108, 45));
        this.addSlot(new WaystoneModifierSlot(container, 3, 80, 73));
        this.addSlot(new WaystoneModifierSlot(container, 4, 52, 45));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 104 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, 8 + j * 18, 162));
        }
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (index < 5 ? !this.moveItemStackTo(slotStack, 5, this.slots.size(), true) : (!this.getSlot(0).hasItem() ? !this.moveItemStackTo(slotStack.split(1), 0, 1, false) : !this.moveItemStackTo(slotStack, 1, 5, false))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public Waystone getWaystone() {
        return this.waystone;
    }
}

