/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data.builder;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CuttingBoardRecipeBuilder
implements RecipeBuilder {
    private final NonNullList<ChanceResult> results = NonNullList.createWithCapacity((int)4);
    private final Ingredient ingredient;
    private final Ingredient tool;
    private SoundEvent soundEvent;

    private CuttingBoardRecipeBuilder(Ingredient ingredient, Ingredient tool, ItemLike mainResult, int count, float chance) {
        this.results.add((Object)new ChanceResult(new ItemStack((ItemLike)mainResult.asItem(), count), chance));
        this.ingredient = ingredient;
        this.tool = tool;
    }

    public static CuttingBoardRecipeBuilder cuttingRecipe(Ingredient ingredient, Ingredient tool, ItemLike mainResult, int count) {
        return new CuttingBoardRecipeBuilder(ingredient, tool, mainResult, count, 1.0f);
    }

    public static CuttingBoardRecipeBuilder cuttingRecipe(Ingredient ingredient, Ingredient tool, ItemLike mainResult, int count, int chance) {
        return new CuttingBoardRecipeBuilder(ingredient, tool, mainResult, count, chance);
    }

    public static CuttingBoardRecipeBuilder cuttingRecipe(Ingredient ingredient, Ingredient tool, ItemLike mainResult) {
        return new CuttingBoardRecipeBuilder(ingredient, tool, mainResult, 1, 1.0f);
    }

    public CuttingBoardRecipeBuilder addResult(ItemLike result) {
        return this.addResult(result, 1);
    }

    public CuttingBoardRecipeBuilder addResult(ItemLike result, int count) {
        this.results.add((Object)new ChanceResult(new ItemStack((ItemLike)result.asItem(), count), 1.0f));
        return this;
    }

    public CuttingBoardRecipeBuilder addResultWithChance(ItemLike result, float chance) {
        return this.addResultWithChance(result, chance, 1);
    }

    public CuttingBoardRecipeBuilder addResultWithChance(ItemLike result, float chance, int count) {
        this.results.add((Object)new ChanceResult(new ItemStack((ItemLike)result.asItem(), count), chance));
        return this;
    }

    public CuttingBoardRecipeBuilder addSound(SoundEvent soundEvent) {
        this.soundEvent = soundEvent;
        return this;
    }

    public RecipeBuilder unlockedBy(String p_176496_, Criterion<?> p_301065_) {
        return this;
    }

    public RecipeBuilder group(@Nullable String p_176495_) {
        return this;
    }

    public Item getResult() {
        return this.ingredient.getItems()[0].getItem();
    }

    public void build(RecipeOutput output) {
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)this.getResult());
        this.save(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)location.getPath()));
    }

    public void build(RecipeOutput outputIn, String save) {
        ResourceLocation resourcelocation = BuiltInRegistries.ITEM.getKey((Object)this.getResult());
        if (ResourceLocation.parse((String)save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Cutting Recipe " + save + " should remove its 'save' argument");
        }
        this.build(outputIn, ResourceLocation.parse((String)save));
    }

    public void build(RecipeOutput output, ResourceLocation id) {
        this.save(output, id);
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        CuttingBoardRecipe recipe = new CuttingBoardRecipe("", this.ingredient, this.tool, this.results, this.soundEvent == null ? Optional.empty() : Optional.of(this.soundEvent));
        output.accept(id.withPrefix("cutting/"), (Recipe)recipe, null);
    }
}

