/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import vectorwing.farmersdelight.FarmersDelight;
import vectorwing.farmersdelight.common.registry.ModItems;

public class ItemModels
extends ItemModelProvider {
    public static final String GENERATED = "item/generated";
    public static final String HANDHELD = "item/handheld";
    public static final ResourceLocation MUG = ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"item/mug");

    public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "farmersdelight", existingFileHelper);
    }

    protected void registerModels() {
        Set<Item> items = BuiltInRegistries.ITEM.stream().filter(i -> "farmersdelight".equals(BuiltInRegistries.ITEM.getKey(i).getNamespace())).collect(Collectors.toSet());
        items.remove(ModItems.SKILLET.get());
        this.itemGeneratedModel(ModItems.WILD_RICE.get(), this.resourceBlock(this.itemName(ModItems.WILD_RICE.get()) + "_top"));
        items.remove(ModItems.WILD_RICE.get());
        this.itemGeneratedModel(ModItems.BROWN_MUSHROOM_COLONY.get(), this.resourceBlock(this.itemName(ModItems.BROWN_MUSHROOM_COLONY.get()) + "_stage3"));
        items.remove(ModItems.BROWN_MUSHROOM_COLONY.get());
        this.itemGeneratedModel(ModItems.RED_MUSHROOM_COLONY.get(), this.resourceBlock(this.itemName(ModItems.RED_MUSHROOM_COLONY.get()) + "_stage3"));
        items.remove(ModItems.RED_MUSHROOM_COLONY.get());
        this.blockBasedModel(ModItems.TATAMI.get(), "_half");
        items.remove(ModItems.TATAMI.get());
        this.blockBasedModel(ModItems.ORGANIC_COMPOST.get(), "_0");
        items.remove(ModItems.ORGANIC_COMPOST.get());
        HashSet mugItems = Sets.newHashSet((Object[])new Item[]{ModItems.HOT_COCOA.get(), ModItems.APPLE_CIDER.get(), ModItems.MELON_JUICE.get()});
        ItemModels.takeAll(items, mugItems.toArray(new Item[0])).forEach(item -> this.itemMugModel((Item)item, this.resourceItem(this.itemName((Item)item))));
        HashSet spriteBlockItems = Sets.newHashSet((Object[])new Item[]{ModItems.FULL_TATAMI_MAT.get(), ModItems.HALF_TATAMI_MAT.get(), ModItems.ROPE.get(), ModItems.CANVAS_SIGN.get(), ModItems.HANGING_CANVAS_SIGN.get(), ModItems.WHITE_CANVAS_SIGN.get(), ModItems.WHITE_HANGING_CANVAS_SIGN.get(), ModItems.ORANGE_CANVAS_SIGN.get(), ModItems.ORANGE_HANGING_CANVAS_SIGN.get(), ModItems.MAGENTA_CANVAS_SIGN.get(), ModItems.MAGENTA_HANGING_CANVAS_SIGN.get(), ModItems.LIGHT_BLUE_CANVAS_SIGN.get(), ModItems.LIGHT_BLUE_HANGING_CANVAS_SIGN.get(), ModItems.YELLOW_CANVAS_SIGN.get(), ModItems.YELLOW_HANGING_CANVAS_SIGN.get(), ModItems.LIME_CANVAS_SIGN.get(), ModItems.LIME_HANGING_CANVAS_SIGN.get(), ModItems.PINK_CANVAS_SIGN.get(), ModItems.PINK_HANGING_CANVAS_SIGN.get(), ModItems.GRAY_CANVAS_SIGN.get(), ModItems.GRAY_HANGING_CANVAS_SIGN.get(), ModItems.LIGHT_GRAY_CANVAS_SIGN.get(), ModItems.LIGHT_GRAY_HANGING_CANVAS_SIGN.get(), ModItems.CYAN_CANVAS_SIGN.get(), ModItems.CYAN_HANGING_CANVAS_SIGN.get(), ModItems.PURPLE_CANVAS_SIGN.get(), ModItems.PURPLE_HANGING_CANVAS_SIGN.get(), ModItems.BLUE_CANVAS_SIGN.get(), ModItems.BLUE_HANGING_CANVAS_SIGN.get(), ModItems.BROWN_CANVAS_SIGN.get(), ModItems.BROWN_HANGING_CANVAS_SIGN.get(), ModItems.GREEN_CANVAS_SIGN.get(), ModItems.GREEN_HANGING_CANVAS_SIGN.get(), ModItems.RED_CANVAS_SIGN.get(), ModItems.RED_HANGING_CANVAS_SIGN.get(), ModItems.BLACK_CANVAS_SIGN.get(), ModItems.BLACK_HANGING_CANVAS_SIGN.get(), ModItems.APPLE_PIE.get(), ModItems.SWEET_BERRY_CHEESECAKE.get(), ModItems.CHOCOLATE_PIE.get(), ModItems.CABBAGE_SEEDS.get(), ModItems.TOMATO_SEEDS.get(), ModItems.ONION.get(), ModItems.RICE.get(), ModItems.ROAST_CHICKEN_BLOCK.get(), ModItems.STUFFED_PUMPKIN_BLOCK.get(), ModItems.HONEY_GLAZED_HAM_BLOCK.get(), ModItems.SHEPHERDS_PIE_BLOCK.get(), ModItems.RICE_ROLL_MEDLEY_BLOCK.get()});
        ItemModels.takeAll(items, spriteBlockItems.toArray(new Item[0])).forEach(item -> ((ItemModelBuilder)this.withExistingParent(this.itemName((Item)item), GENERATED)).texture("layer0", this.resourceItem(this.itemName((Item)item))));
        HashSet flatBlockItems = Sets.newHashSet((Object[])new Item[]{ModItems.SAFETY_NET.get(), ModItems.SANDY_SHRUB.get(), ModItems.WILD_BEETROOTS.get(), ModItems.WILD_CABBAGES.get(), ModItems.WILD_CARROTS.get(), ModItems.WILD_ONIONS.get(), ModItems.WILD_POTATOES.get(), ModItems.WILD_TOMATOES.get()});
        ItemModels.takeAll(items, flatBlockItems.toArray(new Item[0])).forEach(item -> this.itemGeneratedModel((Item)item, this.resourceBlock(this.itemName((Item)item))));
        ItemModels.takeAll(items, i -> i instanceof BlockItem).forEach(item -> this.blockBasedModel((Item)item, ""));
        HashSet handheldItems = Sets.newHashSet((Object[])new Item[]{ModItems.BARBECUE_STICK.get(), ModItems.HAM.get(), ModItems.SMOKED_HAM.get(), ModItems.FLINT_KNIFE.get(), ModItems.IRON_KNIFE.get(), ModItems.DIAMOND_KNIFE.get(), ModItems.GOLDEN_KNIFE.get(), ModItems.NETHERITE_KNIFE.get()});
        ItemModels.takeAll(items, handheldItems.toArray(new Item[0])).forEach(item -> this.itemHandheldModel((Item)item, this.resourceItem(this.itemName((Item)item))));
        items.forEach(item -> this.itemGeneratedModel((Item)item, this.resourceItem(this.itemName((Item)item))));
    }

    public void blockBasedModel(Item item, String suffix) {
        this.withExistingParent(this.itemName(item), this.resourceBlock(this.itemName(item) + suffix));
    }

    public void itemHandheldModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), HANDHELD)).texture("layer0", texture);
    }

    public void itemGeneratedModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), GENERATED)).texture("layer0", texture);
    }

    public void itemMugModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), MUG)).texture("layer0", texture);
    }

    private String itemName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    public ResourceLocation resourceBlock(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)("block/" + path));
    }

    public ResourceLocation resourceItem(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)("item/" + path));
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Set<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            FarmersDelight.LOGGER.warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            FarmersDelight.LOGGER.warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            FarmersDelight.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }
}

