/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.belt.item;

import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.kinetics.belt.item.BeltConnectorItem;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class BeltConnectorHandler {
    private static final Random r = new Random();

    public static void tick() {
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel world = Minecraft.getInstance().level;
        if (player == null || world == null) {
            return;
        }
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            BlockPos first;
            ItemStack heldItem = player.getItemInHand(hand);
            if (!AllItems.BELT_CONNECTOR.isIn(heldItem) || !heldItem.has(AllDataComponents.BELT_FIRST_SHAFT) || !world.getBlockState(first = (BlockPos)heldItem.get(AllDataComponents.BELT_FIRST_SHAFT)).hasProperty((Property)BlockStateProperties.AXIS)) continue;
            Direction.Axis axis = (Direction.Axis)world.getBlockState(first).getValue((Property)BlockStateProperties.AXIS);
            HitResult rayTrace = Minecraft.getInstance().hitResult;
            if (rayTrace == null || !(rayTrace instanceof BlockHitResult)) {
                if (r.nextInt(50) == 0) {
                    world.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.3f, 0.9f, 0.5f), 1.0f), (double)((float)first.getX() + 0.5f + BeltConnectorHandler.randomOffset(0.25f)), (double)((float)first.getY() + 0.5f + BeltConnectorHandler.randomOffset(0.25f)), (double)((float)first.getZ() + 0.5f + BeltConnectorHandler.randomOffset(0.25f)), 0.0, 0.0, 0.0);
                }
                return;
            }
            BlockPos selected = ((BlockHitResult)rayTrace).getBlockPos();
            if (world.getBlockState(selected).canBeReplaced()) {
                return;
            }
            if (!ShaftBlock.isShaft(world.getBlockState(selected))) {
                selected = selected.relative(((BlockHitResult)rayTrace).getDirection());
            }
            if (!selected.closerThan((Vec3i)first, (double)((Integer)AllConfigs.server().kinetics.maxBeltLength.get()).intValue())) {
                return;
            }
            boolean canConnect = BeltConnectorItem.validateAxis((Level)world, selected) && BeltConnectorItem.canConnect((Level)world, first, selected);
            Vec3 start = Vec3.atLowerCornerOf((Vec3i)first);
            Vec3 end = Vec3.atLowerCornerOf((Vec3i)selected);
            Vec3 actualDiff = end.subtract(start);
            end = end.subtract(axis.choose(actualDiff.x, 0.0, 0.0), axis.choose(0.0, actualDiff.y, 0.0), axis.choose(0.0, 0.0, actualDiff.z));
            Vec3 diff = end.subtract(start);
            double x = Math.abs(diff.x);
            double y = Math.abs(diff.y);
            double z = Math.abs(diff.z);
            float length = (float)Math.max(x, Math.max(y, z));
            Vec3 step = diff.normalize();
            int sames = (x == y ? 1 : 0) + (y == z ? 1 : 0) + (z == x ? 1 : 0);
            if (sames == 0) {
                LinkedList<Vec3> validDiffs = new LinkedList<Vec3>();
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            if (axis.choose(i, j, k) != 0 || axis == Direction.Axis.Y && i != 0 && k != 0 || i == 0 && j == 0 && k == 0) continue;
                            validDiffs.add(new Vec3((double)i, (double)j, (double)k));
                        }
                    }
                }
                int closestIndex = 0;
                float closest = Float.MAX_VALUE;
                for (Vec3 validDiff : validDiffs) {
                    double distanceTo = step.distanceTo(validDiff);
                    if (!(distanceTo < (double)closest)) continue;
                    closest = (float)distanceTo;
                    closestIndex = validDiffs.indexOf(validDiff);
                }
                step = (Vec3)validDiffs.get(closestIndex);
            }
            if (axis == Direction.Axis.Y && step.x != 0.0 && step.z != 0.0) {
                return;
            }
            step = new Vec3(Math.signum(step.x), Math.signum(step.y), Math.signum(step.z));
            for (float f = 0.0f; f < length; f += 0.0625f) {
                Vec3 position = start.add(step.scale((double)f));
                if (r.nextInt(10) != 0) continue;
                world.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(canConnect ? 0.3f : 0.9f, canConnect ? 0.9f : 0.3f, 0.5f), 1.0f), position.x + 0.5, position.y + 0.5, position.z + 0.5, 0.0, 0.0, 0.0);
            }
            return;
        }
    }

    private static float randomOffset(float range) {
        return (r.nextFloat() - 0.5f) * 2.0f * range;
    }
}

