/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.extensions.ICurioSlotExtension;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.CosmeticCurioSlot;
import top.theillusivec4.curios.mixin.core.AccessorEntity;

public class CurioSlot
extends SlotItemHandler {
    private final String identifier;
    private final Player player;
    private final SlotContext slotContext;
    private final ICurioSlotExtension extension;
    private final NonNullList<Boolean> renderStatuses;
    private final boolean canToggleRender;
    private boolean showCosmeticToggle;
    private boolean isCosmetic;

    public CurioSlot(Player player, IDynamicStackHandler handler, int index, String identifier, int xPosition, int yPosition, NonNullList<Boolean> renders, boolean canToggleRender, boolean showCosmeticToggle, boolean isCosmetic) {
        this(player, handler, index, identifier, xPosition, yPosition, renders, canToggleRender);
        this.showCosmeticToggle = showCosmeticToggle;
        this.isCosmetic = isCosmetic;
    }

    public CurioSlot(Player player, IDynamicStackHandler handler, int index, String identifier, int xPosition, int yPosition, NonNullList<Boolean> renders, boolean canToggleRender) {
        super((IItemHandler)handler, index, xPosition, yPosition);
        this.identifier = identifier;
        this.renderStatuses = renders;
        this.player = player;
        this.canToggleRender = canToggleRender;
        this.slotContext = new SlotContext(identifier, (LivingEntity)player, index, this instanceof CosmeticCurioSlot, this instanceof CosmeticCurioSlot || (Boolean)renders.get(index) != false);
        CuriosApi.getSlot(identifier, player.level()).ifPresent(slotType -> this.setBackground(InventoryMenu.BLOCK_ATLAS, slotType.getIcon()));
        this.extension = ICurioSlotExtension.from(identifier);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean canToggleRender() {
        return this.canToggleRender;
    }

    public boolean isCosmetic() {
        return this.isCosmetic;
    }

    public boolean showCosmeticToggle() {
        return this.showCosmeticToggle;
    }

    public ICurioSlotExtension getSlotExtension() {
        return this.extension;
    }

    public SlotContext getSlotContext() {
        return this.slotContext;
    }

    public boolean getRenderStatus() {
        if (!this.canToggleRender) {
            return true;
        }
        return this.renderStatuses.size() > this.getSlotIndex() && (Boolean)this.renderStatuses.get(this.getSlotIndex()) != false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getSlotName() {
        String key;
        StringBuilder builder = new StringBuilder();
        if (this.isCosmetic) {
            builder.append(I18n.get((String)"curios.cosmetic", (Object[])new Object[0])).append(" ");
        }
        if (I18n.exists((String)(key = "curios.identifier." + this.identifier))) {
            builder.append(I18n.get((String)key, (Object[])new Object[0]));
            return builder.toString();
        }
        return builder.append(Character.toUpperCase(this.identifier.charAt(0))).append(this.identifier.substring(1).toLowerCase()).toString();
    }

    public void set(@Nonnull ItemStack stack) {
        ItemStack current = this.getItem();
        boolean flag = current.isEmpty() && stack.isEmpty();
        super.set(stack);
        if (!(flag || ItemStack.matches((ItemStack)current, (ItemStack)stack) || ((AccessorEntity)this.player).getFirstTick())) {
            CuriosApi.getCurio(stack).ifPresent(curio -> curio.onEquipFromUse(this.slotContext));
        }
    }

    public boolean allowModification(@Nonnull Player pPlayer) {
        return true;
    }
}

