/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IPortable;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ItemDrawers
extends BlockItem
implements IPortable {
    public ItemDrawers(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        MutableComponent textCapacity = Component.translatable((String)"tooltip.storagedrawers.drawers.capacity", (Object[])new Object[]{this.getCapacityForBlock(stack)});
        tooltip.add((Component)Component.literal((String)"").append((Component)textCapacity).withStyle(ChatFormatting.GRAY));
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (data != null) {
            MutableComponent textSealed = Component.translatable((String)"tooltip.storagedrawers.drawers.sealed");
            tooltip.add((Component)Component.literal((String)"").append((Component)textSealed).withStyle(ChatFormatting.YELLOW));
        }
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.heavyDrawers.get()).booleanValue() && this.isHeavy(context.registries(), stack)) {
            tooltip.add((Component)Component.translatable((String)"tooltip.storagedrawers.drawers.too_heavy").withStyle(ChatFormatting.RED));
        }
    }

    public Component getName(ItemStack stack) {
        BlockStandardDrawers drawers;
        String matKey;
        String fallback = null;
        Block block = Block.byItem((Item)stack.getItem());
        if (block instanceof BlockStandardDrawers && (matKey = (drawers = (BlockStandardDrawers)block).getMatKey()) != null) {
            String mat = Component.translatable((String)drawers.getNameMatKey()).getString();
            fallback = Component.translatable((String)drawers.getNameTypeKey(), (Object[])new Object[]{mat}).getString();
        }
        return Component.translatableWithFallback((String)this.getDescriptionId(stack), fallback);
    }

    @NotNull
    public Component getDescription() {
        return Component.translatable((String)(this.getDescriptionId() + ".desc"));
    }

    @Override
    public boolean isHeavy(HolderLookup.Provider provider, @NotNull ItemStack stack) {
        if (stack.getItem() != this) {
            return false;
        }
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY);
        if (data.isEmpty()) {
            return false;
        }
        UpgradeData x = new UpgradeData(7);
        try {
            x.read(provider, data.copyTag());
        }
        catch (ClassCastException e) {
            return false;
        }
        return !x.hasPortabilityUpgrade();
    }

    private int getCapacityForBlock(@NotNull ItemStack itemStack) {
        Block block = Block.byItem((Item)itemStack.getItem());
        if (block instanceof BlockDrawers) {
            BlockDrawers blockDrawers = (BlockDrawers)block;
            return blockDrawers.getStorageUnits() * ModCommonConfig.INSTANCE.GENERAL.getBaseStackStorage();
        }
        return 0;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        BlockDrawers bd;
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        return block instanceof BlockDrawers && (bd = (BlockDrawers)block).retrimType() != null;
    }
}

