/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.storage.IControlGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ControllerHostData
extends BlockEntityDataShim {
    private Map<BlockPos, INetworked> nodeMap = new HashMap<BlockPos, INetworked>();

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        this.nodeMap.clear();
        if (tag.contains("RemoteNodes", 9)) {
            ListTag list = tag.getList("RemoteNodes", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag ctag = list.getCompound(i);
                this.nodeMap.put(new BlockPos(ctag.getInt("x"), ctag.getInt("y"), ctag.getInt("z")), null);
            }
        }
    }

    @Override
    public CompoundTag write(HolderLookup.Provider provider, CompoundTag tag) {
        ListTag list = new ListTag();
        for (BlockPos pos : this.nodeMap.keySet()) {
            CompoundTag ctag = new CompoundTag();
            ctag.putInt("x", pos.getX());
            ctag.putInt("y", pos.getY());
            ctag.putInt("z", pos.getZ());
            list.add((Object)ctag);
        }
        tag.put("RemoteNodes", (Tag)list);
        return tag;
    }

    public void validateRemoteNodes(IControlGroup host, Level level) {
        Iterator<Map.Entry<BlockPos, INetworked>> iterator = this.nodeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            INetworked networked;
            BlockPos pos = iterator.next().getKey();
            BlockEntity entity = level.getBlockEntity(pos);
            if (entity instanceof INetworked && (networked = (INetworked)entity).getBoundControlGroup() == host) {
                this.nodeMap.put(pos, networked);
                continue;
            }
            iterator.remove();
        }
    }

    public boolean addRemoteNode(IControlGroup host, INetworked node) {
        if (node == null) {
            return false;
        }
        if (node instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)node;
            BlockPos pos = blockEntity.getBlockPos();
            if (node.getBoundControlGroup() == host) {
                this.nodeMap.put(pos, node);
                return true;
            }
            this.nodeMap.put(pos, null);
        }
        return false;
    }

    public boolean removeRemoteNode(IControlGroup host, INetworked node) {
        BlockEntity blockEntity;
        BlockPos pos;
        if (node == null) {
            return false;
        }
        if (node instanceof BlockEntity && this.nodeMap.containsKey(pos = (blockEntity = (BlockEntity)node).getBlockPos())) {
            this.nodeMap.remove(pos);
            return true;
        }
        return false;
    }

    public Stream<INetworked> getRemoteNodes() {
        return this.nodeMap.values().stream().filter(Objects::nonNull);
    }
}

