/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.jei.common;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.jei.common.ClickableIngredient;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;

class ResourceGuiContainerHandler
implements IGuiContainerHandler<AbstractBaseScreen<?>> {
    private final IIngredientManager ingredientManager;

    ResourceGuiContainerHandler(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(AbstractBaseScreen<?> baseScreen, double mouseX, double mouseY) {
        return this.convertToIngredient(baseScreen.getHoveredResource()).flatMap(this::convertToClickableIngredient);
    }

    public Optional<Object> convertToIngredient(@Nullable PlatformResourceKey resource) {
        if (resource == null) {
            return Optional.empty();
        }
        return RefinedStorageApi.INSTANCE.getIngredientConverter().convertToIngredient(resource);
    }

    private Optional<IClickableIngredient<?>> convertToClickableIngredient(Object ingredient) {
        IIngredientHelper helper = this.ingredientManager.getIngredientHelper(ingredient);
        Optional maybeTypedIngredient = this.ingredientManager.createTypedIngredient(helper.getIngredientType(), ingredient);
        return maybeTypedIngredient.map(typedIngredient -> new ClickableIngredient(typedIngredient, 16, 16));
    }
}

