/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.common.fakelevel;

import com.ldtteam.common.fakelevel.FakeChunk;
import com.ldtteam.common.fakelevel.FakeChunkSource;
import com.ldtteam.common.fakelevel.FakeLevelData;
import com.ldtteam.common.fakelevel.FakeLevelEntityGetterAdapter;
import com.ldtteam.common.fakelevel.FakeLevelLightEngine;
import com.ldtteam.common.fakelevel.IFakeLevelBlockGetter;
import com.ldtteam.common.fakelevel.IFakeLevelLightProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelDataManager;
import org.jetbrains.annotations.Nullable;

public class FakeLevel<SOURCE extends IFakeLevelBlockGetter>
extends Level {
    protected SOURCE levelSource;
    protected final IFakeLevelLightProvider lightProvider;
    protected Level realLevel;
    protected final Scoreboard scoreboard;
    protected final boolean overrideBeLevel;
    protected final FakeChunkSource chunkSource;
    protected final FakeLevelLightEngine lightEngine;
    protected final ModelDataManager modelDataManager;
    protected FakeLevelEntityGetterAdapter levelEntityGetter = FakeLevelEntityGetterAdapter.EMPTY;
    protected Map<BlockPos, BlockEntity> blockEntities = Collections.emptyMap();
    protected BlockPos worldPos = BlockPos.ZERO;
    int lastX;
    int lastZ;
    ChunkAccess lastChunk = null;

    public FakeLevel(SOURCE levelSource, IFakeLevelLightProvider lightProvider, Level realLevel, @Nullable Scoreboard scoreboard, boolean overrideBeLevel) {
        super((WritableLevelData)new FakeLevelData(() -> ((Level)realLevel).getLevelData(), lightProvider), realLevel.dimension(), realLevel.registryAccess(), realLevel.dimensionTypeRegistration(), realLevel.getProfilerSupplier(), realLevel.isClientSide(), false, 0L, 0);
        this.levelSource = levelSource;
        this.lightProvider = lightProvider;
        this.realLevel = realLevel;
        this.scoreboard = scoreboard;
        this.overrideBeLevel = overrideBeLevel;
        this.chunkSource = new FakeChunkSource(this);
        this.modelDataManager = new ModelDataManager((Level)this);
        this.lightEngine = new FakeLevelLightEngine(this);
        this.setRealLevel(realLevel);
        ((FakeLevelData)this.getLevelData()).vanillaLevelData = () -> this.realLevel().getLevelData();
    }

    public void setRealLevel(Level realLevel) {
        if (Objects.equals(this.realLevel, realLevel)) {
            return;
        }
        if (realLevel != null && realLevel.isClientSide != this.isClientSide) {
            throw new IllegalArgumentException("Received wrong sided realLevel - fakeLevel.isClientSide = " + this.isClientSide);
        }
        this.realLevel = realLevel;
    }

    public Level realLevel() {
        return this.realLevel;
    }

    public void setLevelSource(SOURCE levelSource) {
        this.levelSource = levelSource;
    }

    public SOURCE getLevelSource() {
        return this.levelSource;
    }

    public void setWorldPos(BlockPos worldPos) {
        this.worldPos = worldPos;
    }

    public BlockPos getWorldPos() {
        return this.worldPos;
    }

    public void setBlockEntities(Map<BlockPos, BlockEntity> blockEntities) {
        this.blockEntities = blockEntities;
    }

    public void setEntities(Collection<? extends Entity> entities) {
        this.levelEntityGetter = entities.isEmpty() ? FakeLevelEntityGetterAdapter.EMPTY : FakeLevelEntityGetterAdapter.ofEntities(entities);
    }

    public ResourceKey<Level> dimension() {
        return this.realLevel() != null ? this.realLevel().dimension() : super.dimension();
    }

    public RegistryAccess registryAccess() {
        return this.realLevel() != null ? this.realLevel().registryAccess() : super.registryAccess();
    }

    public DamageSources damageSources() {
        return this.realLevel() != null ? this.realLevel().damageSources() : super.damageSources();
    }

    public ProfilerFiller getProfiler() {
        return this.realLevel() != null ? this.realLevel().getProfiler() : super.getProfiler();
    }

    public Supplier<ProfilerFiller> getProfilerSupplier() {
        return this.realLevel() != null ? this.realLevel().getProfilerSupplier() : super.getProfilerSupplier();
    }

    public DimensionType dimensionType() {
        return this.realLevel() != null ? this.realLevel().dimensionType() : super.dimensionType();
    }

    public Holder<DimensionType> dimensionTypeRegistration() {
        return this.realLevel() != null ? this.realLevel().dimensionTypeRegistration() : super.dimensionTypeRegistration();
    }

    public WorldBorder getWorldBorder() {
        return this.realLevel() != null ? this.realLevel().getWorldBorder() : super.getWorldBorder();
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        BlockEntity blockEntity;
        BlockEntity blockEntity2 = blockEntity = this.blockEntities.isEmpty() ? this.levelSource.getBlockEntity(pos) : this.blockEntities.get(pos);
        if (blockEntity != null && blockEntity.getLevel() != this && (this.overrideBeLevel || !blockEntity.hasLevel())) {
            blockEntity.setLevel((Level)this);
        }
        return blockEntity;
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.levelSource.isPosInside(pos) ? this.levelSource.getBlockState(pos) : Blocks.AIR.defaultBlockState();
    }

    public ChunkAccess getChunk(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        if (this.lastX == x && this.lastZ == z && this.lastChunk != null) {
            return this.lastChunk;
        }
        return nonnull || this.hasChunk(x, z) ? new FakeChunk(this, x, z) : null;
    }

    public boolean hasChunk(int chunkX, int chunkZ) {
        int posX = SectionPos.sectionToBlockCoord((int)chunkX);
        int posZ = SectionPos.sectionToBlockCoord((int)chunkZ);
        return this.levelSource.getMinX() <= posX && posX < this.levelSource.getMaxX() && this.levelSource.getMinZ() <= posZ && posZ < this.levelSource.getMaxZ();
    }

    public int getBrightness(LightLayer lightType, BlockPos pos) {
        return this.lightProvider.forceOwnLightLevel() ? this.lightProvider.getBrightness(lightType, pos) : this.realLevel().getBrightness(lightType, this.worldPos.offset((Vec3i)pos));
    }

    public int getRawBrightness(BlockPos pos, int amount) {
        return this.lightProvider.forceOwnLightLevel() ? this.lightProvider.getRawBrightness(pos, amount) : this.realLevel().getRawBrightness(this.worldPos.offset((Vec3i)pos), amount);
    }

    public int getSkyDarken() {
        return this.lightProvider.forceOwnLightLevel() ? this.lightProvider.getSkyDarken() : this.realLevel().getSkyDarken();
    }

    public boolean isDay() {
        return !this.dimensionType().hasFixedTime() && this.getSkyDarken() < 4;
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard == null ? this.realLevel().getScoreboard() : this.scoreboard;
    }

    public FluidState getFluidState(BlockPos pos) {
        return this.levelSource.getFluidState(pos);
    }

    public int getHeight() {
        return this.levelSource.getHeight();
    }

    public int getMinBuildHeight() {
        return this.levelSource.getMinBuildHeight();
    }

    public boolean isInWorldBounds(BlockPos pos) {
        return this.levelSource.isPosInside(pos);
    }

    public CrashReportCategory fillReportDetails(CrashReport report) {
        CrashReportCategory crashreportcategory = report.addCategory("BlockUI fake level");
        this.levelSource.describeSelfInCrashReport(crashreportcategory);
        return crashreportcategory;
    }

    protected LevelEntityGetter<Entity> getEntities() {
        return this.levelEntityGetter;
    }

    @javax.annotation.Nullable
    public Entity getEntity(int id) {
        return (Entity)this.levelEntityGetter.get(id);
    }

    public List<Player> players() {
        ArrayList<Player> result = new ArrayList<Player>();
        this.levelEntityGetter.get(EntityTypeTest.forClass(Player.class), player -> {
            result.add((Player)player);
            return AbortableIterationConsumer.Continuation.CONTINUE;
        });
        return result;
    }

    public int getHeight(Heightmap.Types heightmapType, int x, int z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, this.levelSource.getMinBuildHeight(), z);
        if (this.levelSource.isPosInside((BlockPos)pos)) {
            for (int y = this.levelSource.getMaxBuildHeight() - 1; y >= this.levelSource.getMinBuildHeight(); --y) {
                pos.setY(y);
                if (!heightmapType.isOpaque().test(this.levelSource.getBlockState((BlockPos)pos))) continue;
                return y;
            }
        }
        return this.levelSource.getMinBuildHeight();
    }

    public ChunkSource getChunkSource() {
        return this.chunkSource;
    }

    public ModelData getModelData(BlockPos pos) {
        return this.modelDataManager.getAt(pos);
    }

    @Nullable
    public ModelDataManager getModelDataManager() {
        return this.modelDataManager;
    }

    public LevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    public String gatherChunkSourceStats() {
        return "Fake level for: " + String.valueOf(this.levelSource);
    }

    public float getShade(Direction p_104703_, boolean p_104704_) {
        return this.realLevel().getShade(p_104703_, p_104704_);
    }

    public Holder<Biome> getBiome(BlockPos pos) {
        return this.realLevel().getBiome(this.worldPos.offset((Vec3i)pos));
    }

    public BiomeManager getBiomeManager() {
        return this.realLevel().getBiomeManager();
    }

    public RecipeManager getRecipeManager() {
        return this.realLevel().getRecipeManager();
    }

    public FeatureFlagSet enabledFeatures() {
        return this.realLevel().enabledFeatures();
    }

    public Holder<Biome> getUncachedNoiseBiome(int x, int y, int z) {
        return this.realLevel().getUncachedNoiseBiome(x, y, z);
    }

    public Holder<Biome> getNoiseBiome(int x, int y, int z) {
        return this.realLevel().getNoiseBiome(x, y, z);
    }

    public TickRateManager tickRateManager() {
        return this.realLevel().tickRateManager();
    }

    public PotionBrewing potionBrewing() {
        return this.realLevel().potionBrewing();
    }

    public float getDayTimeFraction() {
        return this.realLevel().getDayTimeFraction();
    }

    public float getDayTimePerTick() {
        return this.realLevel().getDayTimePerTick();
    }

    public Explosion explode(@Nullable Entity p_311934_, @Nullable DamageSource p_312790_, @Nullable ExplosionDamageCalculator p_311975_, double p_312493_, double p_312456_, double p_312719_, float p_312292_, boolean p_312144_, Level.ExplosionInteraction p_312265_, boolean p_312145_, ParticleOptions p_312842_, ParticleOptions p_312060_, Holder<SoundEvent> p_320283_) {
        throw new UnsupportedOperationException("Structurize fake immutable level - no explosions possible!");
    }

    public boolean isLoaded(BlockPos pos) {
        return true;
    }

    public float getRainLevel(float delta) {
        return 0.0f;
    }

    public float getThunderLevel(float delta) {
        return 0.0f;
    }

    public boolean isRainingAt(BlockPos position) {
        return this.isRaining();
    }

    public boolean noSave() {
        return true;
    }

    public int getSeaLevel() {
        return 0;
    }

    public void destroyBlockProgress(int p_46506_, BlockPos p_46507_, int p_46508_) {
    }

    public MapId getFreeMapId() {
        return new MapId(0);
    }

    public MapItemSavedData getMapData(MapId p_324234_) {
        return null;
    }

    public void playSeededSound(@javax.annotation.Nullable Player p_220372_, Entity p_220373_, Holder<SoundEvent> p_263500_, SoundSource p_220375_, float p_220376_, float p_220377_, long p_220378_) {
    }

    public void playSeededSound(@javax.annotation.Nullable Player p_262953_, double p_263004_, double p_263398_, double p_263376_, Holder<SoundEvent> p_263359_, SoundSource p_263020_, float p_263055_, float p_262914_, long p_262991_) {
    }

    public void sendBlockUpdated(BlockPos p_46612_, BlockState p_46613_, BlockState p_46614_, int p_46615_) {
    }

    public void setMapData(MapId p_324009_, MapItemSavedData p_151534_) {
    }

    public void gameEvent(Holder<GameEvent> p_316267_, Vec3 p_220405_, GameEvent.Context p_220406_) {
    }

    public LevelTickAccess<Block> getBlockTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    public LevelTickAccess<Fluid> getFluidTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    public void levelEvent(@javax.annotation.Nullable Player p_46771_, int p_46772_, BlockPos p_46773_, int p_46774_) {
    }

    public void addBlockEntityTicker(TickingBlockEntity p_151526_) {
    }

    public void addFreshBlockEntities(Collection<BlockEntity> beList) {
    }

    public void blockEvent(BlockPos p_46582_, Block p_46583_, int p_46584_, int p_46585_) {
    }

    public void close() throws IOException {
    }

    public boolean destroyBlock(BlockPos p_46626_, boolean p_46627_, @javax.annotation.Nullable Entity p_46628_, int p_46629_) {
        return false;
    }

    public void markAndNotifyBlock(BlockPos p_46605_, @javax.annotation.Nullable LevelChunk levelchunk, BlockState blockstate, BlockState p_46606_, int p_46607_, int p_46608_) {
    }

    public boolean mayInteract(Player p_46557_, BlockPos p_46558_) {
        return false;
    }

    public void neighborShapeChanged(Direction p_220385_, BlockState p_220386_, BlockPos p_220387_, BlockPos p_220388_, int p_220389_, int p_220390_) {
    }

    public boolean removeBlock(BlockPos p_46623_, boolean p_46624_) {
        return false;
    }

    public boolean setBlock(BlockPos p_46605_, BlockState p_46606_, int p_46607_, int p_46608_) {
        return false;
    }

    public void setRainLevel(float p_46735_) {
    }

    public void setSpawnSettings(boolean p_46704_, boolean p_46705_) {
    }

    public void setThunderLevel(float p_46708_) {
    }

    public boolean shouldTickBlocksAt(long p_186456_) {
        return false;
    }

    public boolean shouldTickDeath(Entity p_186458_) {
        return false;
    }

    protected void tickBlockEntities() {
    }

    public void updateNeighborsAt(BlockPos p_46673_, Block p_46674_) {
    }

    public void updateSkyBrightness() {
    }

    @Nullable
    public <T, C> T getCapability(BlockCapability<T, C> cap, BlockPos pos, C context) {
        return null;
    }

    @Nullable
    public <T, C> T getCapability(BlockCapability<T, C> cap, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity blockEntity, C context) {
        return null;
    }

    public void invalidateCapabilities(BlockPos pos) {
    }

    public void invalidateCapabilities(ChunkPos pos) {
    }

    public void setDayTimeFraction(float v) {
    }

    public void setDayTimePerTick(float v) {
    }
}

