/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.hooks;

import com.ldtteam.blockui.BOScreen;
import com.ldtteam.blockui.hooks.HookManager;
import com.ldtteam.blockui.hooks.HookWindow;
import com.ldtteam.blockui.hooks.TriggerMechanism;
import com.ldtteam.blockui.views.ScrollingList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.gui.GuiGraphics;

public class HookScreen
extends BOScreen {
    private final boolean captureScroll;
    private final HookWindow<?, ?> windowTyped;
    private ScrollingList scrollListener = null;

    HookScreen(HookWindow<?, ?> window) {
        super(window);
        this.windowTyped = window;
        this.captureScroll = window.windowHolder.hook.trigger instanceof TriggerMechanism.RayTraceTriggerMechanism;
    }

    @Override
    @Deprecated
    public void render(GuiGraphics target, int mx, int my, float f) {
        this.render(target.pose());
    }

    public void render(PoseStack ms) {
        if (this.minecraft == null || !this.isOpen) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        ms.translate((double)(-this.width / 2), (double)(-this.height), 0.0);
        try {
            throw new UnsupportedOperationException("need port fix");
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)e, (String)"Rendering Hook BO screen");
            CrashReportCategory category = crashReport.addCategory("Hook BO screen rendering details");
            category.setDetail("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.setDetail("Hook thing type", () -> this.windowTyped.getHookThingRegistryKey().toString());
            category.setDetail("Hook thing", () -> this.windowTyped.getHookThing().toString());
            throw new ReportedException(crashReport);
        }
    }

    @Override
    @Deprecated
    public boolean mouseScrolled(double mx, double my, double scrollHorizontalDiff, double scrollVerticalDiff) {
        return this.mouseScrolled(scrollHorizontalDiff * 10.0, scrollVerticalDiff * 10.0);
    }

    public boolean mouseScrolled(double horizontalWheel, double verticalWheel) {
        if (this.captureScroll && this.scrollListener != null && (horizontalWheel != 0.0 || verticalWheel != 0.0)) {
            try {
                return this.scrollListener.scrollInput(horizontalWheel, verticalWheel, this.scrollListener.getX() + 1, this.scrollListener.getY() + 1);
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.forThrowable((Throwable)e, (String)"MouseScroll event for Hook BO screen");
                CrashReportCategory category = crashReport.addCategory("Hook BO screen scroll event details");
                category.setDetail("XML res loc", () -> this.window.getXmlResourceLocation().toString());
                category.setDetail("Scroll value", () -> "X: %d Y: %d".formatted(horizontalWheel, verticalWheel));
                category.setDetail("Hook thing type", () -> this.windowTyped.getHookThingRegistryKey().toString());
                category.setDetail("Hook thing", () -> this.windowTyped.getHookThing().toString());
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    public void init() {
    }

    @Override
    public void tick() {
        try {
            if (this.minecraft != null) {
                if (!this.isOpen) {
                    if (this.captureScroll) {
                        this.scrollListener = this.window.findFirstPaneByType(ScrollingList.class);
                        if (this.scrollListener != null) {
                            HookManager.setScrollListener(this);
                        }
                    }
                    this.window.onOpened();
                    this.isOpen = true;
                } else {
                    this.window.onUpdate();
                }
            }
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)e, (String)"Ticking/Updating Hook BO screen");
            CrashReportCategory category = crashReport.addCategory("Hook BO screen update details");
            category.setDetail("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.setDetail("Is opened", () -> Boolean.toString(this.isOpen));
            category.setDetail("Hook thing type", () -> this.windowTyped.getHookThingRegistryKey().toString());
            category.setDetail("Hook thing", () -> this.windowTyped.getHookThing().toString());
            throw new ReportedException(crashReport);
        }
    }

    @Override
    public void removed() {
        try {
            this.window.onClosed();
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)e, (String)"Closing Hook BO screen");
            CrashReportCategory category = crashReport.addCategory("Hook BO screen closing details");
            category.setDetail("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.setDetail("Is opened", () -> Boolean.toString(this.isOpen));
            throw new ReportedException(crashReport);
        }
        if (HookManager.getScrollListener() == this) {
            HookManager.setScrollListener(null);
        }
    }

    @Override
    public HookWindow<?, ?> getWindow() {
        return this.windowTyped;
    }
}

