/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bettertridents.mixin;

import fuzs.bettertridents.BetterTridents;
import fuzs.bettertridents.capability.TridentSlotCapability;
import fuzs.bettertridents.config.ServerConfig;
import fuzs.bettertridents.init.ModRegistry;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={TridentItem.class})
abstract class TridentItemMixin
extends Item {
    public TridentItemMixin(Item.Properties properties) {
        super(properties);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        if (!((ServerConfig)BetterTridents.CONFIG.get(ServerConfig.class)).repairTridents) {
            return super.isValidRepairItem(stack, repairCandidate);
        }
        return repairCandidate.is(Items.PRISMARINE_SHARD);
    }

    @ModifyVariable(method={"releaseUsing"}, at=@At(value="STORE"), ordinal=0)
    public ThrownTrident releaseUsing(ThrownTrident trident, ItemStack stack, Level level, LivingEntity thrower) {
        if (!((ServerConfig)BetterTridents.CONFIG.get(ServerConfig.class)).returnTridentToSlot) {
            return trident;
        }
        if (thrower.getUseItem() == stack) {
            TridentSlotCapability capability = (TridentSlotCapability)ModRegistry.TRIDENT_SLOT_CAPABILITY.get((Object)trident);
            if (thrower.getUsedItemHand() == InteractionHand.OFF_HAND) {
                capability.setSlot(40);
            } else {
                capability.setSlot(((Player)thrower).getInventory().selected);
            }
        }
        return trident;
    }
}

