/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.gui;

import com.chaosthedude.explorerscompass.gui.ExplorersCompassScreen;
import com.chaosthedude.explorerscompass.gui.StructureSearchEntry;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StructureSearchList
extends ObjectSelectionList<StructureSearchEntry> {
    private final ExplorersCompassScreen parentScreen;

    public StructureSearchList(ExplorersCompassScreen parentScreen, Minecraft mc, int width, int height, int y, int itemHeight) {
        super(mc, width, height, y, itemHeight);
        this.parentScreen = parentScreen;
        this.refreshList();
    }

    protected int getScrollbarPosition() {
        return this.getRowLeft() + this.getRowWidth() - 2;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 50;
    }

    protected boolean isSelectedItem(int slotIndex) {
        return slotIndex >= 0 && slotIndex < this.children().size() ? ((Object)((Object)((StructureSearchEntry)((Object)this.children().get(slotIndex))))).equals(this.getSelected()) : false;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fill(this.getRowLeft() - 4, this.getY(), this.getRowLeft() + this.getRowWidth() + 4, this.getY() + this.getHeight() + 4, 0x7F000000);
        this.enableScissor(guiGraphics);
        for (int j = 0; j < this.getItemCount(); ++j) {
            int rowTop = this.getRowTop(j);
            int rowBottom = this.getRowBottom(j);
            if (rowBottom < this.getY() || rowTop > this.getBottom()) continue;
            int j1 = this.itemHeight - 4;
            StructureSearchEntry entry = (StructureSearchEntry)this.getEntry(j);
            if (this.isSelectedItem(j)) {
                int insideLeft = this.getX() + this.width / 2 - this.getRowWidth() / 2 + 2;
                guiGraphics.fill(insideLeft - 4, rowTop - 4, insideLeft + this.getRowWidth() + 4, rowTop + this.itemHeight, 0x7F000000);
            }
            entry.render(guiGraphics, j, rowTop, this.getRowLeft(), this.getRowWidth(), j1, mouseX, mouseY, this.isMouseOver(mouseX, mouseY) && Objects.equals(this.getEntryAtPosition(mouseX, mouseY), (Object)entry), partialTicks);
        }
        guiGraphics.disableScissor();
        if (this.getMaxScroll() > 0) {
            int left = this.getScrollbarPosition();
            int right = left + 6;
            int height = (int)((float)((this.getBottom() - this.getY()) * (this.getBottom() - this.getY())) / (float)this.getMaxPosition());
            height = Mth.clamp((int)height, (int)32, (int)(this.getBottom() - this.getY() - 8));
            int top = (int)this.getScrollAmount() * (this.getBottom() - this.getY() - height) / this.getMaxScroll() + this.getY();
            if (top < this.getY()) {
                top = this.getY();
            }
            guiGraphics.fill(left, this.getY(), right, this.getBottom(), 0x2B000000);
            guiGraphics.fill(left, top, right, top + height, -234881024);
        }
    }

    protected void enableScissor(GuiGraphics guiGraphics) {
        guiGraphics.enableScissor(this.getX(), this.getY(), this.getRight(), this.getBottom());
    }

    protected int getRowBottom(int index) {
        return this.getRowTop(index) + this.itemHeight;
    }

    public void refreshList() {
        this.clearEntries();
        for (ResourceLocation key : this.parentScreen.sortStructures()) {
            this.addEntry((AbstractSelectionList.Entry)new StructureSearchEntry(this, key));
        }
        this.selectStructure(null);
        this.setScrollAmount(0.0);
    }

    public void selectStructure(StructureSearchEntry entry) {
        this.setSelected((AbstractSelectionList.Entry)entry);
        this.parentScreen.selectStructure(entry);
    }

    public boolean hasSelection() {
        return this.getSelected() != null;
    }

    public ExplorersCompassScreen getParentScreen() {
        return this.parentScreen;
    }
}

