/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.convenientcurioscontainer.network;

import com.leobeliik.convenientcurioscontainer.common.ConvenientMenuProvider;
import com.leobeliik.convenientcurioscontainer.items.ConvenientItem;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SwitchCCC(boolean open) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<SwitchCCC> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"convenientcurioscontainer", (String)"open_ccc"));
    static final StreamCodec<RegistryFriendlyByteBuf, SwitchCCC> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, SwitchCCC::open, SwitchCCC::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static SwitchCCC create(boolean open) {
        return new SwitchCCC(open);
    }

    void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            ItemStack offItem = player.getItemInHand(InteractionHand.OFF_HAND);
            ItemStack onItem = player.getItemInHand(InteractionHand.MAIN_HAND);
            if (onItem.getItem() instanceof ConvenientItem) {
                this.interact(player, onItem);
            } else if (offItem.getItem() instanceof ConvenientItem) {
                this.interact(player, offItem);
            } else {
                player.getInventory().items.stream().filter(itemStack -> itemStack.getItem() instanceof ConvenientItem).findFirst().ifPresent(itemStack -> this.interact(player, (ItemStack)itemStack));
            }
        });
    }

    private void interact(ServerPlayer player, ItemStack stack) {
        if (this.open) {
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(1));
            player.openMenu(ConvenientMenuProvider.MenuProvider(stack));
        } else {
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0));
        }
    }
}

