/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.convenientcurioscontainer.gui;

import com.leobeliik.convenientcurioscontainer.ConvenientClientReg;
import com.leobeliik.convenientcurioscontainer.common.ConvenientMenu;
import com.leobeliik.convenientcurioscontainer.network.Networking;
import com.leobeliik.convenientcurioscontainer.network.SwitchCCC;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.client.ICuriosScreen;
import top.theillusivec4.curios.common.inventory.CurioSlot;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;

public class ConvenientScreen
extends AbstractContainerScreen<ConvenientMenu>
implements ICuriosScreen {
    private static final ResourceLocation CONTAINER_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"convenientcurioscontainer", (String)"textures/gui/convenient_screen.png");
    private static final ResourceLocation CURIO_INVENTORY = ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"textures/gui/curios/inventory.png");
    private final int xSize = 176;
    private final int ySize = 222;
    private Button btnNext;
    private Button btnPrev;

    public ConvenientScreen(ConvenientMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.imageHeight = 222;
        this.inventoryLabelY = 129;
    }

    protected void init() {
        this.addButtons();
        super.init();
    }

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(ms, mouseX, mouseY, partialTicks);
        super.render(ms, mouseX, mouseY, partialTicks);
        if (((ConvenientMenu)this.getMenu()).container.totalPages > 1) {
            this.renderWidgets(ms, mouseX, mouseY, partialTicks);
        }
        this.renderTooltip(ms, mouseX, mouseY);
    }

    @ParametersAreNonnullByDefault
    protected void renderBg(GuiGraphics ms, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CONTAINER_BACKGROUND);
        ms.blit(CONTAINER_BACKGROUND, this.getX(), this.getY(), 0, 0, 176, 222);
        this.renderCuriosPage(ms, partialTicks, mouseX, mouseY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.getInstance().options.keyInventory.matches(keyCode, scanCode) || ((KeyMapping)ConvenientClientReg.OPEN_CONVENIENT_SCREEN_KEY.get()).matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void renderTooltip(@NotNull GuiGraphics ms, int mouseX, int mouseY) {
        if (((ConvenientMenu)this.getMenu()).container.totalPages > 1 && mouseX > 97 && mouseX < 216 && mouseY > 11 && mouseY < 23) {
            ms.renderTooltip(this.font, (Component)Component.translatable((String)"gui.curios.page", (Object[])new Object[]{((ConvenientMenu)this.getMenu()).container.currentPage + 1, ((ConvenientMenu)this.getMenu()).container.totalPages}), mouseX, mouseY);
        }
        if (mouseX > this.getX() + 162 && mouseX < this.getX() + 172 && mouseY > this.getY() + 4 && mouseY < this.getY() + 14) {
            ms.renderTooltip(this.font, List.of(Component.translatable((String)"gui.container_info").withStyle(ChatFormatting.AQUA), Component.translatable((String)"gui.container_RMB").withStyle(ChatFormatting.GRAY), Component.translatable((String)"gui.container_SRMB").withStyle(ChatFormatting.GRAY)), Optional.empty(), mouseX, mouseY + 5);
        }
        super.renderTooltip(ms, mouseX, mouseY);
    }

    private void addButtons() {
        this.btnNext = Button.builder((Component)Component.empty(), b -> ((ConvenientMenu)this.getMenu()).ChangePage(true)).pos(this.getX() - 17, this.getY() + 2).size(11, 12).build();
        ((Button)this.addWidget((GuiEventListener)this.btnNext)).visible = ((ConvenientMenu)this.getMenu()).container.totalPages > 1;
        this.btnPrev = Button.builder((Component)Component.empty(), b -> ((ConvenientMenu)this.getMenu()).ChangePage(false)).pos(this.getX() - 28, this.getY() + 2).size(11, 12).build();
        ((Button)this.addWidget((GuiEventListener)this.btnPrev)).visible = ((ConvenientMenu)this.getMenu()).container.totalPages > 1;
    }

    private void renderWidgets(@Nonnull GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        int btnNextRenderY = ((ConvenientMenu)this.getMenu()).container.currentPage + 1 == ((ConvenientMenu)this.getMenu()).container.totalPages ? 37 : 25;
        int btnNextRenderX = this.btnNext.isMouseOver((double)x, (double)y) ? 65 : 43;
        guiGraphics.blit(CURIO_INVENTORY, this.getX() - 17, this.getY() + 2, btnNextRenderX, btnNextRenderY, 11, 12);
        this.btnNext.active = btnNextRenderY == 25;
        int btnPrevRenderY = ((ConvenientMenu)this.getMenu()).container.currentPage == 0 ? 37 : 25;
        int btnPrevRenderX = this.btnPrev.isMouseOver((double)x, (double)y) ? 54 : 32;
        guiGraphics.blit(CURIO_INVENTORY, this.getX() - 28, this.getY() + 2, btnPrevRenderX, btnPrevRenderY, 11, 12);
        this.btnPrev.active = btnPrevRenderY == 25;
    }

    private void renderCuriosPage(GuiGraphics ms, float partialTicks, int mouseX, int mouseY) {
        if (this.minecraft != null && this.minecraft.player != null) {
            CuriosContainer container = ((ConvenientMenu)this.getMenu()).container;
            int i = this.getX();
            int j = this.getY();
            CuriosApi.getCuriosInventory((LivingEntity)this.minecraft.player).ifPresent(handler -> {
                int upperHeight;
                int rows;
                boolean pageOffset;
                int xOffset = -33;
                int yOffset = j;
                boolean bl = pageOffset = container.totalPages > 1;
                if (container.hasCosmetics) {
                    ms.blit(CURIO_INVENTORY, i + xOffset + 2, yOffset - 23, 32, 0, 28, 24);
                }
                List grid = container.grid;
                xOffset -= (grid.size() - 1) * 18;
                for (int r = 0; r < grid.size(); ++r) {
                    rows = (Integer)grid.getFirst();
                    upperHeight = 7 + rows * 18;
                    int xTexOffset = 91;
                    if (pageOffset) {
                        upperHeight += 8;
                    }
                    if (r != 0) {
                        xTexOffset += 7;
                    }
                    ms.blit(CURIO_INVENTORY, i + xOffset, yOffset, xTexOffset, 0, 25, upperHeight);
                    ms.blit(CURIO_INVENTORY, i + xOffset, yOffset + upperHeight, xTexOffset, 159, 25, 7);
                    if (grid.size() == 1) {
                        ms.blit(CURIO_INVENTORY, i + xOffset + 7, yOffset, xTexOffset += 7, 0, 25, upperHeight);
                        ms.blit(CURIO_INVENTORY, i + xOffset + 7, yOffset + upperHeight, xTexOffset, 159, 25, 7);
                    }
                    xOffset += r == 0 ? 25 : 18;
                }
                xOffset -= grid.size() * 18;
                if (pageOffset) {
                    yOffset += 8;
                }
                Iterator iterator = grid.iterator();
                while (iterator.hasNext()) {
                    rows = (Integer)iterator.next();
                    upperHeight = rows * 18;
                    ms.blit(CURIO_INVENTORY, i + xOffset, yOffset + 7, 7, 7, 18, upperHeight);
                    xOffset += 18;
                }
                RenderSystem.enableBlend();
                for (Slot slot : ((ConvenientMenu)this.getMenu()).slots) {
                    CurioSlot curioSlot;
                    if (!(slot instanceof CurioSlot) || !(curioSlot = (CurioSlot)slot).isCosmetic()) continue;
                    ms.blit(CURIO_INVENTORY, slot.x + this.getX() - 1, slot.y + this.getY() - 1, 32, 50, 18, 18);
                }
                RenderSystem.disableBlend();
            });
        }
    }

    private int getX() {
        return (this.width - 176) / 2;
    }

    private int getY() {
        return (this.height - 222) / 2;
    }

    public void onClose() {
        Networking.sendToServer(new SwitchCCC(false));
        super.onClose();
    }
}

