/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.convenientcurioscontainer.common;

import com.leobeliik.convenientcurioscontainer.ConvenientCuriosContainer;
import com.leobeliik.convenientcurioscontainer.items.ConvenientItem;
import com.leobeliik.convenientcurioscontainer.network.Networking;
import com.leobeliik.convenientcurioscontainer.network.PageChange;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.common.inventory.CurioSlot;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;

public class ConvenientMenu
extends AbstractContainerMenu {
    private final ItemStackHandler ccItemHandler;
    private final Player player;
    public final CuriosContainer container;

    public ConvenientMenu(int containerId, Inventory playerInv) {
        this(containerId, playerInv, new ItemStackHandler(54));
    }

    ConvenientMenu(int containerId, Inventory playerInv, ItemStackHandler ccItemHandler) {
        super(ConvenientCuriosContainer.CONVENIENT_MENU.get(), containerId);
        this.player = playerInv.player;
        this.container = new CuriosContainer(containerId, playerInv);
        this.ccItemHandler = ccItemHandler;
        this.fillSlots();
    }

    private void fillSlots() {
        this.addContainerSlots();
        this.addPlayerInvSlots();
        this.addCuriosSlots();
        this.broadcastChanges();
    }

    private void addCuriosSlots() {
        this.container.slots.stream().filter(slot -> slot instanceof CurioSlot).forEach(slot -> {
            slot.index -= 46;
            this.addSlot((Slot)slot);
        });
    }

    private void addContainerSlots() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.ccItemHandler, j + i * 9, j * 18 + 8, i * 18 + 18));
            }
        }
    }

    private void addPlayerInvSlots() {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)this.player.getInventory(), j + i * 9 + 9, j * 18 + 8, i * 18 + 140));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)this.player.getInventory(), i, i * 18 + 8, 198));
        }
    }

    public void clicked(int slot, int mouseClick, @NotNull ClickType type, @NotNull Player player) {
        if (slot >= 54 && slot < 90 && this.getSlot(slot).hasItem() && this.getSlot(slot).getItem().getItem() instanceof ConvenientItem) {
            return;
        }
        if (mouseClick == 1 && slot >= 0 && slot < 54 && this.getSlot(slot).hasItem()) {
            if (type == ClickType.PICKUP) {
                this.swapCurios(this.getSlot(slot), player, false);
                return;
            }
            if (type == ClickType.QUICK_MOVE) {
                this.swapCurios(this.getSlot(slot), player, true);
                return;
            }
        }
        super.clicked(slot, mouseClick, type, player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemStackCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStackOG = slot.getItem();
            itemStackCopy = itemStackOG.copy();
            int size = 54;
            int curioSlotSize = this.slots.size() - 90;
            if (index < size ? !this.moveItemStackTo(itemStackOG, size, this.slots.size() - curioSlotSize, true) : !this.moveItemStackTo(itemStackOG, 0, size, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStackOG.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStackCopy;
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public void ChangePage(boolean b) {
        this.slots.clear();
        if (this.player.level().isClientSide()) {
            Networking.sendToServer(new PageChange(b));
        }
        if (b) {
            this.container.nextPage();
        } else {
            this.container.prevPage();
        }
        this.fillSlots();
    }

    public void ClearSlots() {
        this.slots.clear();
        this.container.resetSlots();
        this.fillSlots();
    }

    private void swapCurios(Slot slot, Player player, boolean secondSlot) {
        ItemStack curiosItem = null;
        ItemStack containerItem = slot.getItem();
        Slot curioSlot = null;
        for (Slot cs : this.slots) {
            if (!(cs instanceof CurioSlot) || !cs.mayPlace(containerItem)) continue;
            if (secondSlot) {
                secondSlot = false;
                continue;
            }
            curiosItem = cs.getItem();
            curioSlot = cs;
            break;
        }
        if (curiosItem == null) {
            return;
        }
        if (!curiosItem.isEmpty() || !containerItem.isEmpty()) {
            if (curiosItem.isEmpty()) {
                if (slot.mayPickup(player)) {
                    curioSlot.set(containerItem);
                    slot.set(ItemStack.EMPTY);
                    slot.onTake(player, containerItem);
                }
            } else if (slot.mayPickup(player) && slot.mayPlace(curiosItem) && curioSlot.mayPickup(player)) {
                int l1 = slot.getMaxStackSize(curiosItem);
                if (curiosItem.getCount() > l1) {
                    slot.set(curiosItem.split(l1));
                    slot.onTake(player, containerItem);
                    if (!curioSlot.mayPlace(containerItem)) {
                        player.drop(containerItem, true);
                    }
                } else {
                    slot.set(curiosItem);
                    curioSlot.set(containerItem);
                    slot.onTake(player, containerItem);
                }
            }
        }
    }
}

